/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageReceiverDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.iam.UserDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.MqDataRemindService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.SendMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.ActivityDefineNewMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.ActivityDefine;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MqDataRemindServiceImpl
implements MqDataRemindService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqDataRemindServiceImpl.class);
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    EocService eocService;
    @Autowired
    MessageUtils messageUtils;
    @Autowired
    UserService userService;
    @Autowired
    private PtmService ptmService;
    @Autowired
    BacklogMapper backlogMapper;
    @Autowired
    ActivityDefineNewMapper activityDefineNewMapper;

    @Override
    public void sendTaskChargerNewBacklog(Backlog backlog, Task task, AuthoredUser authoredUser) {
        log.info("\u3010sendTaskChargerNewBacklog-start-task\uff1a{}\u3011\uff1a", (Object)task);
        LogDto logDto = new LogDto("PTM\u4efb\u52a1\u5b9e\u65f6\u5de5\u4f5c\u63d0\u9192\uff0c\u53d1\u9001\u6d88\u606f\u7ed9\u5f53\u8d23\u8005\uff0c\u5f85\u529eId\uff1a" + backlog.getId(), authoredUser.getTenantId() + ";" + backlog.getId());
        log.info(logDto.toString());
        UserDTO userDTO = this.getTargetUser(task.getPersonInCharge(), authoredUser);
        if (userDTO == null) {
            return;
        }
        log.info("\u3010sendTaskChargerNewBacklog-userDTO\uff1a{}\u3011\uff1a", (Object)userDTO);
        String langName = this.userService.getUserLangMetadataAllTenant(userDTO.getId(), authoredUser.getToken());
        if (StringUtils.isEmpty((Object)langName)) {
            langName = "zh_TW";
        }
        log.info("\u3010sendTaskChargerNewBacklog-langName\uff1a{}\u3011\uff1a", (Object)langName);
        boolean isSendMsg = false;
        if (task.getImportance() > 0 || task.getEmergency() > 0) {
            isSendMsg = true;
        }
        String title = String.format("%s~%s%s", TimeUtils.format((LocalDateTime)task.getStartTime(), (String)"yyyy/MM/dd"), TimeUtils.format((LocalDateTime)task.getEndTime(), (String)"MM/dd"), MessageUtils.getMessageByLanguage((Object)task.getTargetName(), (String)langName));
        String msg = String.format("%s " + this.messageUtils.getMessageByLangName("backlog.status.executing", langName), MessageUtils.getMessageByLanguage((Object)backlog.getContentWithName(), (String)langName));
        AppMessageDTO appMessageDTO = new AppMessageDTO();
        appMessageDTO.setSource("athena");
        appMessageDTO.setTitle(title);
        appMessageDTO.setType("task");
        appMessageDTO.setSubType(task.getTmTaskId());
        appMessageDTO.setAuthoredUser(authoredUser);
        appMessageDTO.setTask(task);
        appMessageDTO.setBacklog(backlog);
        appMessageDTO.setTargetUser(userDTO);
        appMessageDTO.setPush(isSendMsg);
        appMessageDTO.setCategoryKey("MessageCenter");
        appMessageDTO.setCreatorName("Athena");
        appMessageDTO.setDetailUrl("offline://detail/" + task.getId());
        appMessageDTO.setMsg(msg);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", task.getId().toString());
        map.put("title", title);
        map.put("startTime", task.getStartTime());
        map.put("endTime", task.getEndTime());
        map.put("name", MessageUtils.getMessageByLanguage((Object)task.getTargetName(), (String)langName));
        map.put("msg", msg);
        map.put("status", 0);
        appMessageDTO.setContent(map);
        AppMessageReceiverDTO appMessageReceiverDTO = new AppMessageReceiverDTO();
        appMessageReceiverDTO.setTenantSid(authoredUser.getTenantSid());
        appMessageReceiverDTO.setTenantId(authoredUser.getTenantId());
        appMessageReceiverDTO.setUserSid(userDTO.getSid());
        appMessageReceiverDTO.setUserId(userDTO.getId());
        ArrayList<AppMessageReceiverDTO> receiverList = new ArrayList<AppMessageReceiverDTO>();
        receiverList.add(appMessageReceiverDTO);
        appMessageDTO.setReceivers(receiverList);
        appMessageDTO.setEmailPush(Boolean.FALSE);
        log.info("\u3010sendTaskChargerNewBacklog-appMessageDTO\uff1a{}\u3011\uff1a", (Object)appMessageDTO);
        this.sendMessageService.sendMessageRemindToClient(authoredUser.getToken(), authoredUser.getTenantId(), userDTO.getId(), appMessageDTO);
    }

    @Override
    public void sendPerformerNewBacklog(Backlog backlog, Task task, AuthoredUser authoredUser) {
        ActivityDefine activityDefine;
        LogDto logDto = new LogDto("PTM\u4efb\u52a1\u5b9e\u65f6\u5de5\u4f5c\u63d0\u9192\uff0c\u53d1\u9001\u6d88\u606f\u7ed9\u6267\u884c\u8005\uff0c\u5f85\u529eId\uff1a" + backlog.getId(), authoredUser.getTenantId() + ";" + backlog.getId());
        log.info(logDto.toString());
        UserDTO userDTO = this.getTargetUser(backlog.getPerformerId(), authoredUser);
        if (userDTO == null) {
            return;
        }
        String langName = this.userService.getUserLangMetadataAllTenant(userDTO.getId(), authoredUser.getToken());
        if (StringUtils.isEmpty((Object)langName)) {
            langName = "zh_TW";
        }
        log.info("\u3010sendPerformerNewBacklog-langName\uff1a{}\u3011\uff1a", (Object)langName);
        boolean isSendMsg = false;
        if (backlog.getImportance() > 0) {
            isSendMsg = true;
        }
        String subType = (activityDefine = this.activityDefineNewMapper.selectByBacklogId(backlog.getId())) != null ? activityDefine.getTmActivityId() : backlog.getActivityCode();
        String msg = "";
        String backlogName = MessageUtils.getMessageByLanguage((Object)(!StringUtils.isEmpty((Object)backlog.getWithName()) ? backlog.getWithName() : backlog.getName()), (String)langName);
        msg = backlog.getImportance() > 0 ? String.format(this.messageUtils.getMessageByLangName("backlog.remind", langName), MessageUtils.getMessageByLanguage((Object)backlogName, (String)langName)) : String.format(this.messageUtils.getMessageByLangName("backlog.new", langName), MessageUtils.getMessageByLanguage((Object)backlogName, (String)langName));
        String title = String.format("%s~%s%s", TimeUtils.format((LocalDateTime)task.getStartTime(), (String)"yyyy/MM/dd"), TimeUtils.format((LocalDateTime)task.getEndTime(), (String)"MM/dd"), MessageUtils.getMessageByLanguage((Object)task.getTargetName(), (String)langName));
        AppMessageDTO appMessageDTO = new AppMessageDTO();
        appMessageDTO.setSource("athena");
        appMessageDTO.setTitle(title);
        appMessageDTO.setType("activity");
        appMessageDTO.setPush(isSendMsg);
        appMessageDTO.setSubType(subType);
        appMessageDTO.setAuthoredUser(authoredUser);
        appMessageDTO.setTask(task);
        appMessageDTO.setTargetUser(userDTO);
        appMessageDTO.setBacklog(backlog);
        Map mainWorkItem = this.backlogMapper.getBacklogDetail4BacklogId(backlog.getId(), Boolean.valueOf(true));
        Long backlogId = mainWorkItem != null ? mainWorkItem.get("id") : backlog.getId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", backlogId);
        map.put("title", backlogName);
        map.put("startTime", backlog.getStartTime());
        map.put("endTime", backlog.getEndTime());
        map.put("name", MessageUtils.getMessageByLanguage((Object)task.getTargetName(), (String)langName));
        map.put("status", 0);
        map.put("msg", msg);
        appMessageDTO.setContent(map);
        AppMessageReceiverDTO appMessageReceiverDTO = new AppMessageReceiverDTO();
        appMessageReceiverDTO.setTenantSid(authoredUser.getTenantSid());
        appMessageReceiverDTO.setTenantId(authoredUser.getTenantId());
        appMessageReceiverDTO.setUserSid(userDTO.getSid());
        appMessageReceiverDTO.setUserId(userDTO.getId());
        ArrayList<AppMessageReceiverDTO> receiverList = new ArrayList<AppMessageReceiverDTO>();
        receiverList.add(appMessageReceiverDTO);
        appMessageDTO.setReceivers(receiverList);
        appMessageDTO.setEmailPush(Boolean.FALSE);
        this.sendMessageService.sendMessageRemindToClient(authoredUser.getToken(), authoredUser.getTenantId(), userDTO.getId(), appMessageDTO);
    }

    private UserDTO getTargetUser(String userId, AuthoredUser authoredUser) {
        return this.getTargetUser(userId, authoredUser.getToken());
    }

    private UserDTO getTargetUser(String userId, String token) {
        UserDTO targetUser = null;
        ProxyUserResp proxyUserResp = this.eocService.getProxyUser(userId, token);
        if (proxyUserResp != null && StringUtils.hasText((String)proxyUserResp.getUserId())) {
            targetUser = this.userService.query(proxyUserResp.getUserId(), token);
        }
        if (targetUser == null) {
            targetUser = this.userService.query(userId, token);
        }
        return targetUser;
    }
}

