/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.PtmBackLogMsgDto;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.PtmTaskTimelyMsgDto;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.WorkItemMessageDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.MqDataRemindService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.MqManageMsgService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.SendMessageService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.WorkItemMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmWorkItemRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.util.Collections;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqManageMsgServiceImpl
implements MqManageMsgService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqManageMsgServiceImpl.class);
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    EocService eocService;
    @Autowired
    MessageUtils messageUtils;
    @Autowired
    UserService userService;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private MqDataRemindService mqDataRemindService;
    @Autowired
    private WorkItemMessageService workItemMessageService;

    @Override
    public void excuteSendTaskTimelyRemindMsg(PtmTaskTimelyMsgDto ptmTaskTimelyMsgDto) {
        AuthoredUser authoredUser = ptmTaskTimelyMsgDto.getAuthoredUser();
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        Backlog backlog = ptmTaskTimelyMsgDto.getBacklog();
        Task task = ptmTaskTimelyMsgDto.getTask();
        if (task == null || backlog == null) {
            log.info("\u6570\u636e\u5f02\u5e38\uff0cmqtt\u53d1\u9001\u6d88\u606f\u5931\u8d25");
            return;
        }
        this.mqDataRemindService.sendTaskChargerNewBacklog(backlog, task, authoredUser);
        this.mqDataRemindService.sendPerformerNewBacklog(backlog, task, authoredUser);
    }

    @Override
    public void excutesendBackLogRemindMsg(PtmBackLogMsgDto ptmBackLogMsgDto) {
        String backlogName;
        if (ptmBackLogMsgDto == null || ptmBackLogMsgDto.getAuthoredUser() == null || ptmBackLogMsgDto.getBacklog() == null || !PtmMqOperation.ADD.equals((Object)ptmBackLogMsgDto.getOperation())) {
            return;
        }
        AuthoredUser authoredUser = ptmBackLogMsgDto.getAuthoredUser();
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        log.info("[send new backlog message]");
        PtmBacklogMessageDTO.Backlog backlog = ptmBackLogMsgDto.getBacklog();
        PtmProjectRecordBO projectRecordDTO = this.ptmService.getProjectRecord(backlog.getProjectId());
        String projectName = StringUtils.isNotEmpty((String)projectRecordDTO.getProjectName()) ? projectRecordDTO.getProjectName() : projectRecordDTO.getProjectDefName();
        String backlogId = String.valueOf(backlog.getBacklogId() == null ? 0L : backlog.getBacklogId());
        LogDto logDto = new LogDto("PTM \u5f85\u529e\u521b\u5efa/\u5173\u95ed\u540e\uff0c\u5904\u7406\u7ed9\u6267\u884c\u8005\u53d1\u9001\u7684\u6d88\u606f\uff0c\u5f85\u529eId\uff1a" + backlogId, authoredUser.getTenantId() + ";" + backlogId);
        log.info(logDto.toString());
        WorkItemMessageDTO.Project project = WorkItemMessageDTO.Project.builder().projectId(backlog.getProjectId()).projectCardId(backlog.getProjectCardId()).projectDefCode(projectRecordDTO.getProjectDefCode()).name(projectName).startTime(projectRecordDTO.getStartTime()).endTime(projectRecordDTO.getEndTime()).emergency(projectRecordDTO.getEmergency()).personInCharge(projectRecordDTO.getPersonInCharge()).personInChargeName(projectRecordDTO.getPersonInChargeName()).engineType(projectRecordDTO.getEngine()).build();
        PtmTaskRecordBO taskRecordDTO = this.ptmService.getTaskRecord(backlog.getTaskId(), null);
        String string = backlogName = StringUtils.isNotBlank((String)taskRecordDTO.getTaskName()) ? taskRecordDTO.getTaskName() : taskRecordDTO.getTaskDefName();
        if (ptmBackLogMsgDto.isMinSplit() && StringUtils.isNotBlank((String)backlog.getName())) {
            backlogName = backlog.getName();
        }
        WorkItemMessageDTO.Task task = WorkItemMessageDTO.Task.builder().taskName(backlogName).createTime(taskRecordDTO.getCreateTime()).planEndTime(taskRecordDTO.getPlanEndTime()).tmActivityId(taskRecordDTO.getTaskDefCode()).tmActivityName(taskRecordDTO.getTaskDefName()).hasException(taskRecordDTO.getHasException()).build();
        PtmWorkItemRecordBO workItemRecordDTO = this.ptmService.getWorkItemRecord(ptmBackLogMsgDto.getWorkItemId());
        WorkItemMessageDTO.WorkItem workItem = WorkItemMessageDTO.WorkItem.builder().id(backlog.getBacklogId()).workItemId(ptmBackLogMsgDto.getWorkItemId()).performerId(backlog.getPerformerId()).performerName(backlog.getPerformerName()).createType(workItemRecordDTO.getCreateType()).fromWorkItemId(workItemRecordDTO.getFromWorkItemId()).build();
        WorkItemMessageDTO messageDTO = WorkItemMessageDTO.builder().project(project).minSplit(ptmBackLogMsgDto.isMinSplit()).task(task).backlog(backlog).workItemList(Collections.singletonList(workItem)).messageType(ptmBackLogMsgDto.getMessageType()).build();
        this.workItemMessageService.sendWorkItemMessage(messageDTO, authoredUser);
    }
}

