/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.TaskCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRecordDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRouteDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.service.atmc.migration.tenantToken.TenantTokenService;
import com.digiwin.athena.abt.application.utils.ManualTaskUtil;
import com.digiwin.athena.abt.application.utils.SummaryMessagesUtils;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.ActivityChangeInfoMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.BacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmActivityRecordDTO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmMergeBacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskCardItemBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmWorkItemRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.ActivityChangeInfo;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Route;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PtmTransformServiceImpl
implements PtmTransformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmTransformServiceImpl.class);
    public static final String ATHENA = "athena";
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private ActivityChangeInfoMapper activityChangeInfoMapper;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private TenantTokenService tenantTokenService;

    @Override
    public Task translateProjectOrProjectCard(Long id) {
        if (!this.enablePTM()) {
            return null;
        }
        Task task = null;
        PtmProjectRecordBO project = this.ptmService.getProjectRecord(id);
        if (project != null) {
            PtmProjectCardRecordDTO projectCard = this.ptmService.getProjectCardRecord(project.getProjectCardId());
            task = Task.builder().id(project.getId()).tmTaskId(project.getProjectDefCode()).personInCharge(project.getPersonInCharge()).personInChargeName(project.getPersonInChargeName()).dataFrom("PTM").targetName(projectCard.getTargetName()).importance(Integer.valueOf(project.getImportance() != false ? 1 : 0)).startTime(project.getStartTime()).endTime(project.getEndTime()).build();
        } else {
            PtmProjectCardRecordDTO projectCard = this.ptmService.getProjectCardRecord(id);
            task = Task.builder().id(projectCard.getId()).tmTaskId(projectCard.getProjectDefCode()).personInCharge(projectCard.getPersonInCharge()).personInChargeName(projectCard.getPersonInChargeName()).dataFrom("PTM").targetName(projectCard.getTargetName()).importance(Integer.valueOf(0)).startTime(projectCard.getStartTime()).endTime(projectCard.getEndTime()).build();
        }
        return task;
    }

    @Override
    public boolean enablePTM() {
        return StringUtils.isNotBlank((String)this.envProperties.getPtmUri());
    }

    @Override
    public Route getRouteByProjectId(Long projectId) {
        Route result = null;
        if (!this.enablePTM()) {
            return result;
        }
        PtmProjectCardRouteDTO ptmRoute = this.ptmService.getProjectRoute(projectId);
        if (ptmRoute != null && CollectionUtils.isNotEmpty(ptmRoute.getRoutes())) {
            PtmProjectCardRouteDTO.RouteDTO r = ptmRoute.getRoutes().get(0);
            result = Route.builder().id(r.getId()).routeName(r.getRouteName()).pass(r.getPass()).mainTaskId(r.getProjectCardId()).taskId(r.getProjectId()).routeOrder(r.getRouteOrder()).selected(r.getSelected()).branchIndex(r.getBranchIndex()).build();
        }
        return result;
    }

    @Override
    public TaskCardDTO translateBacklogForMQTT(PtmBacklog backlog) {
        if (Objects.isNull(backlog) || Objects.equals(backlog.getHide(), 1)) {
            return null;
        }
        ArrayList<BacklogBO> result = new ArrayList<BacklogBO>();
        PtmProjectCardRecordDTO ptmProjectCardRecordDTO = this.ptmService.getProjectCardRecord(backlog.getProjectCardId());
        PtmTaskRecordBO ptmTaskRecordBO = this.ptmService.getTaskRecord(backlog.getTaskId(), null);
        PtmActivityRecordDTO ptmActivityRecordDTO = this.ptmService.getActivityRecord(backlog.getActivityId());
        PtmWorkItemRecordBO ptmWorkItemRecordBO = this.ptmService.getWorkItemRecord(backlog.getWorkItemId());
        PtmTaskCardItemBO ptmTaskCardItemBO = PtmTaskCardItemBO.builder().backlogId(backlog.getBacklogId()).workItemId(backlog.getWorkItemId()).activityId(backlog.getActivityId()).taskId(backlog.getTaskId()).projectId(backlog.getProjectId()).projectCardId(backlog.getProjectCardId()).performerId(backlog.getPerformerId()).performerName(backlog.getPerformerName()).performerType(ptmWorkItemRecordBO.getPerformerType()).merge(backlog.getMerge()).createTime(backlog.getCreateTime()).tenantId(backlog.getTenantId()).targetTenantId(backlog.getTargetTenantId()).projectDefCode(ptmProjectCardRecordDTO.getProjectDefCode()).projectDefName(ptmProjectCardRecordDTO.getProjectDefName()).projectName(ptmProjectCardRecordDTO.getProjectName()).taskName(backlog.getTaskName()).taskWithName(backlog.getTaskWithName()).taskType(ptmTaskRecordBO.getTaskType()).taskDefPattern(ptmTaskRecordBO.getTaskDefPattern()).taskDefCategory(ptmTaskRecordBO.getTaskDefCategory()).taskDefExecuteType(ptmTaskRecordBO.getTaskDefExecuteType()).taskDefCode(backlog.getTaskDefCode()).taskDefName(backlog.getTaskDefName()).taskDefWithName(backlog.getTaskDefWithName()).taskCreateTime(backlog.getCreateTime()).signReason(ptmActivityRecordDTO.getSignReason()).planEndTime(backlog.getPlanEndTime()).proxyToken(ptmTaskRecordBO.getProxyToken()).activityName(ptmActivityRecordDTO.getActivityName()).signType("1").bpmnType(ptmActivityRecordDTO.getBpmnType()).bpmActivityId(ptmActivityRecordDTO.getBpmActivityId()).bpmActivityName(ptmActivityRecordDTO.getBpmActivityName()).build();
        PtmProjectRecordBO ptmProjectRecordDTO = this.ptmService.getProjectRecord(ptmTaskCardItemBO.getProjectId());
        PtmBacklog ptmBacklog = backlog;
        BacklogBO bl = BacklogBO.builder().id(ptmTaskCardItemBO.getBacklogId()).name(ptmTaskCardItemBO.getTaskName()).withName(ptmTaskCardItemBO.getTaskWithName()).subName(null).taskName(ptmProjectRecordDTO.getProjectName()).taskTargetName(null).taskStartTime(ptmProjectRecordDTO.getStartTime()).taskEndTime(ptmProjectRecordDTO.getEndTime()).taskImportance(ptmProjectRecordDTO.getImportance().booleanValue()).importance(ptmBacklog.getFavorite() != null ? ptmBacklog.getFavorite() > 0 : false).content(ptmTaskCardItemBO.getTaskName()).importanceReadOnly(false).importanceSource(null).uri(null).startTime(ptmTaskCardItemBO.getCreateTime()).endTime(ptmTaskCardItemBO.getPlanEndTime()).tmTaskId(ptmProjectRecordDTO.getProjectDefCode()).tmActivityId(ptmTaskCardItemBO.getTaskDefCode()).type(SummaryMessagesUtils.translateBacklogType(ptmBacklog.getType())).tenantId(ptmTaskCardItemBO.getTenantId()).targetTenantId(ptmTaskCardItemBO.getTargetTenantId()).actionDefined(true).bpmActivityId(ptmTaskCardItemBO.getTaskId()).tmPattern(ptmTaskCardItemBO.getTaskDefPattern()).tmCategory(ptmTaskCardItemBO.getTaskDefCategory()).checkItems(null).operation(null).summaryLayout(null).summaryLayoutStr(null).error(null).isOwner(Boolean.valueOf(true)).performerId(ptmTaskCardItemBO.getPerformerId()).performerName(ptmTaskCardItemBO.getPerformerName()).ownerUserId(ptmTaskCardItemBO.getPerformerId()).ownerUserName(ptmTaskCardItemBO.getPerformerName()).readCount(ptmBacklog.getReadCount()).exception(ptmTaskRecordBO.getHasException()).overdue(Boolean.valueOf(false)).overdueDays(Integer.valueOf(0)).overdueHours(Integer.valueOf(0)).overdueMinutes(Integer.valueOf(0)).reassignFromId(Long.valueOf(0L)).approvalState(ptmBacklog.getApprovalState()).todoItems(null).emergency(ptmProjectRecordDTO.getEmergency() == 25).processSerialNumber(ptmTaskRecordBO.getProcessSerialNumber()).agentBeginDate(null).agentBeginDate(null).overdueWorkitemId(Long.valueOf(0L)).sourceTenantName(StringUtils.equalsIgnoreCase((String)ptmBacklog.getTenantId(), (String)ptmBacklog.getTargetTenantId()) ? null : ptmBacklog.getTenantName()).workItemId(ptmTaskCardItemBO.getBacklogId()).proxyToken(ptmTaskCardItemBO.getProxyToken()).historyMessage(null).finishActionId(ptmBacklog.getClosed() != false ? ptmBacklog.getActionId() : null).tmActivityName(ptmTaskCardItemBO.getTaskDefName()).tmActivityWithName(ptmTaskCardItemBO.getTaskDefWithName()).dataFrom("PTM").merge(ptmTaskCardItemBO.getMerge()).createTime(ptmTaskCardItemBO.getCreateTime()).build();
        if (StringUtils.isNotBlank((String)backlog.getEocCode())) {
            bl.setEocCode(backlog.getEocCode());
            bl.setEocName(backlog.getEocName());
            bl.setEocType(backlog.getEocType());
        } else {
            bl.setEocCode(ptmProjectRecordDTO.getEocCode());
            bl.setEocName(ptmProjectRecordDTO.getEocName());
            bl.setEocType(ptmProjectRecordDTO.getEocType());
        }
        if (ptmTaskRecordBO.getState() != 3 && ptmTaskRecordBO.getPlanEndTime().isBefore(LocalDateTime.now())) {
            bl.setOverdue(Boolean.valueOf(true));
            bl.setOverdueDays(Integer.valueOf((int)Duration.between(ptmTaskRecordBO.getPlanEndTime(), LocalDateTime.now()).toDays()));
            bl.setOverdueHours(Integer.valueOf((int)Duration.between(ptmTaskRecordBO.getPlanEndTime(), LocalDateTime.now()).toHours()));
            bl.setOverdueMinutes(Integer.valueOf((int)Duration.between(ptmTaskRecordBO.getPlanEndTime(), LocalDateTime.now()).toMinutes()));
            if (bl.getOverdueMinutes() <= 0) {
                bl.setOverdue(Boolean.valueOf(false));
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"workitem_id", (Object)backlog.getBacklogId());
        List activityChangeInfoList = this.activityChangeInfoMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)activityChangeInfoList)) {
            bl.setDataChangeRead(((ActivityChangeInfo)activityChangeInfoList.get(0)).getHasRead());
        }
        result.add(bl);
        if (CollectionUtils.isNotEmpty(result)) {
            BacklogBO backlogBO = (BacklogBO)result.get(0);
            backlogBO.setIsOwner(Boolean.valueOf(true));
            backlogBO.setOwnerUserId(backlogBO.getPerformerId());
            backlogBO.setOwnerUserName(backlogBO.getPerformerName());
            ArrayList<BacklogBO> backlogBOS = new ArrayList<BacklogBO>();
            backlogBOS.add(backlogBO);
            this.setBacklogQueryResultSet(backlogBOS);
            List<TaskCardDTO> taskCardDTOS = this.getBacklogList(null, true, backlogBOS);
            if (CollectionUtils.isNotEmpty(taskCardDTOS)) {
                return taskCardDTOS.get(0);
            }
            return null;
        }
        return null;
    }

    private void setBacklogQueryResultSet(List<BacklogBO> backlogBOS) {
        backlogBOS.stream().filter(backlogDTO -> backlogDTO.getType() != null && backlogDTO.getTmActivityId() != null && backlogDTO.getTmCategory() != null && !"NONE".equals(backlogDTO.getTmCategory())).forEach(backlogDTO -> {
            if (backlogDTO.isTaskImportance()) {
                backlogDTO.setImportance(true);
                backlogDTO.setImportanceReadOnly(true);
            } else if (backlogDTO.getImportanceSource() != null && Objects.equals(backlogDTO.getImportanceSource().toLowerCase(), ATHENA)) {
                backlogDTO.setImportanceReadOnly(true);
            } else {
                backlogDTO.setImportanceReadOnly(false);
            }
            if (!StringUtils.isEmpty((String)backlogDTO.getApprovalState())) {
                backlogDTO.setApprovalStateCode(backlogDTO.getApprovalState());
                backlogDTO.setApprovalState(GlobalConstant.backlogStatusMap.getOrDefault(backlogDTO.getApprovalState(), ""));
            }
        });
        HashMap<String, String> approveActivityNameMap = new HashMap<String, String>();
        for (BacklogBO backlogBO : backlogBOS) {
            backlogBO.setActionDefined(!"NONE".equals(backlogBO.getTmCategory()) && backlogBO.getType() != null);
            String key = backlogBO.getTmTaskId() + "-" + backlogBO.getTmActivityId();
            if (approveActivityNameMap.containsKey(key)) {
                backlogBO.setSubName((String)approveActivityNameMap.get(key));
                continue;
            }
            backlogBO.setSubName(this.getSubName(backlogBO));
            approveActivityNameMap.put(key, backlogBO.getSubName());
        }
    }

    private List<TaskCardDTO> getBacklogList(String clientId, boolean isGetReassignAble, List<BacklogBO> backlogList) {
        Long lastTime;
        Long finalLastTime = lastTime = Long.valueOf(0L);
        ArrayList<Map> activities = new ArrayList<Map>();
        ArrayList<TaskCardDTO> list = new ArrayList<TaskCardDTO>();
        List<Long> backlogIdList = backlogList.stream().map(BacklogBO::getWorkItemId).collect(Collectors.toList());
        Map<Long, PtmMergeBacklogBO> mergeBacklogDTOMap = this.commonPtmTransformService.dealBacklogData(backlogIdList, false);
        backlogList.forEach(backlog -> {
            TaskCardDTO taskCardDTO = TaskCardDTO.builder().backlogId(backlog.getWorkItemId()).uri(this.envProperties.getWebUri() + "task/detail/" + backlog.getWorkItemId() + "?targetTenantId=" + backlog.getTargetTenantId()).name(backlog.getName()).withName(backlog.getWithName()).subName(backlog.getSubName()).projectName(backlog.getTaskName()).projectTargetName(backlog.getTaskTargetName()).projectStartTime(backlog.getTaskStartTime()).projectEndTime(backlog.getTaskEndTime()).projectImportance(backlog.isImportance()).importance(backlog.isImportance()).content(backlog.getContent()).importanceReadOnly(backlog.isImportanceReadOnly()).startTime(backlog.getStartTime()).endTime(backlog.getEndTime()).tmTaskId(backlog.getTmTaskId()).tmActivityId(backlog.getTmActivityId()).type(backlog.getType()).tenantId(backlog.getTenantId()).targetTenantId(backlog.getTargetTenantId()).actionDefined(backlog.isActionDefined()).tmPattern(backlog.getTmPattern()).tmCategory(backlog.getTmCategory()).isOwner(backlog.getIsOwner()).ownerUserId(backlog.getOwnerUserId()).ownerUserName(backlog.getOwnerUserName()).readCount(null != backlog.getReadCount() ? backlog.getReadCount() : 0).exception(null != backlog.getException() ? backlog.getException() : false).overdue(null != backlog.getOverdue() ? backlog.getOverdue() : false).overdueMinutes(null != backlog.getOverdueMinutes() ? backlog.getOverdueMinutes() : 0).overdueHours(null != backlog.getOverdueHours() ? backlog.getOverdueHours() : 0).overdueDays(null != backlog.getOverdueDays() ? backlog.getOverdueDays() : 0).approvalStateCode(backlog.getApprovalStateCode()).approvalState(backlog.getApprovalState()).modifyDate(backlog.getModifyDate()).emergency(backlog.isEmergency()).eocCode(backlog.getEocCode()).eocName(backlog.getEocName()).eocType(backlog.getEocType()).agentBeginDate(backlog.getAgentBeginDate()).agentEndDate(backlog.getAgentEndDate()).sourceTenantName(backlog.getSourceTenantName()).proxyToken(backlog.getProxyToken()).finishActionId(backlog.getFinishActionId()).tmActivityName(backlog.getTmActivityName()).tmActivityWithName(backlog.getTmActivityWithName()).merge(backlog.getMerge()).dataFrom(backlog.getDataFrom()).dataChangeRead(backlog.getDataChangeRead() != null && backlog.getDataChangeRead() == 0).createTime(backlog.getCreateTime()).build();
            if (backlog.getModifyDate() != null && finalLastTime != null && finalLastTime > 0L && finalLastTime < backlog.getModifyDate().atZone(ZoneId.systemDefault()).toEpochSecond()) {
                taskCardDTO.setHasDataChanged(true);
            }
            if (ManualTaskUtil.isManualTask(backlog.getTmTaskId(), backlog.getTmActivityId())) {
                taskCardDTO.setProjectStartTime(backlog.getStartTime());
                taskCardDTO.setProjectEndTime(backlog.getEndTime());
            }
            if (!StringUtils.isEmpty((String)taskCardDTO.getProxyToken())) {
                taskCardDTO.setProxyToken(this.tenantTokenService.queryVirtualToken(taskCardDTO.getTenantId()));
            }
            if (activities.stream().filter(a -> Objects.equals(taskCardDTO.getTmActivityId(), a.get("activityCode"))).count() == 0L && !StringUtils.isEmpty((String)taskCardDTO.getTmTaskId()) && !StringUtils.isEmpty((String)taskCardDTO.getTmActivityId())) {
                HashMap<String, String> activityMap = new HashMap<String, String>();
                activityMap.put("taskCode", taskCardDTO.getTmTaskId());
                activityMap.put("activityCode", taskCardDTO.getTmActivityId());
                activities.add(activityMap);
            }
            PtmMergeBacklogBO ptmMergeBacklogBO = (PtmMergeBacklogBO)mergeBacklogDTOMap.get(taskCardDTO.getBacklogId());
            if (BooleanUtils.isTrue((Boolean)taskCardDTO.getMerge()) && ptmMergeBacklogBO != null) {
                taskCardDTO.setPlanEndTimeMin(ptmMergeBacklogBO.getPlanEndTimeMin());
                taskCardDTO.setPlanEndTimeMax(ptmMergeBacklogBO.getPlanEndTimeMax());
            }
            log.info(" \u3010taskCard data\u3011: {}", (Object)taskCardDTO);
            list.add(taskCardDTO);
        });
        if (isGetReassignAble) {
            try {
                List<TmActivityResponseDTO> activityDefineCacheList = this.themeMapService.getBatchActivityAssigns(activities);
                list.forEach(task -> {
                    Optional<BacklogBO> optional = backlogList.stream().filter(bk -> Objects.equals(bk.getWorkItemId(), task.getBacklogId())).findFirst();
                    if (optional.isPresent() && optional.get().getOverdueWorkitemId() != null && optional.get().getOverdueWorkitemId() > 0L) {
                        task.setReAssignAble(false);
                    } else {
                        Optional<TmActivityResponseDTO> responseDTO = activityDefineCacheList.stream().filter(x -> Objects.equals(x.getActivityId(), task.getTmActivityId())).findFirst();
                        if (responseDTO.isPresent()) {
                            task.setReAssignAble(responseDTO.get().getAssignConfig() != null ? responseDTO.get().getAssignConfig().getAssignAble() : false);
                        } else {
                            task.setReAssignAble(false);
                        }
                    }
                });
            }
            catch (Exception e) {
                log.warn("[\u4efb\u52a1\u5217\u8868\u53ef\u5426\u8f6c\u6d3e] \u51fa\u73b0\u5f02\u5e38\uff1a{},\u67e5\u8be2\u5185\u5bb9\uff1a{}", (Object)e, activities);
            }
        }
        return list;
    }

    private String getSubName(BacklogBO backlogBO) {
        if ("APPROVAL".equals(backlogBO.getTmCategory())) {
            try {
                Map startApproveActivityNameMap;
                TmActivityResponseDTO themeActivity = this.themeMapService.getActivityAction(backlogBO.getTmTaskId(), backlogBO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue());
                if (themeActivity.getLang() != null && themeActivity.getLang().containsKey("startApproveActivityName") && (startApproveActivityNameMap = (Map)themeActivity.getLang().get("startApproveActivityName")) != null) {
                    return String.format("{\"zh_TW\":\"%s\",\"en_US\":\"%s\",\"zh_CN\":\"%s\"}", startApproveActivityNameMap.getOrDefault("zh_TW", themeActivity.getStartApproveActivityName()), startApproveActivityNameMap.getOrDefault("en_US", themeActivity.getStartApproveActivityName()), startApproveActivityNameMap.getOrDefault("zh_CN", themeActivity.getStartApproveActivityName()));
                }
                return themeActivity.getStartApproveActivityName();
            }
            catch (Exception ex) {
                return "";
            }
        }
        return null;
    }
}

