/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.SendMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.utils.NoticeMessageUtil;
import com.digiwin.athena.abt.core.meta.enums.EmailTemplateStateEnum;
import com.digiwin.athena.abt.core.meta.enums.TypeEnum;
import com.digiwin.athena.abt.core.meta.enums.message.CategoryEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.EmailMapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendMessageServiceImpl
implements SendMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SendMessageServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SendMessageServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private NoticeMessageUtil noticeMessageUtil;
    @Autowired
    private AimService aimService;
    @Autowired
    private EmailMapper emailMapper;

    @Override
    public void sendMessageRemindToClient(String token, String tenantId, String userId, AppMessageDTO appMessageDTO) {
        try {
            if (BooleanUtils.isTrue((Boolean)appMessageDTO.getEmailPush())) {
                this.noticeMessageUtil.sendRemindNotice(appMessageDTO);
            }
        }
        catch (Exception e) {
            logger.warn("notice remind with sendMessageRemindToClient error", (Throwable)e);
        }
        boolean doNotDisturb = this.userService.getMessageDoNotDisturbUserId(userId, tenantId, token);
        if (doNotDisturb) {
            appMessageDTO.setPush(false);
        }
        this.aimService.sendMsgRemindToClient(token, tenantId, userId, appMessageDTO);
    }

    @Override
    public void saveNewMessage(AuthoredUser authoredUser, MessageDO message) {
        if (null == message.getState()) {
            message.setState(0);
        }
        if (null == message.getNoticeMobileApp()) {
            message.setNoticeMobileApp(true);
        }
        try {
            int checkResult = this.noticeMessageUtil.checkSendType(authoredUser.getTenantSid(), message.getUserId());
            logger.info("user set notice message with checkResult.{}", (Object)checkResult);
            if (checkResult != 0) {
                if (this.checkWheatherSendEmail(authoredUser, message).booleanValue()) {
                    this.noticeMessageUtil.sendNoticeWithMail(authoredUser, message);
                }
                if (checkResult == 1) {
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.warn("send message to user error.message content:{}", (Object)message, (Object)e);
        }
        logger.info("atmc\u4ea7\u751fim\u63d0\u9192:{}", (Object)message);
        this.aimService.message(authoredUser, message);
    }

    @Override
    public void sendMsg4AllChannel(String token, String tenantId, String appCode, String sceneId, Map<String, Object> data) {
        this.aimService.sendMsg4AllChannel(token, tenantId, appCode, sceneId, data);
    }

    @Override
    public void sendToAppClient(AuthoredUser authoredUser, MessageDO message) {
        this.aimService.sendToAppClient(authoredUser, message);
    }

    private Boolean checkWheatherSendEmail(AuthoredUser authoredUser, MessageDO message) {
        if (TypeEnum.ACTIVITY.getValue().equals(message.getType()) && CategoryEnum.NEW.name().equals(message.getCategory())) {
            Integer num = this.emailMapper.selectTemplatesNum(authoredUser.getTenantId(), EmailTemplateStateEnum.INUSE.getValue(), message.getSubType());
            log.info("selectTemplatesNum:{}", (Object)num);
            if (num > 0) {
                return false;
            }
        }
        return true;
    }
}

