/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import com.digiwin.athena.abt.application.dto.migration.abt.task.SharingTaskDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.share.dao.ShareCodeDao;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.ShareService;
import com.digiwin.athena.abt.application.service.atmc.migration.tenantToken.TenantTokenService;
import com.digiwin.athena.abt.core.meta.constants.SharingTaskConstant;
import com.digiwin.athena.abt.core.meta.enums.SharingTaskTypeEnum;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ShareServiceImpl
implements ShareService {
    @Autowired
    private TenantTokenService tenantTokenService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private ShareCodeDao shareCodeDao;
    @Value(value="${athena.sharingCode.ttl:120}")
    private long sharingCodeTtl;

    @Override
    public String createSharingCode(AuthoredUser authoredUser, String taskType, Long taskId) {
        SharingTaskTypeEnum.checkTaskTypeWithException((String)taskType);
        String token = authoredUser.getToken();
        SharingTaskDTO sharingTaskDTO = SharingTaskDTO.builder().proxyToken(this.tenantTokenService.queryVirtualToken(authoredUser.getTenantId())).taskType(taskType.toUpperCase(Locale.UK)).taskId(taskId).build();
        String sharingCode = this.shareCodeDao.addShareCodeCache(JsonUtils.objectToString((Object)sharingTaskDTO), this.sharingCodeTtl, SharingTaskConstant.SHARING_CODE_TTL_TIME_UNIT);
        String proxyToken = AppAuthContextHolder.getContext().getProxyToken();
        if (StringUtils.isNotBlank((String)proxyToken)) {
            sharingCode = sharingCode + "&proxyToken=" + proxyToken;
        }
        return sharingCode;
    }

    @Override
    public String getShareCodeCache(String sharingCode) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)("atmc:athena:sharingCode:" + sharingCode));
    }
}

