/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.WorkItemMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.iam.UserDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmAppDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmTransformService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.SendMessageService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.ShareService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.WorkItemMessageService;
import com.digiwin.athena.abt.application.service.abt.migration.route.RouteService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.CommonBacklogAbstractService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.emc.EmcService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.IamService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.enums.TypeEnum;
import com.digiwin.athena.abt.core.meta.enums.message.CategoryEnum;
import com.digiwin.athena.abt.core.meta.enums.message.MsgImportanceEnum;
import com.digiwin.athena.abt.core.meta.enums.message.SubTypeCategoryEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.ReassignTrace;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Route;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.ImmutableMap;
import com.jugg.agile.framework.core.config.JaProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkItemMessageServiceImpl
implements WorkItemMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkItemMessageServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(WorkItemMessageServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    protected EocService eocService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private RouteService routeService;
    @Autowired
    private PtmTransformService ptmTransformService;
    @Autowired
    private CommonBacklogAbstractService backlogHandleService;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private ShareService shareService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private IamService iamService;
    @Autowired
    private EmcService emcService;
    private final Integer CREATE_TYPE_REASSIGN = 1;
    private final Integer CREATE_TYPE_HANDOVER = 10;
    public static final String MESSAGE_DINGTALK_URL = "%slogin/dingtalk-login?appId=%s&corpId=%s&dingLog=0&routerLink=";
    public static final String MESSAGE_DINGTALK_APP_URL = "%s/#/?appId=%s&appName=%s&corpId=%s&sourceType=ding_talk&dataId=%s&targetTenantId=%s";
    public static final String PROJECT_TASK_DETAIL = "/project/share/%s/%s&engineType=TaskEngine";
    public static final String TASK_DETAIL_SHARE = "task/detail/%s?shareCode=%s";
    private final List<Integer> workItemCreateTypes = Arrays.asList(this.CREATE_TYPE_REASSIGN, this.CREATE_TYPE_HANDOVER);
    private final Map<Integer, Integer> operationTypeMap = ImmutableMap.of((Object)this.CREATE_TYPE_REASSIGN, (Object)0, (Object)this.CREATE_TYPE_HANDOVER, (Object)2);

    @Override
    public void sendWorkItemMessage(WorkItemMessageDTO message, AuthoredUser authoredUser) {
        String backlogId = String.valueOf(message.getBacklog() == null ? 0L : message.getBacklog().getBacklogId());
        LogDto logDto = new LogDto("\u53d1\u9001\u4efb\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u5f85\u529eId\uff1a" + backlogId, authoredUser.getTenantId() + ";" + backlogId);
        log.info(logDto.toString());
        List<WorkItemMessageDTO.WorkItem> workitemList = message.getWorkItemList();
        Boolean isEnabled = JaProperty.getBoolean((String)"athena.messageCenter.enable", (Boolean)Boolean.FALSE);
        log.info("[sendWorkItemMessage] backlogId = {}, athena.messageCenter.enable = {}", (Object)backlogId, (Object)isEnabled);
        for (WorkItemMessageDTO.WorkItem workItem : workitemList) {
            if (isEnabled.booleanValue()) {
                this.sendWorkitemMessage(message, workItem, authoredUser);
                continue;
            }
            this.recordMsgWorkitem(message, workItem, authoredUser);
        }
        if (BooleanUtils.isTrue((Boolean)message.getTask().getHasException())) {
            this.recordProjectExceptionMsg(message, authoredUser);
        }
    }

    private void sendWorkitemMessage(WorkItemMessageDTO message, WorkItemMessageDTO.WorkItem workItem, AuthoredUser authoredUser) {
        logger.info("sendWorkitemMessage by messageCenter message:{} workItem:{} ,authoredUser:{}", new Object[]{message, workItem, authoredUser.getUserId()});
        UserDTO performer = this.userService.query(workItem.getPerformerId(), authoredUser.getToken());
        MessageDO performerMessage = this.packageMessageDO(message, performer, authoredUser, workItem);
        logger.info("sendWorkitemMessage by messageCenter performerMessage:{} ", (Object)JsonUtils.objectToString((Object)performerMessage));
        Map<String, Object> data = this.buildMessageData(message, authoredUser, performerMessage);
        logger.info("sendWorkitemMessage by messageCenter data:{} ", (Object)JsonUtils.objectToString(data));
        if (this.CREATE_TYPE_REASSIGN.equals(workItem.getCreateType())) {
            logger.info("sendWorkitemMessage by messageCenter ATHENA_TASK_REASSIGN_SCENE start");
            this.sendMessageService.sendMsg4AllChannel(authoredUser.getToken(), String.valueOf(data.get("tenantId")), String.valueOf(data.get("appCode")), "ATHENA_TASK_REASSIGN_SCENE", data);
        } else if (this.CREATE_TYPE_HANDOVER.equals(workItem.getCreateType())) {
            logger.info("sendWorkitemMessage by messageCenter ATHENA_TASK_HANDOVER_SCENE start");
            this.sendMessageService.sendMsg4AllChannel(authoredUser.getToken(), String.valueOf(data.get("tenantId")), String.valueOf(data.get("appCode")), "ATHENA_TASK_HANDOVER_SCENE", data);
        } else {
            logger.info("sendWorkitemMessage by messageCenter ATHENA_TASK_CREATE_SCENE start");
            this.sendMessageService.sendMsg4AllChannel(authoredUser.getToken(), String.valueOf(data.get("tenantId")), String.valueOf(data.get("appCode")), "ATHENA_TASK_CREATE_SCENE", data);
        }
        logger.info("sendWorkitemMessage by messageCenter sendToAppClient start");
        this.sendMessageService.sendToAppClient(authoredUser, performerMessage);
        ProxyUserResp proxyInfo = this.eocService.getProxyUser(workItem.getPerformerId(), authoredUser.getToken());
        if (null == proxyInfo || null == proxyInfo.getUserId() || proxyInfo.getUserId().equals(performer.getId())) {
            return;
        }
        UserDTO proxyUser = this.userService.query(proxyInfo.getUserId(), authoredUser.getToken());
        MessageDO proxyPerformerMessage = this.packageMessageDO(message, proxyUser, authoredUser, workItem);
        proxyPerformerMessage.setSubTypeCategory(SubTypeCategoryEnum.PROXY_REMIND.name());
        Map<String, Object> dataProxy = this.buildMessageData(message, authoredUser, proxyPerformerMessage);
        logger.info("sendWorkitemMessage by messageCenter data:{} ", (Object)JsonUtils.objectToString(dataProxy));
        if (this.CREATE_TYPE_REASSIGN.equals(workItem.getCreateType())) {
            logger.info("sendWorkitemMessage by messageCenter proxy ATHENA_TASK_REASSIGN_SCENE start");
            this.sendMessageService.sendMsg4AllChannel(authoredUser.getToken(), String.valueOf(dataProxy.get("tenantId")), String.valueOf(dataProxy.get("appCode")), "ATHENA_TASK_REASSIGN_SCENE", dataProxy);
        } else if (this.CREATE_TYPE_HANDOVER.equals(workItem.getCreateType())) {
            logger.info("sendWorkitemMessage by messageCenter proxy ATHENA_TASK_HANDOVER_SCENE start");
            this.sendMessageService.sendMsg4AllChannel(authoredUser.getToken(), String.valueOf(dataProxy.get("tenantId")), String.valueOf(dataProxy.get("appCode")), "ATHENA_TASK_HANDOVER_SCENE", dataProxy);
        } else {
            logger.info("sendWorkitemMessage by messageCenter proxy ATHENA_TASK_CREATE_SCENE start");
            this.sendMessageService.sendMsg4AllChannel(authoredUser.getToken(), String.valueOf(dataProxy.get("tenantId")), String.valueOf(dataProxy.get("appCode")), "ATHENA_TASK_CREATE_SCENE", dataProxy);
        }
        logger.info("sendWorkitemMessage by messageCenter proxy sendToAppClient start");
        this.sendMessageService.sendToAppClient(authoredUser, proxyPerformerMessage);
    }

    private Map<String, Object> buildMessageData(WorkItemMessageDTO message, AuthoredUser authoredUser, MessageDO performerMessage) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("tenantId", performerMessage.getTenantId());
        data.put("performer", performerMessage.getUserId());
        data.put("type", performerMessage.getType());
        data.put("subType", performerMessage.getSubType());
        data.put("subTypeCategory", performerMessage.getSubTypeCategory());
        data.put("category", performerMessage.getCategory());
        data.put("importance", performerMessage.getImportance());
        List<TmAppDTO> tmAppDTOS = this.themeMapService.getAppInfoByCodeAndType("task", Collections.singletonList(performerMessage.getSubType()));
        String appCode = "";
        String appName = "";
        if (CollectionUtils.isNotEmpty(tmAppDTOS)) {
            appCode = tmAppDTOS.get(0).getAppCode();
            appName = tmAppDTOS.get(0).getAppName();
            data.put("appCode", appCode);
        }
        if (null != performerMessage.getContent()) {
            String linkUrl;
            JSONObject content = (JSONObject)performerMessage.getContent();
            data.put("id", content.get("id"));
            data.put("operationType", content.get("operationType"));
            data.put("operator", content.get("operator"));
            data.put("dataUrl", content.get("emailMsg"));
            String corpid = this.iamService.getTenantCorpid();
            if (StringUtils.isBlank((String)corpid)) {
                corpid = performerMessage.getTenantId();
            }
            String appUri = this.getAppShareUrl(String.valueOf(content.get("id")), appName, appCode, performerMessage.getTenantId(), corpid);
            data.put("appUri", appUri);
            String messageUri = this.getPcShareUrl(authoredUser, String.valueOf(content.get("id")), performerMessage.getType(), appCode, corpid);
            data.put("messageUri", messageUri);
            List<Map<String, Object>> wecomConfigs = this.emcService.getWecomConfig();
            if (CollectionUtils.isNotEmpty(wecomConfigs)) {
                try {
                    Map<String, Object> wecomConfig = wecomConfigs.get(0);
                    String agentid = String.valueOf(wecomConfig.get("appId"));
                    String corpId = String.valueOf(wecomConfig.get("corpId"));
                    String redirect_uri = this.envProperties.getSemcUri() + "/semc/router/routingDistribution?taskId=" + content.get("id") + "&appId=" + agentid + "&tenantId=" + performerMessage.getTenantId();
                    String encode = URLEncoder.encode(redirect_uri, "utf-8");
                    String weChatUrl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpId + "&redirect_uri=" + encode + "&response_type=code&scope=snsapi_base&state=STATE&agentid=" + agentid + "#wechat_redirect";
                    String weComMsg = String.format("<a href='%s'>%s</a>", weChatUrl, content.get("emailMsg"));
                    data.put("weComMsg", weComMsg);
                }
                catch (Exception e) {
                    log.error("\u53d1\u751f\u6d88\u606f\uff0c\u7ec4\u88c5\u4f01\u4e1a\u5fae\u4fe1\u5982\u53c2\u6570\u5931\u8d25", (Throwable)e);
                }
            }
            if (null != content.get("messageFiled")) {
                JSONObject messageFiled = (JSONObject)content.get("messageFiled");
                data.put("taskName", messageFiled.get("tmActivityName"));
                data.put("taskCode", performerMessage.getSubType());
                if (messageFiled.containsKey((Object)"summaryLayout") && null != messageFiled.get("summaryLayout")) {
                    String summaryLayout = String.valueOf(messageFiled.get("summaryLayout")).replaceAll("<br\\s?/?>", "\uff1b");
                    data.put("summaryLayout", summaryLayout);
                }
            }
            if (StringUtils.isNotBlank((String)(linkUrl = this.generateLinkUrl(authoredUser, performerMessage.getType(), String.valueOf(content.get("id")), performerMessage.getTenantId())))) {
                data.put("linkUrl", linkUrl);
            }
            data.put("content", content.get("emailMsg"));
        }
        data.put("endTime", message.getTask().getPlanEndTime());
        return data;
    }

    public String getAppShareUrl(String taskId, String appName, String appId, String tenantId, String corpid) {
        String messageUrl = String.format(MESSAGE_DINGTALK_APP_URL, this.envProperties.getMobileWebUri(), appId, appName, corpid, taskId, tenantId);
        try {
            messageUrl = URLEncoder.encode(messageUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("getAppShareUrl URLEncoder\u62a5\u9519\uff0c e\uff1a{}", (Throwable)e);
        }
        return messageUrl;
    }

    public String getPcShareUrl(AuthoredUser user, String taskId, String msgType, String appId, String corpId) {
        String shareUrl = "";
        String messageUrl = String.format(MESSAGE_DINGTALK_URL, this.envProperties.getWebUri(), appId, corpId);
        String shareMsgType = (msgType = msgType.toLowerCase()).equals("activity") ? "task" : "project";
        String shareCode = this.shareService.createSharingCode(user, shareMsgType, Long.valueOf(taskId));
        if (msgType.equals("task")) {
            shareUrl = String.format(PROJECT_TASK_DETAIL, taskId, shareCode);
        }
        if (msgType.equals("activity")) {
            shareUrl = String.format(TASK_DETAIL_SHARE, taskId, shareCode);
        }
        messageUrl = messageUrl + shareUrl;
        try {
            messageUrl = URLEncoder.encode(messageUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("senDingDingMessage URLEncoder\u62a5\u9519\uff0c e\uff1a{}", (Throwable)e);
        }
        return messageUrl;
    }

    public String generateLinkUrl(AuthoredUser user, String type, String id, String targetTenantId) {
        String urlDetail = "";
        if ("activity".equals(type) || "task".equals(type)) {
            String defaultType;
            if ("activity".equals(type)) {
                defaultType = "task";
                urlDetail = "task/detail/" + id + "?targetTenantId=" + targetTenantId + "&shareCode=";
            } else {
                defaultType = "project";
                urlDetail = "project/share/" + id + "/";
            }
            String shareCode = this.shareService.createSharingCode(user, defaultType, Long.valueOf(id));
            Task task = this.taskMapper.selectPartialById(Long.valueOf(id));
            if (task == null) {
                urlDetail = this.envProperties.getWebUri() + urlDetail + shareCode + "?engineType=TaskEngine";
                if (urlDetail.contains("project")) {
                    urlDetail = urlDetail + "&targetTenantId=" + targetTenantId;
                }
            } else {
                urlDetail = this.envProperties.getWebUri() + urlDetail + shareCode;
                if (urlDetail.contains("project")) {
                    urlDetail = urlDetail + "?targetTenantId=" + targetTenantId;
                }
            }
        }
        return urlDetail;
    }

    private void recordMsgWorkitem(WorkItemMessageDTO message, WorkItemMessageDTO.WorkItem workItem, AuthoredUser authoredUser) {
        logger.info("recordMsgWorkitem message:{} workItem:{} ,authoredUser:{}", new Object[]{message, workItem, authoredUser.getUserId()});
        UserDTO performerUser = this.userService.query(workItem.getPerformerId(), authoredUser.getToken());
        MessageDO performerMessage = this.packageMessageDO(message, performerUser, authoredUser, workItem);
        logger.info("send workitem msg to performer with message:{}", (Object)performerMessage);
        String backlogId = String.valueOf(message.getBacklog() == null ? 0L : message.getBacklog().getBacklogId());
        LogDto logDto = new LogDto("\u7ed9\u6267\u884c\u8005\u53d1\u9001\u6d88\u606f\uff0c\u5f85\u529eId\uff1a" + backlogId, authoredUser.getTenantId() + ";" + backlogId);
        log.info(logDto.toString());
        this.sendMessageService.saveNewMessage(authoredUser, performerMessage);
        ProxyUserResp proxyInfo = this.eocService.getProxyUser(workItem.getPerformerId(), authoredUser.getToken());
        if (null == proxyInfo || null == proxyInfo.getUserId() || proxyInfo.getUserId().equals(performerUser.getId())) {
            return;
        }
        UserDTO proxyUser = this.userService.query(proxyInfo.getUserId(), authoredUser.getToken());
        MessageDO proxyMessage = this.packageMessageDO(message, proxyUser, authoredUser, workItem);
        proxyMessage.setSubTypeCategory(SubTypeCategoryEnum.PROXY_REMIND.name());
        logger.info("send workitem msg to proxy user with message:{}", (Object)performerMessage);
        LogDto logDtoProxy = new LogDto("\u7ed9\u4ee3\u7406\u4eba\u53d1\u9001\u6d88\u606f\uff0c\u5f85\u529eId\uff1a" + backlogId, authoredUser.getTenantId() + ";" + backlogId);
        log.info(logDtoProxy.toString());
        this.sendMessageService.saveNewMessage(authoredUser, proxyMessage);
    }

    private void recordProjectExceptionMsg(WorkItemMessageDTO message, AuthoredUser authoredUser) {
        UserDTO userDTO = this.userService.getTargetUser(message.getProject().getPersonInCharge(), authoredUser.getToken());
        if (null == userDTO) {
            return;
        }
        MessageDO toRecordMsg = new MessageDO();
        toRecordMsg.setUserId(userDTO.getId());
        toRecordMsg.setTenantId(authoredUser.getTenantId());
        toRecordMsg.setSource("athena");
        toRecordMsg.setType(TypeEnum.TASK.getValue());
        toRecordMsg.setSubType(message.getProject().getProjectDefCode());
        String langName = this.userService.getUserLangMetadataAllTenant(userDTO.getId(), authoredUser.getToken());
        if (org.springframework.util.StringUtils.isEmpty((Object)langName)) {
            langName = "zh_TW";
        }
        String taskName = MessageUtils.getMessageByLanguage((Object)message.getProject().getName(), (String)langName);
        String backlogName = MessageUtils.getMessageByLanguage((Object)message.getTask().getTaskName(), (String)langName);
        String title = String.format(this.messageUtils.getMessageByLangName("msg.record.task.exception.title", langName), TimeUtils.format((LocalDateTime)message.getProject().getStartTime(), (String)"MM.dd"), TimeUtils.format((LocalDateTime)message.getProject().getEndTime(), (String)"MM.dd"), taskName, backlogName);
        toRecordMsg.setSubTypeCategory(SubTypeCategoryEnum.EXCEPTION_OR_OVERDUE.name());
        toRecordMsg.setCategory(CategoryEnum.EXCEPTION.name());
        toRecordMsg.setImportance(MsgImportanceEnum.IMPORTANT.getImportance());
        toRecordMsg.setTitle(title);
        toRecordMsg.setSendDate(LocalDateTime.now());
        toRecordMsg.setStartTime(message.getProject().getStartTime());
        toRecordMsg.setEndTime(message.getProject().getEndTime());
        JSONObject content = new JSONObject();
        content.put((Object)"id", (Object)String.valueOf(message.getProject().getProjectId()));
        content.put((Object)"mainTaskId", (Object)String.valueOf(message.getProject().getProjectCardId()));
        content.put((Object)"routeId", (Object)this.getRouteIdBySubTaskId(message.getProject().getProjectId()));
        content.put((Object)"engineType", (Object)message.getProject().getEngineType());
        content.put((Object)"title", (Object)title);
        content.put((Object)"name", (Object)taskName);
        content.put((Object)"startTime", (Object)this.formatDate(toRecordMsg.getStartTime()));
        content.put((Object)"endTime", (Object)this.formatDate(toRecordMsg.getEndTime()));
        content.put((Object)"status", (Object)0);
        String msg = "";
        content.put((Object)"msg", (Object)msg);
        toRecordMsg.setContent(content);
        this.sendMsgToPerformerAndAgent(authoredUser, userDTO, message.getProject().getPersonInCharge(), toRecordMsg);
    }

    private Long getRouteIdBySubTaskId(Long subTaskId) {
        Route route = this.routeService.getRouteByTaskId(subTaskId);
        if (route == null) {
            route = this.ptmTransformService.getRouteByProjectId(subTaskId);
        }
        return null != route ? route.getId() : null;
    }

    private String formatDate(LocalDateTime dateTime) {
        return TimeUtils.format((LocalDateTime)dateTime, (String)"yyyy-MM-dd HH:mm:ss");
    }

    protected void sendMsgToPerformerAndAgent(AuthoredUser authoredUser, UserDTO userDTO, String performerId, MessageDO newMsg) {
        log.info("saveNewMessage1: {}", (Object)newMsg);
        this.sendMessageService.saveNewMessage(authoredUser, newMsg);
        if (!StringUtils.equals((String)performerId, (String)userDTO.getId())) {
            log.info("saveNewMessage2: {}", (Object)newMsg);
            newMsg.setUserId(performerId);
            newMsg.setTenantId(authoredUser.getTenantId());
            this.sendMessageService.saveNewMessage(authoredUser, newMsg);
        }
    }

    private MessageDO packageMessageDO(WorkItemMessageDTO message, UserDTO userDTO, AuthoredUser authoredUser, WorkItemMessageDTO.WorkItem workItem) {
        MessageDO toRecordMsg = new MessageDO();
        toRecordMsg.setUserId(userDTO.getId());
        toRecordMsg.setState(0);
        if (null != message.getBacklog() && StringUtils.isNotBlank((String)message.getBacklog().getTenantId())) {
            toRecordMsg.setTenantId(message.getBacklog().getTenantId());
        } else {
            toRecordMsg.setTenantId(authoredUser.getTenantId());
        }
        toRecordMsg.setSource("athena");
        String langName = this.userService.getUserLangMetadataAllTenant(userDTO.getId(), authoredUser.getToken());
        if (org.springframework.util.StringUtils.isEmpty((Object)langName)) {
            langName = "zh_TW";
        }
        String projectName = MessageUtils.getMessageByLanguage((Object)message.getProject().getName(), (String)langName);
        toRecordMsg.setType(TypeEnum.ACTIVITY.getValue());
        toRecordMsg.setSubType(message.getTask().getTmActivityId());
        String backlogName = MessageUtils.getMessageByLanguage((Object)message.getTask().getTaskName(), (String)langName);
        String tmActivityName = MessageUtils.getMessageByLanguage((Object)message.getTask().getTmActivityName(), (String)langName);
        String title = "";
        String endTime = TimeUtils.format((LocalDateTime)message.getTask().getPlanEndTime(), (String)"MM/dd");
        JSONObject content = new JSONObject();
        if (null != message.getTask().getHasException() && message.getTask().getHasException().booleanValue()) {
            toRecordMsg.setSubTypeCategory(SubTypeCategoryEnum.EXCEPTION_OR_OVERDUE.name());
            toRecordMsg.setCategory(CategoryEnum.EXCEPTION.name());
            toRecordMsg.setImportance(MsgImportanceEnum.IMPORTANT.getImportance());
        } else if (1 == message.getProject().getEmergency()) {
            toRecordMsg.setSubTypeCategory(SubTypeCategoryEnum.ATHENA_REMIND.name());
            toRecordMsg.setCategory(CategoryEnum.EMERGENCY.name());
            toRecordMsg.setImportance(MsgImportanceEnum.IMPORTANT.getImportance());
        } else {
            toRecordMsg.setSubTypeCategory(SubTypeCategoryEnum.ATHENA_REMIND.name());
            toRecordMsg.setCategory(CategoryEnum.NEW.name());
            toRecordMsg.setImportance(MsgImportanceEnum.UNIMPORTANT.getImportance());
            String backlogId = message.getMessageType();
            if ("2".equals(backlogId)) {
                toRecordMsg.setCategory(CategoryEnum.UPDATE.name());
            }
            String activityName = "";
            activityName = tmActivityName.equals(backlogName) ? tmActivityName : tmActivityName + "-" + backlogName;
            JSONObject messageFiled = new JSONObject();
            messageFiled.put((Object)"summaryTag", (Object)"1");
            String summary = "";
            try {
                CardAbstractDTO cardAbstractDTO = new CardAbstractDTO().setNeedHistoryInfo(false).setCount(30);
                Map summaryMap = this.backlogHandleService.getBacklogCardAbstractById(message.isMinSplit() ? workItem.getId() : workItem.getWorkItemId(), authoredUser, cardAbstractDTO, langName);
                log.info("\u6458\u8981\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)summaryMap);
                if (summaryMap != null) {
                    String string = summary = summaryMap.get("summaryLayout") != null ? summaryMap.get("summaryLayout").toString() : "";
                    if (!StringUtils.isEmpty((String)summary)) {
                        messageFiled.put((Object)"summaryTag", (Object)"0");
                    }
                }
            }
            catch (Exception e) {
                log.info("\u6458\u8981\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                messageFiled.put((Object)"summaryTag", (Object)"2");
            }
            messageFiled.put((Object)"createTime", (Object)TimeUtils.format((LocalDateTime)message.getTask().getCreateTime(), (String)"MM/dd"));
            messageFiled.put((Object)"tmActivityName", (Object)activityName);
            messageFiled.put((Object)"endTime", (Object)endTime);
            messageFiled.put((Object)"projectName", (Object)projectName);
            messageFiled.put((Object)"summaryLayout", (Object)summary);
            this.setReassignOrHandoverInfo(workItem, messageFiled, content);
            content.put((Object)"messageFiled", (Object)messageFiled);
        }
        toRecordMsg.setTitle(title);
        toRecordMsg.setSendDate(LocalDateTime.now());
        toRecordMsg.setStartTime(message.getTask().getCreateTime());
        toRecordMsg.setEndTime(message.getTask().getPlanEndTime());
        content.put((Object)"id", (Object)String.valueOf(workItem.getId()));
        content.put((Object)"title", (Object)title);
        content.put((Object)"name", (Object)backlogName);
        content.put((Object)"startTime", (Object)this.formatDate(toRecordMsg.getStartTime()));
        content.put((Object)"endTime", (Object)this.formatDate(toRecordMsg.getEndTime()));
        content.put((Object)"status", (Object)0);
        String msg = null;
        String emailMsg = null;
        if (null != message.getTask().getHasException() && message.getTask().getHasException().booleanValue()) {
            if (tmActivityName.equals(backlogName)) {
                msg = String.format(this.messageUtils.getMessageByLangName("msg.record.backlog.exception", langName), tmActivityName, endTime, projectName);
                emailMsg = String.format(this.messageUtils.getMessageByLangName("msg.record.backlog.exception.mail", langName), tmActivityName, endTime, projectName);
            } else {
                msg = String.format(this.messageUtils.getMessageByLangName("msg.record.backlog.exception.type.and.name", langName), tmActivityName, endTime, backlogName, projectName);
                emailMsg = String.format(this.messageUtils.getMessageByLangName("msg.record.backlog.exception.type.and.name.mail", langName), tmActivityName, endTime, backlogName, projectName);
            }
        } else if (1 == message.getProject().getEmergency()) {
            if (tmActivityName.equals(backlogName)) {
                msg = String.format(this.messageUtils.getMessageByLangName("msg.record.task.emergency.msg", langName), tmActivityName, endTime, projectName);
                emailMsg = String.format(this.messageUtils.getMessageByLangName("msg.record.task.emergency.msg.mail", langName), tmActivityName, endTime, projectName);
            } else {
                msg = String.format(this.messageUtils.getMessageByLangName("msg.record.task.emergency.msg.type.and.name", langName), tmActivityName, backlogName, endTime, projectName);
                emailMsg = String.format(this.messageUtils.getMessageByLangName("msg.record.task.emergency.msg.type.and.name.mail", langName), tmActivityName, backlogName, endTime, projectName);
            }
        } else {
            String emailMsgKey;
            String msgKey;
            String messageType = message.getMessageType();
            if (tmActivityName.equals(backlogName)) {
                msgKey = this.getLangKey("backlog.add.new.message.project.info", workItem.getCreateType());
                emailMsgKey = this.getLangKey("backlog.add.new.message.project.info.mail", workItem.getCreateType());
                msg = String.format(this.messageUtils.getMessageByLangName(msgKey, langName), TimeUtils.format((LocalDateTime)message.getTask().getCreateTime(), (String)"MM/dd"), tmActivityName, endTime, projectName, content.get("operator"));
                emailMsg = String.format(this.messageUtils.getMessageByLangName(emailMsgKey, langName), TimeUtils.format((LocalDateTime)message.getTask().getCreateTime(), (String)"MM/dd"), tmActivityName, endTime, projectName, content.get("operator"));
                if ("2".equals(messageType)) {
                    msg = String.format(this.messageUtils.getMessageByLangName("backlog.update.new.message.project.info", langName), TimeUtils.format((LocalDateTime)message.getTask().getCreateTime(), (String)"MM/dd"), tmActivityName, endTime, projectName);
                }
            } else {
                msgKey = this.getLangKey("backlog.add.new.message.project.info.type.and.name", workItem.getCreateType());
                emailMsgKey = this.getLangKey("backlog.add.new.message.project.info.type.and.name.mail", workItem.getCreateType());
                msg = String.format(this.messageUtils.getMessageByLangName(msgKey, langName), TimeUtils.format((LocalDateTime)message.getTask().getCreateTime(), (String)"MM/dd"), tmActivityName, backlogName, endTime, projectName, content.get("operator"));
                emailMsg = String.format(this.messageUtils.getMessageByLangName(emailMsgKey, langName), TimeUtils.format((LocalDateTime)message.getTask().getCreateTime(), (String)"MM/dd"), tmActivityName, backlogName, endTime, projectName, content.get("operator"));
                if ("2".equals(messageType)) {
                    msg = String.format(this.messageUtils.getMessageByLangName("backlog.update.new.message.project.info.type.and.name", langName), TimeUtils.format((LocalDateTime)message.getTask().getCreateTime(), (String)"MM/dd"), tmActivityName, backlogName, endTime, projectName);
                }
            }
        }
        content.put((Object)"msg", (Object)msg);
        content.put((Object)"emailMsg", (Object)emailMsg);
        toRecordMsg.setContent(content);
        return toRecordMsg;
    }

    private void setReassignOrHandoverInfo(WorkItemMessageDTO.WorkItem workItem, JSONObject messageFiled, JSONObject content) {
        if (!this.workItemCreateTypes.contains(workItem.getCreateType())) {
            return;
        }
        Integer operationType = this.operationTypeMap.get(workItem.getCreateType());
        messageFiled.put((Object)"operationType", (Object)operationType);
        content.put((Object)"operationType", (Object)operationType);
        List<ReassignTrace> traceList = this.ptmService.selectReassignOrHandoverTrace(workItem.getFromWorkItemId(), operationType);
        String operator = CollectionUtils.isNotEmpty(traceList) ? traceList.get(0).getOperatorName() : null;
        messageFiled.put((Object)"operator", (Object)operator);
        content.put((Object)"operator", (Object)operator);
    }

    private String getLangKey(String langKey, Integer createType) {
        if (Objects.equals(createType, this.CREATE_TYPE_REASSIGN)) {
            langKey = langKey + ".reassign";
        } else if (Objects.equals(createType, this.CREATE_TYPE_HANDOVER)) {
            langKey = langKey + ".handover";
        }
        return langKey;
    }
}

