/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.quartz.impl;

import com.digiwin.athena.abt.application.dto.migration.abt.quartz.CronSchedulerJob;
import com.digiwin.athena.abt.application.service.abt.migration.quartz.JobManager;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobManagerImpl
implements JobManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobManagerImpl.class);
    @Autowired
    private Scheduler scheduler;

    @Override
    public void createCronJob(CronSchedulerJob job) {
        this.createCronJob(job, false);
    }

    @Override
    public void createCronJob(CronSchedulerJob job, boolean replace) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("data", job.getJobDataJson());
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCron());
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(job.getName(), job.getGroup()).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        try {
            JobDetail jobDetail = JobBuilder.newJob(job.getJobClass()).withIdentity(job.getName(), job.getGroup()).setJobData(jobDataMap).build();
            CronExpression.validateExpression((String)job.getCron());
            if (replace) {
                log.info("update job: {}.{}: job-{}", new Object[]{job.getName(), job.getGroup(), job});
            } else {
                log.info("create job: {}.{}: job-{}", new Object[]{job.getName(), job.getGroup(), job});
            }
            this.scheduler.scheduleJob(jobDetail, (Set)Sets.newHashSet((Object[])new CronTrigger[]{trigger}), replace);
        }
        catch (Exception ex) {
            log.error("create job: {}.{} error: job-{}, error-{}", new Object[]{job.getName(), job.getGroup(), job, ex.getMessage()});
            throw BusinessException.create((String)"add cron job failed.", (Throwable)ex);
        }
    }

    @Override
    public boolean deleteJob(String jobName, String jobGroup) {
        try {
            boolean result = this.scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroup));
            log.info("delete job: {}.{} result: {}", new Object[]{jobName, jobGroup, result});
            return result;
        }
        catch (Exception ex) {
            log.error("delete job: {}.{} error: {}", new Object[]{jobName, jobGroup, ex.getMessage()});
            throw BusinessException.create((String)"delete job failed.", (Throwable)ex);
        }
    }

    @Override
    public <T extends Trigger> T getJobTrigger(String jobName) {
        try {
            return (T)this.scheduler.getTrigger(TriggerKey.triggerKey((String)jobName));
        }
        catch (SchedulerException ex) {
            log.error("get job trigger failed job: {} error: {}", (Object)jobName, (Object)ex.getMessage());
            throw BusinessException.create((String)"get job trigger failed.", (Throwable)ex);
        }
    }

    @Override
    public boolean exist(String jobName, String jobGroup) {
        try {
            return this.scheduler.checkExists(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException ex) {
            log.error("check job exist failed job: {}.{} error: {}", new Object[]{jobName, jobGroup, ex.getMessage()});
            throw BusinessException.create((String)"check job exist failed.", (Throwable)ex);
        }
    }

    @Override
    public void pauseScheduleJob(String jobName, String jobGroup) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            this.scheduler.pauseJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("pause job failed: {} {}", new Object[]{jobName, jobGroup, e});
            throw BusinessException.create((String)"\u5b9a\u65f6\u4efb\u52a1\u6682\u505c\u5931\u8d25:{}", (String)e.getMessage());
        }
    }

    @Override
    public void resumeScheduleJob(String jobName, String jobGroup) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            this.scheduler.resumeJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("resume job failed: {} {}", new Object[]{jobName, jobGroup, e});
            throw BusinessException.create((String)"\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25:{}", (String)e.getMessage());
        }
    }

    @Override
    public void runOnce(String jobName, String jobGroup) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            this.scheduler.triggerJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("trigger job failed: {} {}", new Object[]{jobName, jobGroup, e});
            throw BusinessException.create((String)"\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25:{}", (String)e.getMessage());
        }
    }

    @Override
    public Map<String, Object> getDetailJobData(String jobName, String jobGroup) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (jobDetail != null) {
                return jobDetail.getJobDataMap().getWrappedMap();
            }
            return null;
        }
        catch (SchedulerException e) {
            log.error("get jobDetail failed: {} {}", new Object[]{jobName, jobGroup, e});
            throw BusinessException.create((String)"\u83b7\u53d6\u5de5\u4f5c\u8be6\u60c5\u5931\u8d25:{}", (String)e.getMessage());
        }
    }
}

