/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.repair.impl;

import com.digiwin.athena.abt.application.dto.migration.abt.api.NoticeAbtRepairDto;
import com.digiwin.athena.abt.application.dto.migration.abt.api.NoticeWaitRepairDataDto;
import com.digiwin.athena.abt.application.dto.migration.abt.bk.ActivityBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.TaskEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.ActivityUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.DataUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.mongodb.MongodbService;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.ParserBo;
import com.digiwin.athena.abt.application.service.abt.migration.repair.NoticeRepairApcDataService;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BkTaskActivityService;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BusinessKeyService;
import com.digiwin.athena.abt.application.service.atmc.migration.parser.IParser;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmActivityRecordDTO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NoticeRepairApcDataServiceImpl
implements NoticeRepairApcDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoticeRepairApcDataServiceImpl.class);
    @Autowired
    private BusinessKeyService businessKeySercvice;
    @Autowired
    private IParser iParser;
    @Autowired
    private BkTaskActivityService bkTaskActivityService;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private MongodbService mongodbService;

    @Override
    public void repairApcData(NoticeAbtRepairDto dto, AuthoredUser user) {
        List<NoticeWaitRepairDataDto> list = dto.getList();
        String type = dto.getType();
        if (!CollectionUtils.isEmpty(list)) {
            for (NoticeWaitRepairDataDto dataDto : list) {
                this.deleteMongo(dataDto);
                this.insertData(dataDto, user, type);
            }
        }
    }

    private void deleteMongo(NoticeWaitRepairDataDto dataDto) {
        log.info("\u5220\u9664mongo\u6570\u636e\uff1a{}", (Object)dataDto);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"cardId").is((Object)Long.parseLong(dataDto.getWorkItemId())));
        this.mongodbService.delete(query, dataDto.getTenantId());
    }

    private void insertData(NoticeWaitRepairDataDto dataDto, AuthoredUser authoredUser, String type) {
        Boolean hasInsertBkTaskActivity = false;
        Boolean hasInsertOriBk = false;
        ActivityBusinessKeyDTO businessKeyDTO = this.buildProcessWorkItem(dataDto, authoredUser);
        ActivityUniformityMqDTO activityDataUniformityMqDTO = this.buildActivityUniformity(businessKeyDTO);
        boolean hasDataUniformityBk = false;
        ArrayList<JSONObject> bkList = new ArrayList<JSONObject>();
        try {
            TaskEvent taskEvent = new TaskEvent(JSONObject.fromObject((Object)activityDataUniformityMqDTO));
            List<ParserBo> parserBoList = this.iParser.parse(taskEvent, authoredUser);
            if (!CollectionUtils.isEmpty(parserBoList)) {
                hasDataUniformityBk = true;
                for (ParserBo parserBo : parserBoList) {
                    bkList.add(parserBo.getBkInfo());
                }
                this.businessKeySercvice.insertBkTaskActivity(parserBoList, businessKeyDTO.getWorkitemId(), businessKeyDTO.getTenantId(), "workitem");
                hasInsertBkTaskActivity = true;
            }
        }
        catch (Exception e) {
            log.warn("\u3010\u83b7\u53d6\u6570\u636e\u4e00\u81f4\u6027bk\u5931\u8d25\u3011\uff1a{}, {}", (Object)businessKeyDTO.getWorkitemId(), (Object)e.getMessage());
        }
        if (!hasDataUniformityBk) {
            try {
                Map<String, Object> bkMap = this.bkTaskActivityService.getTmBusinessKeyNew(businessKeyDTO.getTmTaskId(), businessKeyDTO.getTmActivityId(), businessKeyDTO.getBpmData());
                JSONArray bkValueList = new ArrayList();
                if (bkMap.containsKey("complex")) {
                    bkValueList = JSONArray.fromObject((Object)bkMap.get("complex"));
                }
                JSONArray bkObjectValueList = new ArrayList();
                if (bkMap.containsKey("simple")) {
                    bkObjectValueList = JSONArray.fromObject((Object)bkMap.get("simple"));
                }
                this.bkTaskActivityService.insertOriBk((List<JSONObject>)bkValueList, (List<Object>)bkObjectValueList, businessKeyDTO.getWorkitemId(), businessKeyDTO.getTenantId(), "workitem");
                hasInsertOriBk = true;
            }
            catch (Exception e) {
                log.warn("\u3010\u8bb0\u5f55BusinessKey\u548c\u9879\u76ee\u5361/\u4efb\u52a1\u5361\u7684\u5173\u8054\u5173\u7cfb\u5931\u8d25\u3011\uff1a{}, {}", (Object)businessKeyDTO.getWorkitemId(), (Object)e.getMessage());
            }
        }
        if (!hasInsertBkTaskActivity.booleanValue() && !hasInsertOriBk.booleanValue()) {
            log.info("\u7a0b\u5e8f\u8c03\u7528\u6267\u884c\u5931\u8d25\uff1a{}", (Object)dataDto);
            if ("1".equals(type)) {
                ArrayList<Map> list = new ArrayList<Map>();
                list.add(dataDto.toMap());
                this.mongodbService.insert(list, "noticeErrorCollection");
            }
        } else {
            log.info("\u624b\u52a8\u8c03\u7528\u6267\u884c\u6210\u529f\uff1a{}", (Object)dataDto);
            if ("2".equals(type)) {
                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"workItemId").is((Object)dataDto.getWorkItemId()).and("tenantId").is((Object)dataDto.getTenantId()));
                this.mongodbService.delete(query, "noticeErrorCollection");
            }
        }
    }

    private ActivityUniformityMqDTO buildActivityUniformity(ActivityBusinessKeyDTO businessKeyDTO) {
        DataUniformityMqDTO dataUniformityMqDTO = new DataUniformityMqDTO();
        dataUniformityMqDTO.setBusinessUnit(businessKeyDTO.getBusinessUnit());
        dataUniformityMqDTO.setProcessVar(businessKeyDTO.getData());
        ActivityUniformityMqDTO activityDataUniformityMqDTO = ActivityUniformityMqDTO.builder().tenantId(businessKeyDTO.getTenantId()).state(businessKeyDTO.getState()).activityId(businessKeyDTO.getActivityId().toString()).activityTemplateId(businessKeyDTO.getTmActivityId()).subTaskTemplateId(businessKeyDTO.getTmTaskId()).subTaskId(businessKeyDTO.getSubTaskId().toString()).type("activity").messageData(dataUniformityMqDTO).build();
        return activityDataUniformityMqDTO;
    }

    private ActivityBusinessKeyDTO buildProcessWorkItem(NoticeWaitRepairDataDto dataDto, AuthoredUser user) {
        PtmTaskRecordBO ptmTaskRecordBO = this.ptmService.getTaskRecord(dataDto.getTaskId(), Long.parseLong(dataDto.getWorkItemId()));
        PtmActivityRecordDTO ptmActivityRecordDTO = this.ptmService.getActivityRecord(dataDto.getActivityId());
        PtmProjectRecordBO ptmProjectRecordBO = this.ptmService.getProjectRecord(dataDto.getProjectId());
        ActivityBusinessKeyDTO activityBusinessKeyDTO = new ActivityBusinessKeyDTO();
        activityBusinessKeyDTO.setSubTaskId(ptmProjectRecordBO.getId());
        activityBusinessKeyDTO.setTenantId(ptmProjectRecordBO.getTenantId());
        activityBusinessKeyDTO.setTmTaskId(ptmProjectRecordBO.getProjectDefCode());
        activityBusinessKeyDTO.setState(ptmActivityRecordDTO.getState());
        activityBusinessKeyDTO.setActivityId(dataDto.getActivityId());
        activityBusinessKeyDTO.setBusinessUnit(JSONObject.fromObject((Object)ptmTaskRecordBO.getBusinessUnit()));
        activityBusinessKeyDTO.setData(JSONObject.fromObject((Object)ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setTmActivityId(ptmTaskRecordBO.getTaskDefCode());
        activityBusinessKeyDTO.setBpmData(JSONObject.fromObject((Object)ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setWorkitemId(Long.parseLong(dataDto.getWorkItemId()));
        activityBusinessKeyDTO.setClosed(ptmActivityRecordDTO.getState() >= 3);
        activityBusinessKeyDTO.setAuthoredUser(user);
        return activityBusinessKeyDTO;
    }
}

