/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.impl;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionReq;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionResp;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AtmcServiceImpl
implements AtmcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtmcServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    private static final String VERIFY_APP_PERMISSION = "/api/atmc/v1/permission/verifyAppPermission";
    public static final String CONFIG = "api/atmc/v1/config/operationConfig";

    @Override
    public List<Map<String, Object>> findTaskBacklogH(Map<String, Object> paramMap, String locale) {
        List list = null;
        String url = this.envProperties.getAtmcUri() + "api/atmc/v1/taskBacklog/history/findTaskBacklogH";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        String archiveRouteKey = MapUtils.getString(paramMap, (Object)"archiveRouteKey", (String)"");
        headers.add("archive-route-key", archiveRouteKey);
        if (StringUtils.isEmpty((String)locale)) {
            locale = "zh_CN";
        }
        headers.add("locale", locale);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, paramMap);
        Map result = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        if (result == null) {
            return new ArrayList<Map<String, Object>>();
        }
        if (null == MapUtils.getObject((Map)result, (Object)"records")) {
            return new ArrayList<Map<String, Object>>();
        }
        list = (List)MapUtils.getObject((Map)result, (Object)"records");
        return list;
    }

    @Override
    public String getShareCode(String taskId, String taskType) {
        String url = this.envProperties.getAtmcUri() + "/api/atmc/v1/share/code?taskType=%s&taskId=%s";
        url = String.format(url, taskType, taskId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        JSONObject reqObject = JSONObject.fromObject((Object)this);
        HttpEntity httpEntity = new HttpEntity((Object)reqObject, (MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42ATMC\u83b7\u53d6\u5206\u4eab\u7801 \u5165\u53c2:{}", (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<String>>(){}, new Object[0]);
            log.info("\u8bf7\u6c42ATMC\u83b7\u53d6\u5206\u4eab\u7801\uff0c\u5165\u53c2url\uff1a{}, \u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)url, ((BaseResultDTO)respEntity.getBody()).getResponse());
            if (null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
                return (String)((BaseResultDTO)respEntity.getBody()).getResponse();
            }
        }
        catch (BusinessException ex) {
            log.error("\u8bf7\u6c42ATMC\u83b7\u53d6\u5206\u4eab\u7801\u62a5\u9519\uff0c\u5165\u53c2url\uff1a{}, ex\uff1a{}", (Object)url, (Object)ex);
        }
        return "";
    }

    @Override
    public VerifyAppPermissionResp verifyAppPermission(VerifyAppPermissionReq verifyAppPermissionReq) {
        String url = this.envProperties.getAtmcUri() + VERIFY_APP_PERMISSION;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)BeanUtil.beanToMap((Object)verifyAppPermissionReq, (String[])new String[0]), (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<VerifyAppPermissionResp>>(){}, new Object[0]);
        return (VerifyAppPermissionResp)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public Boolean verifyConfig(String configName, String name) {
        String url = this.envProperties.getAtmcUri() + CONFIG;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("configName", configName);
        params.put("operation", 0);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)BeanUtil.beanToMap(params, (String[])new String[0]), (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, new Object[0]);
        return (Boolean)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }
}

