/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.retry.handler;

import com.digiwin.athena.abt.application.service.abt.migration.retry.constant.MqRetryLogTypeEnum;
import com.digiwin.athena.abt.application.service.abt.migration.retry.dto.MqRetryLogBo;
import com.digiwin.athena.abt.application.service.abt.migration.retry.service.MqRetryLogService;
import com.digiwin.athena.framework.mq.retry.RabbitMqRetryProperties;
import com.digiwin.athena.framework.mq.retry.context.MQRetryContextHolder;
import com.digiwin.athena.framework.mq.retry.exception.RejectMQException;
import com.digiwin.athena.framework.mq.retry.handler.BeforeHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="ptmMqBeforeHandler")
@ConditionalOnProperty(prefix="athena.mq.retry", name={"enable"}, havingValue="true")
public class PtmMqBeforeHandler
implements BeforeHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmMqBeforeHandler.class);
    private final MqRetryLogService mqRetryLogService;
    private final RabbitMqRetryProperties retryProperties;

    public PtmMqBeforeHandler(MqRetryLogService mqRetryLogService, RabbitMqRetryProperties retryProperties) {
        this.mqRetryLogService = mqRetryLogService;
        this.retryProperties = retryProperties;
    }

    public void invokeHandler() {
        MQRetryContextHolder.MQRetryContext context = MQRetryContextHolder.getContext();
        MqRetryLogBo mqRetryLog = this.mqRetryLogService.getRetryLog(context.getQueueBinding().getMessage());
        if (this.checkConsumeSucess(mqRetryLog)) {
            this.mqRetryLogService.sendWeixin(context, mqRetryLog, "\u91cd\u590d\u6d88\u606f\u544a\u8b66");
            throw new RejectMQException("\u5df2\u7ecf\u6d88\u8d39\u6210\u529f\u6216\u8005\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570");
        }
    }

    private boolean checkConsumeSucess(MqRetryLogBo mqRetryLog) {
        if (MqRetryLogTypeEnum.SUCCESS.getType() == mqRetryLog.getStatus().intValue()) {
            return true;
        }
        return (long)mqRetryLog.getMqRetrycount().intValue() > this.retryProperties.getMaxMQRetryCount();
    }
}

