/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.retry.handler;

import com.digiwin.athena.abt.application.service.abt.migration.retry.dto.MqRetryLogBo;
import com.digiwin.athena.abt.application.service.abt.migration.retry.service.MqRetryLogService;
import com.digiwin.athena.framework.mq.retry.context.MQRetryContextHolder;
import com.digiwin.athena.framework.mq.retry.exception.OverLimitException;
import com.digiwin.athena.framework.mq.retry.exception.RejectMQException;
import com.digiwin.athena.framework.mq.retry.handler.FailureHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="ptmMqFailureHandler")
@ConditionalOnProperty(prefix="athena.mq.retry", name={"enable"}, havingValue="true")
public class PtmMqFailureHandler
implements FailureHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmMqFailureHandler.class);
    private final MqRetryLogService mqRetryLogService;

    public PtmMqFailureHandler(MqRetryLogService mqRetryLogService) {
        this.mqRetryLogService = mqRetryLogService;
    }

    public void invokeHandler() {
        MQRetryContextHolder.MQRetryContext context = MQRetryContextHolder.getContext();
        Object message = context.getQueueBinding().getMessage();
        MqRetryLogBo retryLog = this.mqRetryLogService.getRetryLog(message);
        if (!(context.getLastException() instanceof RejectMQException) && !(context.getLastException() instanceof OverLimitException)) {
            this.mqRetryLogService.fail(retryLog, context.getLastException());
            this.mqRetryLogService.sendWeixin(context, retryLog, "\u6d88\u8d39\u5f02\u5e38\u544a\u8b66");
        }
    }
}

