/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.retry.service;

import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmMqMessageDTO;
import com.digiwin.athena.abt.application.service.abt.migration.retry.constant.MqRetryLogTypeEnum;
import com.digiwin.athena.abt.application.service.abt.migration.retry.dto.MqRetryLogBo;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.mq.monitor.util.CommonUtil;
import com.digiwin.athena.framework.mq.retry.context.MQRetryContextHolder;
import com.digiwin.athena.framework.mq.retry.exception.RejectMQException;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.alarm.adapter.qywx.JaQyWxAlarm;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;

@Component
public class MqRetryLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqRetryLogService.class);
    private static final int MAX_RETRIES = 3;
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate apiLogMongoTemplate;

    public MqRetryLogBo getRetryLog(Object msgObj) {
        String message = null;
        if (msgObj instanceof String) {
            message = (String)msgObj;
        } else if (msgObj instanceof byte[]) {
            message = new String((byte[])msgObj);
        } else {
            throw new RejectMQException("\u8be5\u6d88\u606f\u7c7b\u578b\u4e0d\u652f\u6301\u6d88\u8d39");
        }
        PtmMqMessageDTO messageDTO = (PtmMqMessageDTO)JsonUtils.jsonToObject((String)message, PtmMqMessageDTO.class);
        log.info("\u6839\u636emessageId={},mqQueue={},\u67e5\u8be2", (Object)messageDTO.getMessageId(), (Object)MQRetryContextHolder.getContext().getQueueBinding().getQueueName());
        MqRetryLogBo mqRetryLog = this.queryMqRetryLogByMessageId(messageDTO);
        if (null != mqRetryLog) {
            return mqRetryLog;
        }
        return this.insertMqRetryLog(messageDTO, message, MqRetryLogTypeEnum.PROCESSING.getType());
    }

    private MqRetryLogBo queryMqRetryLogByMessageId(PtmMqMessageDTO messageDTO) {
        try {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)messageDTO.getMessageId()).and("mqQueue").is((Object)MQRetryContextHolder.getContext().getQueueBinding().getQueueName()));
            query.fields().include("mqRetrycount").include("localRetrycount").include("status").include("_id").include("errorMsg").include("operation").include("pinpointId").include("type").include("messageId").include("mqQueue").include("createTime");
            return (MqRetryLogBo)this.apiLogMongoTemplate.findOne(query, MqRetryLogBo.class, "mq_retry_log");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d88\u606f\u65e5\u5fd7\u8868\u5931\u8d25\uff0cmessageId:{}, msg:{}", (Object)messageDTO.getMessageId(), (Object)e.getMessage());
            return null;
        }
    }

    private MqRetryLogBo insertMqRetryLog(PtmMqMessageDTO messageDTO, String data, Integer status) {
        try {
            Date date = new Date();
            MqRetryLogBo mqRetryLog = new MqRetryLogBo();
            mqRetryLog.setMqRetrycount(0);
            mqRetryLog.setLocalRetrycount(0);
            mqRetryLog.setType(messageDTO.getType().getValue());
            mqRetryLog.setMessageId(messageDTO.getMessageId());
            mqRetryLog.setPinpointId(JaMDC.get());
            mqRetryLog.setOperation(messageDTO.getOperation().getValue());
            mqRetryLog.setCreateTime(date);
            mqRetryLog.setUpdateTime(date);
            mqRetryLog.setStatus(status);
            mqRetryLog.setData(data);
            mqRetryLog.setSourceId("abt");
            mqRetryLog.setMqVirtualHost(JaProperty.get((String)"spring.rabbitmq.virtual-host"));
            mqRetryLog.setMqExchange(MQRetryContextHolder.getContext().getQueueBinding().getExchangeName());
            mqRetryLog.setMqRouteKey(MQRetryContextHolder.getContext().getQueueBinding().getRoutingkey());
            mqRetryLog.setMqQueue(MQRetryContextHolder.getContext().getQueueBinding().getQueueName());
            mqRetryLog.setExpireTime(DateUtils.addSeconds((Date)date, (int)((int)TimeUnit.HOURS.toSeconds(JaProperty.getLong((String)"athena.mq.retry.expireSuccess", (Long)24L)))));
            this.apiLogMongoTemplate.insert((Object)mqRetryLog, "mq_retry_log");
            return mqRetryLog;
        }
        catch (Exception e) {
            throw new BusinessException("\u63d2\u5165\u8868\u5931\u8d25");
        }
    }

    private MqRetryLogBo queryMqRetryLogByBizId(PtmMqMessageDTO messageDTO, Long bizId) {
        try {
            if (null != messageDTO.getType() && null != messageDTO.getOperation() && null != bizId) {
                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)messageDTO.getType().getValue()).and("operation").is((Object)messageDTO.getOperation().getValue()).and("bizId").is((Object)(bizId + "")).and("mqQueue").is((Object)MQRetryContextHolder.getContext().getQueueBinding().getQueueName()));
                query.fields().include("mqRetrycount").include("localRetrycount").include("status").include("_id").include("operation").include("pinpointId").include("type").include("messageId").include("errorMsg").include("mqQueue").include("createTime");
                return (MqRetryLogBo)this.apiLogMongoTemplate.findOne(query, MqRetryLogBo.class, "mq_retry_log");
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d88\u606f\u65e5\u5fd7\u8868\u5931\u8d25\uff0cmessageId:{}, msg:{}", (Object)messageDTO.getMessageId(), (Object)e.getMessage());
            return null;
        }
    }

    public void fail(MqRetryLogBo mqRetryLog, Throwable ex) {
        int attempt = 0;
        while (true) {
            try {
                ++attempt;
                this.updateMqRetryLog(mqRetryLog, ex, MqRetryLogTypeEnum.FAIL.getType());
            }
            catch (Exception e) {
                if (attempt >= 3) {
                    log.error("\u66f4\u65b0\u6d88\u606f\u65e5\u5fd7\u8868\u5931\u8d25\uff0cmessageId:{}, msg:{}", (Object)mqRetryLog.getMessageId(), (Object)e.getMessage());
                    break;
                }
                log.error("\u66f4\u65b0\u6d88\u606f\u65e5\u5fd7\u8868\u5931\u8d25\uff0cmessageId:{},\u91cd\u8bd5\u6b21\u6570:{},msg:{}", new Object[]{mqRetryLog.getMessageId(), attempt, e.getMessage()});
                continue;
            }
            break;
        }
    }

    public void success(MqRetryLogBo mqRetryLog) {
        int attempt = 0;
        while (true) {
            try {
                ++attempt;
                this.updateMqRetryLog(mqRetryLog, null, MqRetryLogTypeEnum.SUCCESS.getType());
            }
            catch (Exception e) {
                if (attempt >= 3) {
                    log.error("\u66f4\u65b0\u6d88\u606f\u65e5\u5fd7\u8868\u5931\u8d25\uff0cmessageId:{},\u91cd\u8bd5\u6b21\u6570:{},msg:{}", new Object[]{mqRetryLog.getMessageId(), attempt, e.getMessage()});
                    break;
                }
                log.error("\u66f4\u65b0\u6d88\u606f\u65e5\u5fd7\u8868\u5931\u8d25\uff0cmessageId:{},\u91cd\u8bd5\u6b21\u6570:{},msg:{}", new Object[]{mqRetryLog.getMessageId(), attempt, e.getMessage()});
                continue;
            }
            break;
        }
    }

    private void updateMqRetryLog(MqRetryLogBo mqRetryLog, Throwable ex, Integer status) {
        log.info("\u6839\u636emessageId={},mqQueue={},id={},\u66f4\u65b0={}", new Object[]{mqRetryLog.getMessageId(), mqRetryLog.getMqQueue(), mqRetryLog.getId(), status});
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mqRetryLog.getId()));
        Update update = new Update();
        if (null != ex) {
            String errorMsg = ex.getClass().getName() + ":" + ex.getMessage() + ":" + ex.getStackTrace()[0];
            update.set("errorMsg", (Object)errorMsg);
            update.set("errorDetail", (Object)MqRetryLogService.toString(ex));
            mqRetryLog.setErrorMsg(errorMsg);
        }
        update.set("mqRetrycount", (Object)MQRetryContextHolder.getContext().getMqRetrycount());
        update.set("localRetrycount", (Object)MQRetryContextHolder.getContext().getLocalRetrycount());
        update.set("updateTime", (Object)new Date());
        update.set("status", (Object)status);
        if (MqRetryLogTypeEnum.FAIL.getType() == status.intValue()) {
            update.set("expireTime", (Object)DateUtils.addSeconds((Date)mqRetryLog.getCreateTime(), (int)((int)TimeUnit.HOURS.toSeconds(JaProperty.getLong((String)"athena.mq.retry.expireFail", (Long)72L)))));
        }
        this.apiLogMongoTemplate.updateFirst(query, (UpdateDefinition)update, "mq_retry_log");
    }

    public static String toString(Throwable throwable) {
        StackTraceElement[] stackTrace;
        if (throwable == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append(throwable.toString()).append(System.lineSeparator());
        for (StackTraceElement element : stackTrace = throwable.getStackTrace()) {
            sb.append("\tat ").append(element.toString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public void sendWeixin(MQRetryContextHolder.MQRetryContext context, MqRetryLogBo retryLog, String type) {
        if (!JaProperty.getBoolean((String)"athena.mq.monitor.enable", (Boolean)false).booleanValue()) {
            return;
        }
        JaQyWxAlarm jaQyWxAlarm = new JaQyWxAlarm("default");
        jaQyWxAlarm.setUrl("https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=" + JaProperty.get((String)"athena.mq.monitor.botKey"));
        String appEnv = JaEnvProperty.getEnv();
        String content = String.format("\u3010\u62a5\u8b66\u3011Rabbitmq\u6d88\u606f\u544a\u8b66 \n\u73af\u5883\uff1a%s\n\u961f\u5217\u540d\u79f0\uff1a%s\n\u6d88\u606fid\uff1a%s\n\u6d88\u606f\u7c7b\u578b\uff1a%s\n\u6d88\u606f\u64cd\u4f5c\u7c7b\u578b\uff1a%s\n\u62a5\u8b66\u9879\uff1a%s\n\u672c\u5730\u91cd\u8bd5\u6b21\u6570\uff1a%s\nmq\u91cd\u8bd5\u6b21\u6570\uff1a%s\n\u9519\u8bef\u4fe1\u606f\uff1a%s\npinpointId\uff1a%s\n\u6267\u884c\u7ebf\u7a0b\uff1a%s\n\u62a5\u8b66\u65f6\u95f4\uff1a%s\n", appEnv, context.getQueueBinding().getQueueName(), retryLog.getMessageId(), retryLog.getType(), retryLog.getOperation(), type, context.getLocalRetrycount(), context.getMqRetrycount(), null == retryLog.getErrorMsg() ? "" : retryLog.getErrorMsg(), retryLog.getPinpointId(), Thread.currentThread().getName(), CommonUtil.now());
        jaQyWxAlarm.alarm(content);
    }
}

