/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.sendmsg;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmDataConsistencyMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.TaskOperateSendMsgDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.TaskOperateSendMsgHandler;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.utils.ActivityUtils;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmBacklogItemBO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskOperateSendMsgMqService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskOperateSendMsgMqService.class);
    @Resource
    private TaskOperateSendMsgHandler taskOperateSendMsgHandler;
    @Resource
    private PtmService ptmService;

    public void processBacklogOverDueMessage(String data, AuthoredUser user) {
        PtmBacklogMessageDTO backlogMessageDTO = (PtmBacklogMessageDTO)JsonUtils.jsonToObject((String)data, PtmBacklogMessageDTO.class);
        PtmBacklogMessageDTO.Backlog backlog = backlogMessageDTO.getData().getBacklog();
        if (backlog.getHidden().booleanValue()) {
            return;
        }
        TaskOperateSendMsgDTO taskOperateSendMsgDTO = new TaskOperateSendMsgDTO();
        taskOperateSendMsgDTO.setAuthoredUser(user);
        taskOperateSendMsgDTO.setSource("athena");
        taskOperateSendMsgDTO.setType("taskOverdue");
        taskOperateSendMsgDTO.setBacklogId(backlog.getBacklogId());
        taskOperateSendMsgDTO.setWorkItemId(backlog.getWorkItemId());
        taskOperateSendMsgDTO.setTaskName(backlog.getTaskName());
        taskOperateSendMsgDTO.setPerformerId(backlog.getPerformerId());
        taskOperateSendMsgDTO.setPerformerName(backlog.getPerformerName());
        log.info("[taskOperateSendMsg] send message, message = {}", (Object)JsonUtils.objectToString((Object)taskOperateSendMsgDTO));
        this.taskOperateSendMsgHandler.process(taskOperateSendMsgDTO);
    }

    public void processWorkItemAddMessage(String data, AuthoredUser user) {
        Optional<PtmBacklogItemBO> optional;
        PtmDataConsistencyMessageDTO message = ActivityUtils.convertPtmDataConsistencyMsg(data);
        PtmDataConsistencyMessageDTO.MqData mqData = message.getData();
        if (BooleanUtils.isTrue((Boolean)mqData.getMinSplit())) {
            log.info("\u6700\u5c0f\u5316\u62c6\u5206\u4e0d\u652f\u6301\uff0c\u4e14\u8be5\u573a\u666f\u5df2\u65e0\u5e94\u7528\u4f7f\u7528");
            return;
        }
        List<PtmDataConsistencyMessageDTO.WorkItem> workItemList = message.getData().getWorkItem();
        if (CollectionUtil.isEmpty(workItemList)) {
            return;
        }
        PtmDataConsistencyMessageDTO.WorkItem workItem = workItemList.get(0);
        TaskOperateSendMsgDTO taskOperateSendMsgDTO = new TaskOperateSendMsgDTO();
        taskOperateSendMsgDTO.setAuthoredUser(user);
        taskOperateSendMsgDTO.setSource("athena");
        taskOperateSendMsgDTO.setType("taskCreated");
        taskOperateSendMsgDTO.setBacklogId(workItem.getBacklogId());
        taskOperateSendMsgDTO.setWorkItemId(workItem.getId());
        List<PtmBacklogItemBO> ptmBacklogItemBOList = this.ptmService.getBacklogByBacklogId(workItem.getBacklogId());
        if (CollectionUtil.isNotEmpty(ptmBacklogItemBOList) && (optional = ptmBacklogItemBOList.stream().filter(ptmBacklogItemDTO -> ptmBacklogItemDTO.getWorkItemId().equals(workItem.getId())).findFirst()).isPresent()) {
            taskOperateSendMsgDTO.setTaskName(optional.get().getTaskName());
            taskOperateSendMsgDTO.setPerformerId(optional.get().getPerformerId());
            taskOperateSendMsgDTO.setPerformerName(optional.get().getPerformerName());
        }
        log.info("[taskOperateSendMsg] send message, message = {}", (Object)JsonUtils.objectToString((Object)taskOperateSendMsgDTO));
        this.taskOperateSendMsgHandler.process(taskOperateSendMsgDTO);
    }
}

