/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.summary;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmMqCardMessageService;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

@Service
public class EventBusinessMessageModel
extends EventBaseService
implements EventInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventBusinessMessageModel.class);
    @Autowired
    private PtmMqCardMessageService ptmMqCardMessageService;

    @Override
    public String modelType() {
        return "businessMessageModel";
    }

    @Override
    public void distributeMessages(String data) {
        this.rabbitTemplate.convertAndSend("athena.event.message", "athena.event.business.message", (Object)data);
    }

    @Override
    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="athena.event.business.message", durable="true", autoDelete="false"), exchange=@Exchange(value="athena.event.message", type="topic"), key={"athena.event.business.message"})}, concurrency="#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('athena.event.business.message')}")
    @RabbitRetry(beforeHandler="ptmMqBeforeHandler", successHander="ptmMqSuccessHandler", failureHandler="ptmMqFailureHandler")
    public void consumeMessage(String data, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Header(value="retry-count", required=false) Integer retryCount) {
        super.receiveOrder(data, "athena.event.business.message", channel, tag, retryCount);
    }

    @Override
    public void processMessage(String data, EventListenerDTO mqMessageDTO) {
        AuthoredUser user = super.getUser(mqMessageDTO);
        LogDto logDto = new LogDto("\u3010EventBusinessMessageModel\u3011\u5904\u7406\u9879\u76ee\u5361/\u4efb\u52a1\u5361\u4e1a\u52a1\u6570\u636e\u6d88\u606f\uff0c\u6d88\u606f\u7c7b\u578b\uff1a" + mqMessageDTO.getType(), user.getTenantId() + ";" + mqMessageDTO.getType());
        log.info(logDto.toString());
        if (EventMqTypeEnum.projectCard.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqCardMessageService.processProjectCardMessage(user, data);
        } else if (EventMqTypeEnum.backlog.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqCardMessageService.processSpecialBacklogMessage(user, data);
        } else if (EventMqTypeEnum.dataConsistency.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqCardMessageService.processCardMessage(user, data);
        } else if (EventMqTypeEnum.flowProjectCard.equals((Object)mqMessageDTO.getType()) || EventMqTypeEnum.flowWorkItem.equals((Object)mqMessageDTO.getType())) {
            user = mqMessageDTO.getFlowUser();
            this.ptmMqCardMessageService.processFlowMessage(user, data);
        }
        this.ptmMqCardMessageService.removeCloseBusinessMessage(user, data, mqMessageDTO);
    }
}

