/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.summary;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.api.RefreshCardDto;
import com.digiwin.athena.abt.application.dto.migration.abt.api.RefreshCardInfo;
import com.digiwin.athena.abt.application.dto.migration.abt.api.RefreshCardMessageCompensateDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.quartz.CronSchedulerJob;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardJob;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardJobData;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardTaskContext;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardInfosDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.UpdateTaskWorkItemMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.agile.CardDataParam;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardInfoDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardItemDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardItemDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActionDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActionParameterDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityPageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmDataFilter;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmDataState;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskCardFields;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.abt.migration.quartz.JobManager;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageService;
import com.digiwin.athena.abt.application.service.abt.migration.summary.executor.RefreshCardMessageExecutor;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.BacklogActionCreateService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.CommonBacklogAbstractService;
import com.digiwin.athena.abt.application.service.atmc.migration.project.CommonProjectHandleService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.AglieService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.TenantService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.dataFootPrint.DataFootPrintService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.BKUtils;
import com.digiwin.athena.abt.application.utils.BacklogAbstractUtil;
import com.digiwin.athena.abt.application.utils.CommonUtils;
import com.digiwin.athena.abt.application.utils.CronExprUtils;
import com.digiwin.athena.abt.core.meta.enums.CardTypeEnum;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.event.job.RefreshCardJob;
import com.digiwin.athena.abt.event.job.RefreshCardMessageJob;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskWorkitemMessageMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.BacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskCardItemBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskWorkitemMessage;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jugg.agile.framework.core.util.concurrent.JaRunnable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class RefreshCardMessageServiceImpl
implements RefreshCardMessageService,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshCardMessageServiceImpl.class);
    @Autowired
    private JobManager jobManager;
    @Autowired
    private List<RefreshCardMessageExecutor> refreshCardMessageExecutors;
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolRefreshCardTaskExecutor;
    @Autowired
    private PtmService ptmService;
    @Autowired
    ThemeMapService themeMapService;
    @Autowired
    private DataFootPrintService dataFootPrintService;
    @Autowired
    BacklogActionCreateService backlogActionCreateService;
    @Autowired
    AglieService aglieService;
    @Autowired
    private BacklogAbstractUtil backlogAbstractUtil;
    @Autowired
    protected CommonProjectHandleService commonProjectHandleService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private TaskWorkitemMessageMapper taskWorkItemMessageMapper;
    @Autowired
    private CommonBacklogAbstractService commonBacklogAbstractService;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Resource
    private TenantService tenantService;
    @Autowired
    private TaskWorkitemMessageMapper taskWorkitemMessageMapper;
    private static final List<String> REFRESH_CARD_TYPES = Lists.newArrayList((Object[])new String[]{"summary", "business"});
    private Map<Integer, RefreshCardMessageExecutor> refreshCardMessageExecutorMap = new HashMap<Integer, RefreshCardMessageExecutor>();

    public void afterPropertiesSet() throws Exception {
        for (RefreshCardMessageExecutor refreshCardMessageExecutor : this.refreshCardMessageExecutors) {
            if (this.refreshCardMessageExecutorMap.containsKey(refreshCardMessageExecutor.cardType())) {
                throw new IllegalStateException("\u91cd\u590d\u6ce8\u518c " + refreshCardMessageExecutor.cardType() + " , " + refreshCardMessageExecutor.getClass().getSimpleName());
            }
            this.refreshCardMessageExecutorMap.put(refreshCardMessageExecutor.cardType(), refreshCardMessageExecutor);
        }
    }

    @Override
    public Boolean createRefreshCardMessageJobIfAbsent(RefreshCardMessageDTO refreshCardMessageDTO) {
        CardTypeEnum.checkCardType((int)refreshCardMessageDTO.getCardType());
        boolean jobExist = this.jobManager.exist(refreshCardMessageDTO.getId().toString(), "REFRESH_TASK_MESSAGE_GROUP");
        if (jobExist) {
            log.info("refresh card message job:{}.{} already exist, skip create..", (Object)refreshCardMessageDTO.getId(), (Object)"REFRESH_TASK_MESSAGE_GROUP");
            return Boolean.FALSE;
        }
        CronSchedulerJob job = new CronSchedulerJob();
        job.setName(String.valueOf(refreshCardMessageDTO.getId()));
        job.setGroup("REFRESH_TASK_MESSAGE_GROUP");
        job.setJobClass(RefreshCardMessageJob.class);
        job.setCron(CronExprUtils.genRandomCronExpr());
        job.setDesc(refreshCardMessageDTO.getDesc());
        job.setJobDataJson(JsonUtils.objectToString((Object)refreshCardMessageDTO));
        log.info("create refresh card message job:{}.{}, cron:{}", new Object[]{job.getName(), job.getGroup(), job.getCron()});
        this.jobManager.createCronJob(job);
        return Boolean.TRUE;
    }

    @Override
    public void deleteRefreshCardMessageJob(String taskKeyName) {
        log.info("delete refresh card message job:{}.{}", (Object)taskKeyName, (Object)"REFRESH_TASK_MESSAGE_GROUP");
        this.jobManager.deleteJob(taskKeyName, "REFRESH_TASK_MESSAGE_GROUP");
    }

    @Override
    public void deleteJob(String jobName, String group) {
        this.jobManager.deleteJob(jobName, group);
    }

    @Override
    public void updateRefreshCardMessageJobData(RefreshCardMessageDTO refreshCardMessageDTO) {
        CronSchedulerJob job = new CronSchedulerJob();
        job.setName(String.valueOf(refreshCardMessageDTO.getId()));
        job.setGroup("REFRESH_TASK_MESSAGE_GROUP");
        job.setJobClass(RefreshCardMessageJob.class);
        CronTrigger trigger = (CronTrigger)this.jobManager.getJobTrigger(String.valueOf(refreshCardMessageDTO.getId()));
        String cronExpr = null != trigger ? trigger.getCronExpression() : CronExprUtils.genRandomCronExpr();
        job.setCron(cronExpr);
        job.setDesc(refreshCardMessageDTO.getDesc());
        job.setJobDataJson(JsonUtils.objectToString((Object)refreshCardMessageDTO));
        log.info("update refresh card message job:{}.{}", (Object)job.getName(), (Object)job.getGroup());
        this.jobManager.createCronJob(job, true);
    }

    @Override
    public void refreshCardMessage(RefreshCardMessageDTO refreshCardMessageDTO) {
        CardTypeEnum.checkCardType((int)refreshCardMessageDTO.getCardType());
        this.refreshCardMessageExecutorMap.get(refreshCardMessageDTO.getCardType()).execute(refreshCardMessageDTO);
    }

    @Override
    public void compensateRefreshCardMessage(List<RefreshCardMessageCompensateDTO> refreshCardMessageCompensateList) {
        refreshCardMessageCompensateList.forEach(refreshCardMessageCompensate -> CardTypeEnum.checkCardType((int)refreshCardMessageCompensate.getCardType()));
        for (RefreshCardMessageCompensateDTO refreshCardMessageCompensateDTO : refreshCardMessageCompensateList) {
            for (Long cardId : refreshCardMessageCompensateDTO.getCardIds()) {
                RefreshCardMessageDTO refreshCardMessageDTO = new RefreshCardMessageDTO();
                refreshCardMessageDTO.setId(cardId);
                refreshCardMessageDTO.setCardType(refreshCardMessageCompensateDTO.getCardType());
                refreshCardMessageDTO.setTenantId(refreshCardMessageCompensateDTO.getTenantId());
                refreshCardMessageDTO.setRefreshCardType(refreshCardMessageCompensateDTO.getRefreshCardType());
                this.createRefreshCardMessageJobIfAbsent(refreshCardMessageDTO);
            }
        }
    }

    @Override
    public String triggerManual(String jobName) {
        boolean jobExist = this.jobManager.exist(jobName, "REFRESH_TASK_MESSAGE_GROUP");
        if (jobExist) {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)"REFRESH_TASK_MESSAGE_GROUP");
            this.scheduler.triggerJob(jobKey);
            return CharSequenceUtil.format((CharSequence)"Manual triggering successful, jobName: {}, jobGroup: {}", (Object[])new Object[]{jobName, "REFRESH_TASK_MESSAGE_GROUP"});
        }
        return CharSequenceUtil.format((CharSequence)"Job not exist, jobName: {}, jobGroup: {}", (Object[])new Object[]{jobName, "REFRESH_TASK_MESSAGE_GROUP"});
    }

    @Override
    public void refreshCard(RefreshCardDto refreshCardDto) {
        String refreshCardType = refreshCardDto.getRefreshCardType();
        if (StringUtils.isBlank((String)refreshCardType)) {
            refreshCardDto.setRefreshCardType("business");
        }
        log.info("\u5f02\u6b65\u6267\u884c\u4efb\u52a1:{}", (Object)JsonUtils.objectToString((Object)refreshCardDto));
        this.threadPoolRefreshCardTaskExecutor.execute(JaRunnable.get(() -> {
            try {
                int size = this.getPartition();
                if (size > 0) {
                    StopWatch stopWatch = new StopWatch();
                    stopWatch.start("refreshCard");
                    AuthoredUser authoredUserThread = AppAuthContextHolder.getContext().getAuthoredUser();
                    if (authoredUserThread == null) {
                        log.warn("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                        return;
                    }
                    log.info("\u79df\u6237:{},\u6267\u884c\u5237\u65b0\u6570\u636e:{}", (Object)authoredUserThread.getTenantId(), (Object)JsonUtils.objectToString((Object)refreshCardDto));
                    List<RefreshCardInfo> cards = refreshCardDto.getCards();
                    Map<String, List<RefreshCardInfo>> collect = cards.stream().collect(Collectors.groupingBy(RefreshCardInfo::getType));
                    collect.forEach((k, v) -> {
                        CardTaskContext cardTaskContext = new CardTaskContext(authoredUserThread, this.getPartition(), 50, 30, 20);
                        for (RefreshCardInfo refreshCardInfo : v) {
                            CardJobData jobData = new CardJobData(refreshCardInfo.getCode(), authoredUserThread.getTenantId(), (String)k, refreshCardDto.getRefreshCardType());
                            this.refreshTaskCard(cardTaskContext, jobData);
                        }
                    });
                    stopWatch.stop();
                    log.info("process time get refreshCard:{}", (Object)stopWatch.getTotalTimeSeconds());
                }
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u5237\u65b0\u5361\u7247\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
        }));
    }

    private int getPartition() {
        String s = (String)this.redisTemplate.opsForValue().get((Object)"abt:refresh_card_partition_size");
        if (StringUtils.isBlank((String)s)) {
            return 100;
        }
        int size = Integer.parseInt(s);
        return Math.min(size, 100);
    }

    @Override
    public void refreshTaskCard(CardTaskContext cardTaskContext, CardJobData cardJobData) {
        String pageCode = cardJobData.getPagCode();
        String code = cardJobData.getCode();
        String refreshCardType = cardJobData.getRefreshCardType();
        if (TmPageName.TASK_CARD_NAME.getValue().equals(pageCode)) {
            TmActivityResponseDTO activityAction = this.themeMapService.getActivityAction(null, code, "task-card");
            if (activityAction == null) {
                log.warn("\u4efb\u52a1\u5b9a\u4e49\u4e3a\u7a7a:{}", (Object)code);
                return;
            }
            TmActivityPageDTO pages = activityAction.getPages();
            if (pages == null) {
                log.warn("\u4efb\u52a1\u5b9a\u4e49\u7684page\u4e3a\u7a7a:{}", (Object)code);
                return;
            }
            List<TmDataState> dataStates = pages.getDataStates();
            if (CollectionUtils.isEmpty(dataStates)) {
                log.warn("\u4efb\u52a1\u5b9a\u4e49\u7684\u6570\u636e\u72b6\u6001\u4e3a\u7a7a:{}", (Object)code);
                return;
            }
            ArrayList dataSourceNames = Lists.newArrayListWithExpectedSize((int)3);
            if (REFRESH_CARD_TYPES.contains(refreshCardType)) {
                this.setDataSourceNames(dataSourceNames, refreshCardType, dataStates);
            } else {
                for (String cardType : REFRESH_CARD_TYPES) {
                    this.setDataSourceNames(dataSourceNames, cardType, dataStates);
                }
            }
            if (CollectionUtils.isEmpty((Collection)dataSourceNames)) {
                log.warn("\u6839\u636e\u7c7b\u578b:{},\u8fc7\u6ee4\u7684\u6570\u636e\u6e90\u96c6\u5408\u4e3a\u7a7a", (Object)refreshCardType);
                return;
            }
            Set<String> processVariableKeys = this.getProcessVariableKeys(dataSourceNames, activityAction.getDataSources());
            this.processTaskCard(cardTaskContext, processVariableKeys, cardJobData);
        } else if (TmPageName.PROJECT_CARD_NAME.getValue().equals(pageCode)) {
            TmTaskDefineResponseDTO task = this.themeMapService.getTask(code);
            if (task != null) {
                Map pages = task.getPages();
                if (pages == null) {
                    return;
                }
                Object o = pages.get(pageCode);
                if (o == null) {
                    return;
                }
                TmActivityPageDTO tmActivityPageDTO = (TmActivityPageDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(o), TmActivityPageDTO.class);
                boolean flag = false;
                if (REFRESH_CARD_TYPES.contains(refreshCardType)) {
                    flag = this.checkExists(refreshCardType, tmActivityPageDTO);
                } else {
                    for (String cardType : REFRESH_CARD_TYPES) {
                        if (!this.checkExists(cardType, tmActivityPageDTO)) continue;
                        flag = true;
                        break;
                    }
                }
                if (!flag) {
                    return;
                }
            }
            this.processProjectCard(cardTaskContext, cardJobData);
        }
        this.triggerTask(cardTaskContext);
    }

    @Override
    public void updateCardInfo(CardJob cardJob) {
        AppAuthContext context = AppAuthContextHolder.getContext();
        AuthoredUser authoredUser = context.getAuthoredUser();
        CardJobData jobData = new CardJobData(cardJob.getCode(), cardJob.getTenantId(), cardJob.getPagCode(), cardJob.getRefreshCardType());
        CardTaskContext cardTaskContext = new CardTaskContext(authoredUser, this.getPartition(), 50, 30, 20);
        if (TmPageName.PROJECT_CARD_NAME.getValue().equals(cardJob.getPagCode())) {
            this.processProjectCard(cardJob.getIds(), cardTaskContext, jobData);
        } else {
            this.processTaskCard(cardJob.getIds(), cardTaskContext, this.getProcessVariableKeys(cardJob.getCode()), cardJob);
        }
        this.triggerTask(cardTaskContext);
    }

    @Override
    public void updateCardByBk(RefreshCardInfosDTO refreshCardInfos) {
        if (CollectionUtils.isNotEmpty(refreshCardInfos.getRefreshInfos())) {
            List<Map<String, Object>> maps = this.getBkConcatsData(refreshCardInfos);
            log.info("\u67e5\u8be2\u6570\u636e\u8db3\u8ff9\u5165\u53c2:{}", (Object)JsonUtils.objectToString(maps));
            List<Map<String, Object>> dataMaps = this.getUpdateCardData(maps, refreshCardInfos);
            log.info("\u5f85\u66f4\u65b0\u5361\u7247\u6570\u636e:{}", (Object)JsonUtils.objectToString(dataMaps));
            if (CollectionUtils.isNotEmpty(dataMaps)) {
                Map<Long, Map<String, Object>> updateBusinessMap = this.getUpdataBusinessMap(dataMaps, refreshCardInfos);
                log.info("\u5f85\u66f4\u65b0\u4e1a\u52a1\u6570\u636e:{}", (Object)JsonUtils.objectToString(updateBusinessMap));
                this.backlogAbstractUtil.saveOrUpdateBusinessMessageInner(refreshCardInfos.getTenantId(), refreshCardInfos.getPagCode(), updateBusinessMap);
            }
        }
    }

    @Override
    public void updateTaskWorkItemMessage(UpdateTaskWorkItemMessageDTO updateDTO) {
        String searchMessage;
        Map summaryMap = this.commonBacklogAbstractService.getBacklogCardAbstractById(updateDTO.getWorkItemId(), AppAuthContextHolder.getContext().getAuthoredUser(), updateDTO.getCardAbstractDTO(), updateDTO.getLangName());
        Long workItemId = updateDTO.getWorkItemId();
        if (MapUtils.isEmpty((Map)summaryMap)) {
            log.info("\u6458\u8981Map\u4e3a\u7a7a\u4e0d\u66f4\u65b0\uff1a{}", (Object)workItemId);
            return;
        }
        String summary = summaryMap.get("summaryLayout") != null ? summaryMap.get("summaryLayout").toString() : "";
        String string = searchMessage = summaryMap.get("searchMessage") != null ? summaryMap.get("searchMessage").toString() : "";
        if (StringUtils.isBlank((String)summary)) {
            log.info("\u6458\u8981\u4e3a\u7a7a\u4e0d\u66f4\u65b0\uff1a{}", (Object)workItemId);
            return;
        }
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("card_id", workItemId);
        List taskWorkitemMessageList = this.taskWorkitemMessageMapper.selectByMap(paramMap);
        if (CollectionUtils.isEmpty((Collection)taskWorkitemMessageList)) {
            log.info("TaskWorkitemMessage\u4e0d\u5b58\u5728\uff1a{}", (Object)workItemId);
            return;
        }
        int updated = this.taskWorkitemMessageMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskWorkitemMessage::getCardId, (Object)workItemId)).set(TaskWorkitemMessage::getSummary, (Object)summary)).set(TaskWorkitemMessage::getSearchMessage, (Object)searchMessage));
        if (updated > 0) {
            log.info("\u66f4\u65b0\u6458\u8981\u6210\u529f\uff1a{}\uff0c{}\uff0c{}", new Object[]{workItemId, summary, searchMessage});
        }
    }

    private String mergeMessage(String message, String subMessage) {
        if (StringUtils.isBlank((String)message)) {
            return subMessage;
        }
        if (StringUtils.equals((String)message, (String)subMessage) || StringUtils.isBlank((String)subMessage)) {
            return message;
        }
        return message + "<br>" + subMessage;
    }

    private Map<Long, Map<String, Object>> getUpdataBusinessMap(List<Map<String, Object>> dataMaps, RefreshCardInfosDTO refreshCardInfos) {
        HashMap updateBusinessMap = Maps.newHashMapWithExpectedSize((int)dataMaps.size());
        dataMaps.forEach(e -> {
            block5: {
                TmActivityPageDTO tmActivityPageDTO;
                List<TmDataState> dataStates;
                Object o;
                block6: {
                    if (!TmPageName.TASK_CARD_NAME.getValue().equals(refreshCardInfos.getPagCode())) break block6;
                    TmActivityResponseDTO activityResponseDTO = (TmActivityResponseDTO)e.get("define");
                    TmActivityPageDTO pages = activityResponseDTO.getPages();
                    if (pages == null || !CollectionUtils.isNotEmpty(pages.getDataStates())) break block5;
                    for (TmDataState dataState : pages.getDataStates()) {
                        if (!"all".equals(dataState.getType())) continue;
                        TmTaskCardFields taskCardFields = dataState.getTaskCardFields();
                        HashMap businessMessageAll = Maps.newHashMap();
                        List datas = (List)e.get("data");
                        for (Map pageData : datas) {
                            Map<String, Object> businessMessage = this.getBusinessMessage(taskCardFields, pageData);
                            this.mergeBusinessMessage(businessMessage, businessMessageAll);
                        }
                        updateBusinessMap.put(Long.valueOf(e.get("cardId").toString()), businessMessageAll);
                        break block5;
                    }
                    break block5;
                }
                TmTaskDefineResponseDTO taskDefineResponseDTO = (TmTaskDefineResponseDTO)e.get("define");
                Map pages = taskDefineResponseDTO.getPages();
                if (pages != null && (o = pages.get(TmPageName.PROJECT_CARD_NAME)) != null && CollectionUtils.isNotEmpty(dataStates = (tmActivityPageDTO = (TmActivityPageDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(o), TmActivityPageDTO.class)).getDataStates())) {
                    for (TmDataState dataState : dataStates) {
                        if (!"all".equals(dataState.getType())) continue;
                        TmTaskCardFields taskCardFields = dataState.getTaskCardFields();
                        HashMap businessMessageAll = Maps.newHashMap();
                        List datas = (List)e.get("data");
                        for (Map pageData : datas) {
                            Map<String, Object> businessMessage = this.getBusinessMessage(taskCardFields, pageData);
                            this.mergeBusinessMessage(businessMessage, businessMessageAll);
                        }
                        updateBusinessMap.put(Long.valueOf(e.get("cardId").toString()), businessMessageAll);
                        break;
                    }
                }
            }
        });
        return updateBusinessMap;
    }

    private void mergeBusinessMessage(Map<String, Object> source, Map<String, Object> target) {
        Set<String> targetKeySet = target.keySet();
        for (String targetKey : targetKeySet) {
            Set sourceSet = (Set)source.remove(targetKey);
            Set targetSet = (Set)target.get(targetKey);
            if (sourceSet == null) continue;
            targetSet.addAll(sourceSet);
        }
        if (source != null) {
            target.putAll(source);
        }
    }

    private Map<String, Object> getBusinessMessage(TmTaskCardFields tmTaskCardFields, Map<String, Object> data) {
        Map<String, List<Map<String, Object>>> taskCardField = tmTaskCardFields.getTaskCardField();
        HashMap businessMessage = Maps.newHashMap();
        HashMap<String, String> fieldPathNameMap = new HashMap<String, String>();
        for (Map.Entry<String, List<Map<String, Object>>> entry : taskCardField.entrySet()) {
            List<Map<String, Object>> value = entry.getValue();
            List abstractCardConfigList = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(value), TmTaskCardFields.AbstractCardConfig.class);
            for (TmTaskCardFields.AbstractCardConfig abstractCardConfig : abstractCardConfigList) {
                String aliasCode = abstractCardConfig.getCode();
                String fieldPath = abstractCardConfig.getValue();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)aliasCode) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fieldPath)) continue;
                String fieldName = org.apache.commons.lang3.StringUtils.substringAfter((String)fieldPath, (String)String.valueOf('.'));
                fieldPathNameMap.putIfAbsent(fieldPath + "__" + aliasCode, fieldName);
            }
        }
        for (Map.Entry<String, List<Map<String, Object>>> entry : fieldPathNameMap.entrySet()) {
            String fieldPath = entry.getKey();
            LinkedHashSet list = Sets.newLinkedHashSet();
            CommonUtils.addDepData(data, list, ((String)((Object)entry.getValue())).split("\\."), 0);
            for (Object value : list) {
                Set oldValueSet;
                Set valueList = null;
                if (value instanceof Collection) {
                    valueList = Sets.newLinkedHashSet((Iterable)((Collection)value));
                } else if (value != null) {
                    valueList = Sets.newHashSet((Object[])new String[]{String.valueOf(value)});
                }
                if (!CollUtil.isNotEmpty((Collection)(valueList = CollUtil.unionDistinct((Collection)(oldValueSet = (Set)businessMessage.get(fieldPath)), (Collection)valueList, (Collection[])new Collection[0])))) continue;
                businessMessage.put(fieldPath, valueList);
            }
        }
        return MapUtils.isEmpty((Map)businessMessage) ? null : businessMessage;
    }

    private List<Map<String, Object>> getBkConcatsData(RefreshCardInfosDTO refreshCardInfos) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        refreshCardInfos.getRefreshInfos().forEach(refreshInfo -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (TmPageName.TASK_CARD_NAME.getValue().equals(refreshCardInfos.getPagCode())) {
                map.put("type", "task");
                if (StringUtils.isNotEmpty((String)refreshInfo.getActivityId())) {
                    map.put("code", refreshInfo.getActivityId());
                    TmActivityResponseDTO activityDefine = this.themeMapService.getActivityAction("__uibot__", refreshInfo.getActivityId(), refreshCardInfos.getPagCode());
                    if (activityDefine != null) {
                        map.put("define", activityDefine);
                        if (ObjectUtils.isNotEmpty(activityDefine.getInputData())) {
                            map.put("bkConcats", this.getBkConcats(map, activityDefine.getInputData(), refreshInfo.getData()));
                        }
                    }
                }
            } else {
                map.put("type", "project");
                if (StringUtils.isNotEmpty((String)refreshInfo.getTaskId())) {
                    map.put("code", refreshInfo.getTaskId());
                    TmTaskDefineResponseDTO projectDefine = this.themeMapService.getTask(refreshInfo.getTaskId());
                    if (projectDefine != null) {
                        map.put("define", projectDefine);
                        if (ObjectUtils.isNotEmpty(projectDefine.getInputData())) {
                            map.put("bkConcats", this.getBkConcats(map, projectDefine.getInputData(), refreshInfo.getData()));
                        }
                    }
                }
            }
            maps.add(map);
        });
        return maps;
    }

    private List<Map<String, Object>> getUpdateCardData(List<Map<String, Object>> maps, RefreshCardInfosDTO refreshCardInfos) {
        ArrayList<Map<String, Object>> dataMaps = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty(maps)) {
            maps.forEach(map -> {
                List<Map<String, Object>> list = this.dataFootPrintService.queryByBk(refreshCardInfos.getTenantId(), JSON.parseObject((String)JsonUtils.objectToString((Object)map)));
                Map<String, List<Object>> collectObj = this.getActIdToData((Map)map, list);
                List<Map<String, String>> result = this.ptmService.queryBacklogIds(list.stream().map(e -> Long.valueOf(e.get("actId").toString())).distinct().collect(Collectors.toList()), map.get("type").toString(), map.get("code").toString());
                log.info("PTM\u8fd4\u56detype:{}, code:{}, \u5f85\u529eid\u96c6\u5408:{}", new Object[]{map.get("type"), map.get("code"), result});
                if (CollectionUtils.isNotEmpty(result)) {
                    result.forEach(res -> {
                        HashMap dataMap = new HashMap();
                        dataMap.put("define", map.get("define"));
                        dataMap.put("actId", ((String)res.get("actId")).toString());
                        dataMap.put("cardId", ((String)res.get("cardId")).toString());
                        dataMap.put("data", collectObj.get(((String)res.get("actId")).toString()));
                        dataMaps.add(dataMap);
                    });
                }
            });
        }
        return dataMaps;
    }

    private Map<String, List<Object>> getActIdToData(Map map, List<Map<String, Object>> list) {
        Map collect = list.parallelStream().collect(Collectors.groupingBy(e -> e.get("actId").toString(), Collectors.mapping(e -> e.get("bkConcat").toString(), Collectors.toList())));
        Map resultMap = (Map)map.get("bkToData");
        HashMap<String, List<Object>> collectObj = new HashMap<String, List<Object>>();
        collect.forEach((k, v) -> {
            ArrayList listData = new ArrayList();
            v.forEach(e -> ((List)resultMap.get(e)).forEach(data -> listData.add(data)));
            collectObj.put((String)k, listData);
        });
        return collectObj;
    }

    private List<String> getBkConcats(Map<String, Object> map, Map<String, Object> inputData, List<Map<String, Object>> datas) {
        ArrayList<String> uniKeys = new ArrayList<String>();
        List field = (List)inputData.get("field");
        for (Map fieldMap : field) {
            if (!fieldMap.containsKey("data_name")) continue;
            uniKeys.add(fieldMap.get("data_name").toString());
        }
        return RefreshCardMessageServiceImpl.getKeys(map, uniKeys, datas);
    }

    public static List<String> getKeys(Map<String, Object> map, List<String> pUniKeys, List<Map<String, Object>> datas) {
        log.info("\u9700\u8981\u66f4\u65b0\u7684\u4e1a\u52a1\u6570\u636e:{}", (Object)JsonUtils.objectToString(datas));
        ArrayList<String> keys = new ArrayList<String>();
        HashMap resultMap = new HashMap();
        for (Map<String, Object> tRow : datas) {
            List<Map<String, Object>> bkDatas;
            String key = BKUtils.getKey(pUniKeys, tRow);
            if (resultMap.containsKey(key)) {
                bkDatas = (List)resultMap.get(key);
                bkDatas.add(tRow);
                resultMap.put(key, bkDatas);
                continue;
            }
            bkDatas = new ArrayList();
            bkDatas.add(tRow);
            resultMap.put(key, bkDatas);
            keys.add(key);
        }
        map.put("bkToData", resultMap);
        return keys;
    }

    public void processTaskCard(List<Long> ids, CardTaskContext cardTaskContext, Set<String> processVariableKeys, CardJobData cardJobData) {
        if (CollectionUtils.isNotEmpty(ids)) {
            log.info("\u6267\u884c\u4efb\u52a1\u6570\u91cf:{}", (Object)ids.size());
            List<List<Long>> partitionSize = CommonUtils.spliceArrays(ids, cardTaskContext.getPartitionSize());
            for (List<Long> idList : partitionSize) {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
                for (Long id : idList) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("backlogId", id);
                    map.put("keys", processVariableKeys);
                    dataList.add(map);
                }
                Map<String, Object> editActions = this.backlogActionCreateService.getEditActions(cardTaskContext.getAuthoredUser(), dataList, false, true);
                if (MapUtils.isEmpty(editActions)) {
                    log.warn("\u83b7\u53d6ActivityData\u4e3a\u7a7a,\u4efb\u52a1id:{}", (Object)org.apache.commons.lang3.StringUtils.join(idList, (String)","));
                    return;
                }
                Map<String, Object> bkInfo = this.getBkInfo(cardTaskContext.getAuthoredUser(), cardJobData.getCode());
                if (bkInfo != null && CollectionUtils.isNotEmpty(processVariableKeys)) {
                    log.info("\u6dfb\u52a0\u5206\u6279\u5904\u7406\u4efb\u52a1:{}", (Object)ids.size());
                    CardDataParam cardDataParam = new CardDataParam(ids, editActions, cardJobData.getRefreshCardType(), bkInfo, TmPageName.TASK_CARD_NAME.getValue());
                    this.addTask(cardTaskContext, cardDataParam, true);
                    continue;
                }
                log.info("\u6dfb\u52a0\u5faa\u73af\u5904\u7406\u4efb\u52a1:{}", (Object)ids.size());
                List taskList = (List)editActions.remove("tasks");
                if (!CollectionUtils.isNotEmpty((Collection)taskList)) continue;
                HashMap idToTasksMap = Maps.newHashMapWithExpectedSize((int)ids.size());
                for (Map task : taskList) {
                    Long id = MapUtils.getLong((Map)task, (Object)"backlogId");
                    if (id == null) continue;
                    List list = idToTasksMap.computeIfAbsent(id, e -> new ArrayList());
                    list.add(task);
                }
                idToTasksMap.forEach((k, v) -> {
                    HashMap cloneData = Maps.newHashMapWithExpectedSize((int)editActions.size());
                    cloneData.putAll(editActions);
                    cloneData.put("tasks", v);
                    CardDataParam cardDataParam = new CardDataParam(Lists.newArrayList((Object[])new Long[]{k}), cloneData, cardJobData.getRefreshCardType(), null, TmPageName.TASK_CARD_NAME.getValue());
                    this.addTask(cardTaskContext, cardDataParam, false);
                });
            }
            return;
        }
        log.info("\u6839\u636ecode:{},\u5f85\u5904\u7406\u4efb\u52a1\u6570\u4e3a\u7a7a", (Object)cardJobData);
    }

    public void processTaskCard(CardTaskContext cardTaskContext, Set<String> processVariableKeys, CardJobData cardJobData) {
        String code = cardJobData.getCode();
        List<PtmTaskCardItemBO> ptmTaskList = this.ptmService.queryTaskCardListByCodes(Lists.newArrayList((Object[])new String[]{code}));
        if (CollectionUtils.isEmpty(ptmTaskList)) {
            log.info("\u67e5\u8be2code:{},\u5f85\u5904\u7406\u4efb\u52a1\u4e3a\u7a7a", (Object)code);
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        Map<String, Map<Long, Integer>> idErrorCount = cardTaskContext.getIdErrorCount();
        Map idErrorsMap = idErrorCount.getOrDefault(TmPageName.TASK_CARD_NAME.getValue(), new HashMap());
        for (PtmTaskCardItemBO cardItemDTO : ptmTaskList) {
            Integer num = idErrorsMap.getOrDefault(cardItemDTO.getBacklogId(), 0);
            if (num >= cardTaskContext.getMaxErrorSize()) continue;
            ids.add(cardItemDTO.getBacklogId());
        }
        this.processTaskCard(ids, cardTaskContext, processVariableKeys, cardJobData);
    }

    private void processProjectCard(CardTaskContext cardTaskContext, CardJobData cardJobData) {
        List<PtmProjectCardItemDTO> ptmList = this.ptmService.queryProjectCardListByCodes(Lists.newArrayList((Object[])new String[]{cardJobData.getCode()}));
        if (CollectionUtils.isEmpty(ptmList)) {
            log.info("\u6839\u636e:{},\u79df\u6237:{},\u6ca1\u6709\u67e5\u8be2\u5230\u5f85\u5904\u7406\u9879\u76ee\u5361", (Object)cardJobData.getCode(), (Object)cardTaskContext.getAuthoredUser().getTenantId());
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        Map<String, Map<Long, Integer>> idErrorCount = cardTaskContext.getIdErrorCount();
        Map idErrorsMap = idErrorCount.getOrDefault(TmPageName.PROJECT_CARD_NAME.getValue(), new HashMap());
        for (PtmProjectCardItemDTO ptmProjectCardItemDTO : ptmList) {
            Integer num = idErrorsMap.getOrDefault(ptmProjectCardItemDTO.getId(), 0);
            if (num >= cardTaskContext.getMaxErrorSize()) continue;
            ids.add(ptmProjectCardItemDTO.getId());
        }
        this.processProjectCard(ids, cardTaskContext, cardJobData);
    }

    private void processProjectCard(List<Long> ids, CardTaskContext cardTaskContext, CardJobData cardJobData) {
        if (ids.size() > 0) {
            log.info("\u9879\u76ee\u5361code:{},\u6267\u884c\u6570\u91cf:{}", (Object)cardJobData.getCode(), (Object)ids.size());
            List<List<Long>> partitionSize = CommonUtils.spliceArrays(ids, cardTaskContext.getPartitionSize());
            for (List<Long> idList : partitionSize) {
                for (Long id : idList) {
                    Map activityData = this.commonProjectHandleService.getProjectActivityData(id);
                    if (activityData == null) continue;
                    CardDataParam cardDataParam = new CardDataParam(Lists.newArrayList((Object[])new Long[]{id}), activityData, cardJobData.getRefreshCardType(), null, TmPageName.PROJECT_CARD_NAME.getValue());
                    this.addTask(cardTaskContext, cardDataParam, false);
                }
            }
        }
    }

    private Map<String, Object> getBkInfo(AuthoredUser authoredUser, String code) {
        JSONArray tmTaskAndActivityBk = this.themeMapService.getTmTaskAndActivityBk("activity", code, authoredUser);
        if (CollectionUtils.isNotEmpty((Collection)tmTaskAndActivityBk)) {
            JSONArray bks = ((JSONObject)tmTaskAndActivityBk.get(0)).getJSONArray("bk");
            JSONObject bk = (JSONObject)bks.get(0);
            JSONArray bkFields = bk.getJSONArray("field");
            if (CollectionUtils.isEmpty((Collection)bkFields)) {
                return null;
            }
            HashMap<String, Object> bkInfo = new HashMap<String, Object>();
            bkInfo.put("dataName", bk.getString("dataName"));
            ArrayList fields = Lists.newArrayListWithCapacity((int)bkFields.size());
            for (Object bkField : bkFields) {
                JSONObject json = (JSONObject)bkField;
                fields.add(json.getString("dataName"));
            }
            bkInfo.put("dataName", bk.getString("dataName"));
            bkInfo.put("fields", fields);
            return bkInfo;
        }
        return null;
    }

    private boolean executeTask(CardDataParam cardDataParam, List<CardDataParam> taskData, int maxSize) {
        return taskData != null && (cardDataParam == null || taskData.size() >= maxSize);
    }

    private boolean checkExists(String refreshCardType, TmActivityPageDTO page) {
        List<TmDataState> dataStates = page.getDataStates();
        if ("summary".equals(refreshCardType)) {
            if (CollectionUtils.isEmpty(dataStates)) {
                return CollectionUtils.isNotEmpty(page.getSummaryFields());
            }
            boolean flag = false;
            for (TmDataState dataState : dataStates) {
                if ("all".equals(dataState.getType())) continue;
                flag = CollectionUtils.isNotEmpty(dataState.getSummaryFields());
                break;
            }
            return flag;
        }
        boolean flag = false;
        if (CollectionUtils.isNotEmpty(dataStates)) {
            for (TmDataState dataState : dataStates) {
                if (!"all".equals(dataState.getType())) continue;
                TmTaskCardFields taskCardFields = dataState.getTaskCardFields();
                flag = taskCardFields != null && MapUtils.isNotEmpty(taskCardFields.getTaskCardField());
                break;
            }
        }
        return flag;
    }

    private void setDataSourceNames(List<String> dataSourceNames, String refreshCardType, List<TmDataState> dataStates) {
        TmDataFilter dataFilter;
        TmDataState tmDataState;
        boolean summary = "summary".equals(refreshCardType);
        if (CollectionUtils.isEmpty(dataStates)) {
            return;
        }
        Optional<TmDataState> first = dataStates.stream().filter(e -> summary != "all".equals(e.getType())).findFirst();
        if (first.isPresent() && this.checkExists(summary, tmDataState = first.get()) && (dataFilter = tmDataState.getDataFilter()) != null) {
            if (summary) {
                List<String> sourceNames = dataFilter.getDataSourceNames();
                if (CollectionUtils.isNotEmpty(sourceNames)) {
                    dataSourceNames.addAll(sourceNames);
                }
                return;
            }
            TmTaskCardFields taskCardFields = tmDataState.getTaskCardFields();
            String dateSourceName = taskCardFields.getDateSourceName();
            if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dateSourceName})) {
                dataSourceNames.add(dateSourceName);
            }
        }
    }

    private Set<String> getProcessVariableKeys(String code) {
        TmActivityResponseDTO activityAction = this.themeMapService.getActivityAction(null, code, "task-card");
        ArrayList dataSourceNames = Lists.newArrayListWithExpectedSize((int)3);
        for (String cardType : REFRESH_CARD_TYPES) {
            this.setDataSourceNames(dataSourceNames, cardType, activityAction.getPages().getDataStates());
        }
        return this.getProcessVariableKeys(dataSourceNames, activityAction.getDataSources());
    }

    private Set<String> getProcessVariableKeys(List<String> dataSourceNames, Map<String, TmActionDTO> dataSources) {
        HashSet keys = Sets.newHashSet();
        dataSources.forEach((k, v) -> {
            List<TmActionParameterDTO> actionParams;
            if (dataSourceNames.contains(k) && CollectionUtils.isNotEmpty(actionParams = v.getActionParams())) {
                for (TmActionParameterDTO actionParam : actionParams) {
                    if (!"PROCESS_VARIABLE".equals(actionParam.getType())) continue;
                    String value = actionParam.getValue();
                    String[] split = value.split("\\.");
                    keys.add(split[0]);
                }
            }
        });
        return keys;
    }

    private boolean checkExists(boolean summary, TmDataState tmDataState) {
        if (summary) {
            return CollectionUtils.isNotEmpty(tmDataState.getSummaryFields());
        }
        TmTaskCardFields taskCardFields = tmDataState.getTaskCardFields();
        return taskCardFields != null && MapUtils.isNotEmpty(taskCardFields.getTaskCardField());
    }

    public void addTask(CardTaskContext cardTaskContext, CardDataParam cardDataParam, boolean isBatch) {
        if (cardDataParam != null) {
            cardTaskContext.addTask(cardDataParam, isBatch);
        }
        this.runTask(cardTaskContext, cardDataParam);
    }

    public void triggerTask(CardTaskContext cardTaskContext) {
        this.runTask(cardTaskContext, null);
    }

    public void runTask(CardTaskContext cardTaskContext, CardDataParam cardDataParam) {
        int singleTaskSize = cardTaskContext.getSingleTaskSize();
        if (this.executeTask(cardDataParam, cardTaskContext.getSingleTasks(), singleTaskSize)) {
            this.runTask(cardTaskContext, cardTaskContext.getSingleTasks(), singleTaskSize, cardDataParam != null, false);
        }
        int batchTaskSize = cardTaskContext.getBatchTaskSize();
        if (this.executeTask(cardDataParam, cardTaskContext.getBatchTasks(), batchTaskSize)) {
            this.runTask(cardTaskContext, cardTaskContext.getBatchTasks(), batchTaskSize, cardDataParam != null, true);
        }
    }

    private void runSingleTask(CardTaskContext cardTaskContext, CardDataParam dataParam, List<TaskWorkitemMessage> updateSummaryList) {
        Map<String, Object> activityData = dataParam.getActivityData();
        List taskList = (List)activityData.get("tasks");
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            return;
        }
        Map first = (Map)taskList.get(0);
        List<Long> ids = dataParam.getIds();
        for (Long id : ids) {
            BacklogBO backlogBO = this.commonPtmTransformService.selectBacklogForCard(id);
            backlogBO.setTmTaskId(MapUtils.getString((Map)first, (Object)"tmTaskId"));
            backlogBO.setTmActivityId(MapUtils.getString((Map)first, (Object)"tmActivityId"));
            CardInfoDto cardInfoDto = this.commonBacklogAbstractService.getSummaryWorkItemLayout(id, backlogBO, activityData, cardTaskContext.getAuthoredUser(), new CardAbstractDTO().setCardId(id).setNeedHistoryInfo(false).setNeedBusinessMessage(true).setBusinessMessageSourceType("api"));
            Map<String, Object> cardInfo = cardInfoDto.getCardInfo();
            if (cardInfo == null) continue;
            String activityMessage = CommonUtils.getActivityMessageStr(cardInfoDto);
            TaskWorkitemMessage taskWorkitemMessage = TaskWorkitemMessage.builder().cardId(id).activityMessage(activityMessage).summary(MapUtils.getString(cardInfo, (Object)"summaryLayout", (String)"")).historyMessage(MapUtils.getString(cardInfo, (Object)"historyMessage", (String)"")).searchMessage(MapUtils.getString(cardInfo, (Object)"searchMessage", (String)"")).build();
            updateSummaryList.add(taskWorkitemMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(CardTaskContext cardTaskContext, List<CardDataParam> taskData, int size, boolean sleep, boolean isBatch) {
        if (CollectionUtils.isEmpty(taskData)) {
            return;
        }
        log.info("\u4efb\u52a1\u5f00\u59cb\u6267\u884c\u6570\u91cf:{}", (Object)taskData.size());
        String tenantId = cardTaskContext.getAuthoredUser().getTenantId();
        ArrayList updateSummaryList = Lists.newArrayListWithCapacity((int)size);
        HashMap updateBusinessMap = Maps.newHashMapWithExpectedSize((int)size);
        StopWatch watch = new StopWatch("TASK-TIME");
        watch.start();
        Map<String, List<CardDataParam>> collect = taskData.stream().collect(Collectors.groupingBy(CardDataParam::getPageCode));
        try {
            collect.forEach((pageCode, v) -> {
                boolean isTaskSingle = TmPageName.TASK_CARD_NAME.getValue().equals(pageCode) && !isBatch;
                for (CardDataParam dataParam : v) {
                    if (isTaskSingle) {
                        this.runSingleTask(cardTaskContext, dataParam, updateSummaryList);
                        continue;
                    }
                    Map<String, Object> activityData = dataParam.getActivityData();
                    List taskList = (List)activityData.get("tasks");
                    if (CollectionUtils.isEmpty((Collection)taskList)) continue;
                    Map first = (Map)taskList.get(0);
                    try {
                        BaseResultDTO<Map<String, Map<Long, Map<Long, Map<String, Object>>>>> batchCardBusinessMessage = this.aglieService.getBatchCardBusinessMessage(MapUtils.getString((Map)first, (Object)"tmTaskId"), MapUtils.getString((Map)first, (Object)"tmActivityId"), dataParam);
                        Map response = (Map)batchCardBusinessMessage.getResponse();
                        if (!MapUtils.isNotEmpty((Map)response)) continue;
                        Map summaryMap = (Map)response.get("summary");
                        Map businessMap = (Map)response.get("business");
                        HashMap cacheCode = Maps.newHashMap();
                        if (summaryMap != null) {
                            summaryMap.forEach((id, activityIdToSummary) -> {
                                String reApprovalComment = this.commonBacklogAbstractService.getReApprovalComment((Long)id, cacheCode);
                                ArrayList cardItemList = Lists.newArrayList();
                                HashMap summaryData = Maps.newHashMapWithExpectedSize((int)3);
                                activityIdToSummary.forEach((activityId, rowData) -> {
                                    String summaryLayout = MapUtils.getString((Map)rowData, (Object)"summaryLayoutStr", (String)"");
                                    if (StringUtils.isNotBlank((String)reApprovalComment)) {
                                        summaryLayout = StringUtils.isNotBlank((String)summaryLayout) ? reApprovalComment + "<br>" + summaryLayout : reApprovalComment;
                                    }
                                    rowData.put("summaryLayout", summaryLayout);
                                    summaryData.put("summaryLayoutStr", this.commonBacklogAbstractService.mergeMessage((String)summaryData.get("summaryLayoutStr"), summaryLayout));
                                    summaryData.put("historyMessage", this.commonBacklogAbstractService.mergeMessage((String)summaryData.get("historyMessage"), MapUtils.getString((Map)rowData, (Object)"historyMessage", (String)"")));
                                    summaryData.put("searchMessage", this.commonBacklogAbstractService.mergeMessage((String)summaryData.get("searchMessage"), MapUtils.getString((Map)rowData, (Object)"searchMessage", (String)"")));
                                    if (activityId != -1L) {
                                        cardItemList.add(new CardItemDto((Long)activityId, (Map<String, Object>)rowData));
                                    }
                                });
                                CardInfoDto cardInfoDto = new CardInfoDto();
                                cardInfoDto.setCardItemList(cardItemList);
                                String activityMessage = CommonUtils.getActivityMessageStr(cardInfoDto);
                                TaskWorkitemMessage taskWorkitemMessage = TaskWorkitemMessage.builder().cardId(id).activityMessage(activityMessage).summary(MapUtils.getString((Map)summaryData, (Object)"summaryLayoutStr", (String)"")).historyMessage(MapUtils.getString((Map)summaryData, (Object)"historyMessage", (String)"")).searchMessage(MapUtils.getString((Map)summaryData, (Object)"searchMessage", (String)"")).build();
                                taskWorkitemMessage.setModifyDate(LocalDateTime.now());
                                updateSummaryList.add(taskWorkitemMessage);
                            });
                        }
                        if (businessMap == null) continue;
                        Collection values = businessMap.values();
                        for (Map value : values) {
                            updateBusinessMap.putAll(value);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u8c03\u7528\u83b7\u53d6\u5361\u7247\u4fe1\u606f\u9519\u8bef:{}", (Object)e.getMessage(), (Object)e);
                        cardTaskContext.recordIdError((String)pageCode, dataParam.getIds());
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)updateSummaryList)) {
                    this.taskWorkItemMessageMapper.batchUpdate(updateSummaryList);
                    log.info("\u6458\u8981\u66f4\u65b0,\u6570\u91cf:{}", (Object)updateSummaryList.size());
                }
                this.backlogAbstractUtil.saveOrUpdateBusinessMessageInner(tenantId, (String)pageCode, updateBusinessMap);
            });
        }
        finally {
            watch.stop();
            log.info("\u4efb\u52a1\u7ed3\u675f,\u8017\u65f6:{}", (Object)watch.getTotalTimeSeconds());
            taskData.clear();
        }
        if (sleep) {
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                log.info("\u7ebf\u7a0b\u4e2d\u65ad:{}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void settingSize(Integer size) {
        this.redisTemplate.opsForValue().set((Object)"abt:refresh_card_partition_size", (Object)String.valueOf(size));
    }

    @Override
    public Boolean createOrUpdateCardJob(CardJob cardJob) {
        try {
            JobKey jobKey = new JobKey("refresh_card_job", "refresh_card_job");
            if (this.scheduler.checkExists(jobKey)) {
                JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                Set cardData = (Set)jobDataMap.get((Object)"data");
                CardJobData cardJobData = new CardJobData();
                BeanUtils.copyProperties((Object)cardJob, (Object)cardJobData);
                cardData.remove(cardJobData);
                if (cardJob.isEnable()) {
                    cardData.add(cardJobData);
                }
                this.scheduler.addJob(jobDetail, true);
                String corn = cardJob.getCorn();
                if (StringUtils.isNotBlank((String)corn)) {
                    CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(TriggerKey.triggerKey((String)"refresh_card_job", (String)"refresh_card_job"));
                    trigger = (CronTrigger)trigger.getTriggerBuilder().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)corn)).build();
                    this.scheduler.rescheduleJob(trigger.getKey(), (Trigger)trigger);
                }
                return false;
            }
            if (cardJob.isEnable()) {
                JobDataMap jobDataMap = new JobDataMap();
                HashSet<CardJobData> data = new HashSet<CardJobData>();
                CardJobData cardJobData = new CardJobData();
                BeanUtils.copyProperties((Object)cardJob, (Object)cardJobData);
                data.add(cardJobData);
                jobDataMap.put("data", data);
                jobDataMap.put("singleTaskSize", 50);
                jobDataMap.put("batchTaskSize", 30);
                jobDataMap.put("partition_size", 100);
                jobDataMap.put("max_error_size", 20);
                JobDetail jobDetail = JobBuilder.newJob(RefreshCardJob.class).withIdentity("refresh_card_job", "refresh_card_job").usingJobData(jobDataMap).withDescription("\u5237\u65b0\u5361\u7247\u5b9a\u65f6\u4efb\u52a1").storeDurably().build();
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("refresh_card_job", "refresh_card_job").startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)StringUtils.defaultString((String)cardJob.getCorn(), (String)"0 16 * * * ?"))).build();
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                return true;
            }
        }
        catch (SchedulerException e) {
            log.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
        }
        return false;
    }
}

