/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.summary.executor;

import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardInfoDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRecordDTO;
import com.digiwin.athena.abt.application.service.abt.migration.summary.executor.AbstractRefreshCardMessageExecutor;
import com.digiwin.athena.abt.application.utils.AppAuthContextUtils;
import com.digiwin.athena.abt.core.meta.enums.CardTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.Map;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RefreshProjectCardMessageExecutor
extends AbstractRefreshCardMessageExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshProjectCardMessageExecutor.class);

    @Override
    public int cardType() {
        return CardTypeEnum.PROJECT_CARD.getType();
    }

    @Override
    public void execute(RefreshCardMessageDTO refreshCardMessage) {
        JSONObject apiResult = this.tenantService.queryApiVirtualToken(refreshCardMessage.getTenantId());
        if (apiResult.isEmpty() || !apiResult.containsKey((Object)"token")) {
            return;
        }
        String virtualToken = apiResult.getString("token");
        AuthoredUser authoredUser = AppAuthContextUtils.setAuthoredUserContext(virtualToken);
        PtmProjectCardRecordDTO projectCardRecord = this.ptmService.getProjectCardRecord(refreshCardMessage.getId());
        String jobName = String.valueOf(refreshCardMessage.getId());
        String jobGroupName = "REFRESH_TASK_MESSAGE_GROUP";
        if (null == projectCardRecord || null != projectCardRecord.getState() && projectCardRecord.getState() >= 3) {
            log.warn("project card not exist or closed, will delete refresh card message job:{}.{}", (Object)jobName, (Object)jobGroupName);
            this.jobManager.deleteJob(jobName, jobGroupName);
            return;
        }
        this.refreshProjectCardMessage(authoredUser, refreshCardMessage.getRefreshCardType(), refreshCardMessage.getId());
    }

    private void refreshProjectCardMessage(AuthoredUser authoredUser, String refreshCardType, Long projectCardId) {
        if ("business".equals(refreshCardType)) {
            this.commonProjectHandleService.saveProjectCardData(projectCardId);
            return;
        }
        Map projectCardSelfAbstract = this.commonProjectHandleService.getProjectCardSelfAbstract(authoredUser, projectCardId, new CardAbstractDTO().setNeedHistoryInfo(true).setNeedBusinessMessage(true).setBusinessMessageSourceType("api"));
        if (null == projectCardSelfAbstract) {
            log.warn("query project card massage is null, job:{}.{}", (Object)projectCardId, (Object)"REFRESH_TASK_MESSAGE_GROUP");
            return;
        }
        CardInfoDto cardInfoDto = new CardInfoDto();
        cardInfoDto.setCardInfo(projectCardSelfAbstract);
        this.updateCardMessage(projectCardId, cardInfoDto);
    }
}

