/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.summary.executor;

import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogRecordDTO;
import com.digiwin.athena.abt.application.service.abt.migration.summary.executor.AbstractRefreshCardMessageExecutor;
import com.digiwin.athena.abt.application.utils.AppAuthContextUtils;
import com.digiwin.athena.abt.core.meta.enums.CardTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Map;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RefreshTaskCardMessageExecutor
extends AbstractRefreshCardMessageExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshTaskCardMessageExecutor.class);

    @Override
    public int cardType() {
        return CardTypeEnum.TASK_CARD.getType();
    }

    @Override
    public void execute(RefreshCardMessageDTO refreshCardMessage) {
        log.info("task run data:{}", (Object)JsonUtils.objectToString((Object)refreshCardMessage));
        JSONObject apiResult = this.tenantService.queryApiVirtualToken(refreshCardMessage.getTenantId());
        if (apiResult.isEmpty() || !apiResult.containsKey((Object)"token")) {
            return;
        }
        String virtualToken = apiResult.getString("token");
        AuthoredUser authoredUser = AppAuthContextUtils.setAuthoredUserContext(virtualToken);
        authoredUser.setTenantId(apiResult.getString("tenantId"));
        PtmBacklogRecordDTO backlogRecord = this.ptmService.getBacklogRecord(refreshCardMessage.getId());
        String jobName = String.valueOf(refreshCardMessage.getId());
        String jobGroupName = "REFRESH_TASK_MESSAGE_GROUP";
        if (null == backlogRecord || BooleanUtils.isTrue((Boolean)backlogRecord.getClosed())) {
            log.warn("task card not exist or closed, will delete refresh card message job:{}.{}", (Object)jobName, (Object)jobGroupName);
            this.jobManager.deleteJob(jobName, jobGroupName);
            return;
        }
        this.refreshTaskCardMessage(authoredUser, refreshCardMessage);
    }

    private void refreshTaskCardMessage(AuthoredUser authoredUser, RefreshCardMessageDTO refreshCardMessage) {
        long taskCardId = refreshCardMessage.getId();
        if ("business".equals(refreshCardMessage.getRefreshCardType())) {
            log.info("\u6267\u884c\u5237\u65b0\u4e1a\u52a1\u5b57\u6bb5:{}", (Object)refreshCardMessage.getId());
            CardAbstractDTO cardAbstractDTO = new CardAbstractDTO().setCardId(taskCardId).setNeedHistoryInfo(false).setNeedBusinessMessage(true).setBusinessMessageSourceType("api");
            this.backlogAbstractService.saveTaskSaveBusinessMessage(authoredUser, cardAbstractDTO);
            return;
        }
        Map backlogDTO = this.backlogAbstractService.getBacklogCardAbstractById(taskCardId, authoredUser, new CardAbstractDTO().setCardId(taskCardId).setNeedHistoryInfo(false).setNeedBusinessMessage(true).setBusinessMessageSourceType("api"), null);
        if (null == backlogDTO) {
            log.warn("query task card massage is null, job:{}.{}", (Object)taskCardId, (Object)"REFRESH_TASK_MESSAGE_GROUP");
            return;
        }
        this.updateCardMessage(taskCardId, this.backlogAbstractService.getSummaryWorkItemLayout(taskCardId, authoredUser, new CardAbstractDTO().setCardId(taskCardId).setNeedHistoryInfo(false).setNeedBusinessMessage(true).setBusinessMessageSourceType("api")));
    }
}

