/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.worker;

import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class DataEntryTaskFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEntryTaskFactory.class);
    private final int DEFAULT_BATCH_SIZE = 300;

    public List<DataEntryTask> produce(String actionId, AuthoredUser athenaUser, String tableKey, String masterId, List<String> keyList, List<List<Object>> data, String topic, String appToken) {
        List batches = Lists.partition(data, (int)300);
        LinkedList<DataEntryTask> dataEntryTasks = new LinkedList<DataEntryTask>();
        AtomicInteger i = new AtomicInteger();
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        batches.forEach(item -> {
            DataEntryTask dataEntryTask = new DataEntryTask();
            String locale = LocaleContextHolder.getLocale().toString();
            dataEntryTask.setLocale(locale == null ? "zh_CN" : locale);
            dataEntryTask.setKeyList(keyList);
            dataEntryTask.setMasterId(masterId);
            dataEntryTask.setActionId(actionId);
            dataEntryTask.setUserToken(securityToken);
            dataEntryTask.setTenantId(athenaUser.getTenantId());
            dataEntryTask.setTableKey(tableKey);
            dataEntryTask.setTopic(topic);
            dataEntryTask.setData((List<List<Object>>)item);
            dataEntryTask.setBatchNum(i.getAndIncrement());
            dataEntryTasks.add(dataEntryTask);
        });
        return dataEntryTasks;
    }

    public List<DataEntryTask> produceNew(UploadParamDTO uploadParam, String tableKey, List<String> keyList, List<Map> data) {
        List batches = Lists.partition(data, (int)300);
        LinkedList<DataEntryTask> dataEntryTasks = new LinkedList<DataEntryTask>();
        AtomicInteger i = new AtomicInteger();
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        if (securityToken == null) {
            securityToken = uploadParam.getSecurityToken();
        }
        String finalSecurityToken = securityToken;
        batches.forEach(item -> {
            DataEntryTask dataEntryTask = new DataEntryTask();
            String locale = LocaleContextHolder.getLocale().toString();
            dataEntryTask.setLocale(locale == null ? "zh_CN" : locale);
            dataEntryTask.setKeyList(keyList);
            dataEntryTask.setMasterId(uploadParam.getMasterId());
            dataEntryTask.setActionId(uploadParam.getActionId());
            dataEntryTask.setUserToken(finalSecurityToken);
            dataEntryTask.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser() == null ? uploadParam.getAuthoredUser().getTenantId() : AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            dataEntryTask.setTableKey(tableKey);
            dataEntryTask.setTopic(DirectRabbitConfig.QUEUE_NAME);
            dataEntryTask.setDataList((List<Map>)item);
            dataEntryTask.setBatchNum(i.getAndIncrement());
            dataEntryTask.setActionInfo(uploadParam.getActionInfo());
            dataEntryTask.setApplication(uploadParam.getApplication());
            dataEntryTask.setActivityId(uploadParam.getActivityId());
            dataEntryTask.setFileUrl(uploadParam.getFileUrl());
            dataEntryTask.setType("0");
            dataEntryTasks.add(dataEntryTask);
        });
        return dataEntryTasks;
    }
}

