/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.atdm.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.action.SubmitExecuteContext;
import com.digiwin.athena.abt.application.service.atmc.migration.atdm.AtdmService;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResult;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResultSet;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class AtdmServiceImpl
implements AtdmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtdmServiceImpl.class);
    public static final String WITH_META_DATA = "api/atdm/v1/data/query/by/backlog/withmetadata";
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;

    @Override
    public QueryResultSet getResultSet(Map map, AuthoredUser authoredUser) {
        Map executeContext = (Map)map.get("executeContext");
        String actionId = null;
        String tmActivityId = executeContext.get("tmActivityId").toString();
        Long backlogId = Long.parseLong(executeContext.get("backlogId").toString());
        Map taskWithBacklogData = (Map)executeContext.get("taskWithBacklogData");
        String processSerialNumber = taskWithBacklogData.get("processSerialNumber").toString();
        Map dataSourceSet = (Map)map.get("dataSourceSet");
        List dataSourceList = (List)dataSourceSet.get("dataSourceList");
        if (!dataSourceList.isEmpty()) {
            actionId = ((Map)dataSourceList.get(0)).get("actionId").toString();
        }
        String application = Objects.nonNull(executeContext.get("application")) ? executeContext.get("application").toString() : null;
        SubmitExecuteContext submitExecuteContext = new SubmitExecuteContext();
        submitExecuteContext.setAuthoredUser(authoredUser);
        submitExecuteContext.setTmActivityId(tmActivityId);
        submitExecuteContext.setBacklogId(backlogId);
        submitExecuteContext.setProcessSerialNumber(processSerialNumber);
        submitExecuteContext.setApplication(application);
        String url = this.getAtdmUri() + WITH_META_DATA;
        url = AtdmServiceImpl.appendTraceInfo(url, submitExecuteContext, actionId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HashMap body = new HashMap();
        body.put("dataSourceSetDTO", map.get("dataSourceSet"));
        body.put("executeContext", map.get("executeContext"));
        body.put("parameter", map.get("parameter"));
        body.put("dataViewQuery", null);
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        ResponseEntity apiResultDTO = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<QueryResultSet>>(){}, new Object[0]);
        QueryResultSet queryResultSet = (QueryResultSet)((BaseResultDTO)apiResultDTO.getBody()).getResponseWithException("");
        Map<String, List<QueryResult>> group = queryResultSet.getQueryResults().stream().collect(Collectors.groupingBy(QueryResult::getDataSourceName));
        for (Map.Entry<String, List<QueryResult>> groupItem : group.entrySet()) {
            List<QueryResult> resultList;
            if ("".equals(groupItem.getKey()) || (resultList = groupItem.getValue()).size() <= 1) continue;
            QueryResult qr = resultList.get(0);
            for (int i = 1; i < resultList.size(); ++i) {
                qr.getData().addAll(resultList.get(i).getData());
                qr.getDataKeyIndex().putAll(resultList.get(i).getDataKeyIndex());
                if (CollectionUtils.isEmpty((Collection)qr.getDataKeys()) && CollectionUtils.isNotEmpty((Collection)resultList.get(i).getDataKeys())) {
                    qr.setDataKeys(resultList.get(i).getDataKeys());
                }
                queryResultSet.getQueryResults().remove(resultList.get(i));
            }
        }
        return queryResultSet;
    }

    private String getAtdmUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getAtdmUri();
    }

    static String appendTraceInfo(String url, SubmitExecuteContext executeContext, String actionId) {
        if (StringUtils.isEmpty((Object)url)) {
            return url;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (executeContext != null) {
            if (executeContext.getTmActivityId() != null) {
                stringBuilder.append(String.format("&TmActivityId=%s", executeContext.getTmActivityId()));
            }
            if (executeContext.getBacklogId() != null) {
                stringBuilder.append(String.format("&BacklogId=%s", executeContext.getBacklogId()));
            }
            if (executeContext.getAuthoredUser() != null) {
                stringBuilder.append(String.format("&author=%s-%s", executeContext.getAuthoredUser().getTenantId(), executeContext.getAuthoredUser().getUserId()));
            }
            if (executeContext.getProcessSerialNumber() != null) {
                stringBuilder.append(String.format("&processSerialNumber=%s", executeContext.getProcessSerialNumber()));
            }
        }
        if (actionId != null) {
            stringBuilder.append(String.format("&actionId=%s", actionId));
        }
        if (stringBuilder.length() > 0) {
            if (url.contains("?")) {
                return url + stringBuilder.substring(1);
            }
            return url + "?" + stringBuilder.substring(1);
        }
        return url;
    }
}

