/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.backlog;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.PageUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.BacklogCardField;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardConfigDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.TaskCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.service.atmc.migration.atdm.AtdmService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.BacklogActionCreateService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.TodoBacklogQueryService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.AglieService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.BacklogAbstractUtil;
import com.digiwin.athena.abt.core.concurrent.pool.DynamicThreadPool;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.BacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.CardColumn;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResultSet;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskDefCodeData;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.concurrent.JaRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class BacklogBatchQueryBusinessDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BacklogBatchQueryBusinessDataService.class);
    @Autowired
    private AtmcService atmcService;
    @Autowired
    private ThemeMapService themeMapService;
    @Resource
    private BacklogAbstractUtil backlogAbstractUtil;
    @Resource
    private TodoBacklogQueryService backlogCardQueryService;
    @Autowired
    private BacklogActionCreateService backlogActionCreateService;
    @Autowired
    private AglieService aglieService;
    @Autowired
    private AtdmService atdmService;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private DynamicThreadPool taskExecutor;
    public static final String CARD_BUSINESS_MESSAGE = "cardBusinessMessage";
    public static final String NON_REAL_TIME = "NON_REAL_TIME";
    public static final String PARTITION_SIZE = "abt.dataField.partitionSize";

    public void setBusinessMessageForProject(List<ProjectCardDTO> cardList, AuthoredUser user, String pageCode) {
        if (!this.atmcService.verifyConfig(CARD_BUSINESS_MESSAGE, CARD_BUSINESS_MESSAGE).booleanValue()) {
            return;
        }
        List nonRealTimeCardList = cardList.stream().filter(card -> NON_REAL_TIME.equals(card.getBusinessMessageSourceMethod())).collect(Collectors.toList());
        int pageSize = 10;
        int totalPage = PageUtil.totalPage((int)nonRealTimeCardList.size(), (int)pageSize);
        for (int i = 0; i < totalPage; ++i) {
            List cardListSub = CollUtil.sub(nonRealTimeCardList, (int)(i * pageSize), (int)((i + 1) * pageSize));
            List<Long> backlogIdList = cardListSub.stream().map(ProjectCardDTO::getId).collect(Collectors.toList());
            Map<Long, Map<String, List<String>>> batchBusinessMessage = this.backlogAbstractUtil.getAndBuildBusinessMessage(backlogIdList, pageCode, user.getTenantId());
            cardListSub.forEach(card -> card.setBusinessMessage((Map)batchBusinessMessage.get(card.getId())));
        }
    }

    public Map<Long, Object> addDataFieldsByBacklogId(Long backlogId, String tmActivityId, AuthoredUser user) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km rule process time");
        Map<String, Object> taskCardOptimizeRules = this.themeMapService.getTaskCardOptimizeRules();
        stopWatch.stop();
        log.info(" process time get km rule data :{}", (Object)stopWatch.prettyPrint());
        List<TaskDefCodeData> groupRuleList = this.getGroupRuleList(taskCardOptimizeRules);
        List<String> taskCodeList = groupRuleList.stream().map(TaskDefCodeData::getTaskCode).collect(Collectors.toList());
        List labelRuleList = (List)taskCardOptimizeRules.get("labelRule");
        List<CardColumn> columnRuleList = this.getColumnRuleList(taskCardOptimizeRules);
        labelRuleList.forEach(e -> taskCodeList.add(e.get("taskCode").toString()));
        List<Map> orderRuleList = this.getOrderRuleList(taskCardOptimizeRules);
        columnRuleList.forEach(e -> taskCodeList.add(e.getTaskCode()));
        Map<String, Object> orderMap = orderRuleList.stream().collect(Collectors.toMap(e -> e.get("taskCode").toString(), a -> a, (k1, k2) -> k1));
        ArrayList<TaskCardDTO> backlogIds = new ArrayList<TaskCardDTO>();
        TaskCardDTO taskCardDTO = new TaskCardDTO();
        taskCardDTO.setBacklogId(backlogId);
        taskCardDTO.setTmActivityId(tmActivityId);
        backlogIds.add(taskCardDTO);
        Map<Long, Object> dataFieldMap = this.getSingleDataFieldMap(backlogIds, user, taskCodeList, groupRuleList, labelRuleList, columnRuleList);
        HashMap<String, Map<String, Integer>> businessDataMap = (HashMap<String, Map<String, Integer>>)dataFieldMap.get(backlogId);
        if (businessDataMap == null) {
            businessDataMap = new HashMap<String, Map<String, Integer>>();
        }
        businessDataMap.put("order", this.generateOrder(tmActivityId, orderMap));
        HashMap<Long, Object> result = new HashMap<Long, Object>();
        result.put(backlogId, businessDataMap);
        return result;
    }

    private List<TaskDefCodeData> getGroupRuleList(Map<String, Object> map) {
        Object groupRule = map.get("groupRule");
        JSONObject groupRuleJson = JSONUtil.parseObj((Object)groupRule);
        Object groupType = groupRuleJson.get((Object)"groupType");
        JSONObject groupTypeJson = JSONUtil.parseObj((Object)groupType);
        cn.hutool.json.JSONArray jsonArray = JSONUtil.parseArray((Object)groupTypeJson.get((Object)"businessKey"));
        return JSONUtil.toList((cn.hutool.json.JSONArray)jsonArray, TaskDefCodeData.class);
    }

    private List<CardColumn> getColumnRuleList(Map<String, Object> map) {
        Object groupRule = map.get("columnRule");
        cn.hutool.json.JSONArray columnArray = JSONUtil.parseArray((Object)groupRule);
        return JSONUtil.toList((cn.hutool.json.JSONArray)columnArray, CardColumn.class);
    }

    private List<Map> getOrderRuleList(Map<String, Object> map) {
        Object orderRule = map.get("orderRule");
        cn.hutool.json.JSONArray orderRuleArray = JSONUtil.parseArray((Object)orderRule);
        return JSONUtil.toList((cn.hutool.json.JSONArray)orderRuleArray, Map.class);
    }

    private Map<String, Integer> generateOrder(String tmActivityId, Map<String, Object> orderMap) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Map orderData = (Map)orderMap.get(tmActivityId);
        map.put("taskOrderWeight", orderData == null ? 9999 : Integer.parseInt(orderData.get("orderWeight").toString()));
        return map;
    }

    private Map<Long, Object> getSingleDataFieldMap(List<TaskCardDTO> list, AuthoredUser user, List<String> taskCodeList, List<TaskDefCodeData> groupRuleList, List<Map<String, Object>> labelRuleList, List<CardColumn> columnRuleList) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km definition process time");
        Map<String, List<String>> activityDefinitionMap = this.themeMapService.getActivityDefinitionList(list.stream().map(TaskCardDTO::getTmActivityId).filter(tmActivityId -> taskCodeList.contains(tmActivityId)).distinct().collect(Collectors.toList()));
        stopWatch.stop();
        log.info(" process time get km definition time :{}", (Object)stopWatch.prettyPrint());
        log.info(" process time get km definition data :{}", activityDefinitionMap);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        list.stream().filter(e -> taskCodeList.contains(e.getTmActivityId())).forEach(e -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("backlogId", e.getBacklogId());
            map.put("keys", (Long)activityDefinitionMap.get(e.getTmActivityId()));
            dataList.add(map);
        });
        HashMap<Long, Object> dataFieldMap = new HashMap<Long, Object>();
        if (CollectionUtils.isEmpty(dataList)) {
            return dataFieldMap;
        }
        Map<String, Object> editActions = this.backlogActionCreateService.getEditActions(user, dataList, (Boolean)false);
        log.info(" get actions data from ptm :{}", editActions);
        this.processData(editActions.get("project"), (List)editActions.get("tasks"), dataFieldMap, user, groupRuleList, labelRuleList, columnRuleList);
        return dataFieldMap;
    }

    private void processData(Object project, List<Map> tasks, Map<Long, Object> dataFieldMap, AuthoredUser user, List<TaskDefCodeData> groupRuleList, List<Map<String, Object>> labelRuleList, List<CardColumn> columnRuleList) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(" process single time tasks size:" + tasks.size());
        HashMap<String, Object> activityMap = new HashMap<String, Object>();
        activityMap.put("project", project);
        String tmTaskId = tasks.get(0).get("tmTaskId").toString();
        String tmActivityId = tasks.get(0).get("tmActivityId").toString();
        activityMap.put("tasks", tasks);
        JSONArray tmTaskAndActivityBk = this.themeMapService.getTmTaskAndActivityBk("activity", tmActivityId, user);
        String bkConcat = "";
        String dataName = "";
        try {
            ArrayList segmentList = new ArrayList();
            JSONArray bks = ((net.sf.json.JSONObject)tmTaskAndActivityBk.get(0)).getJSONArray("bk");
            net.sf.json.JSONObject bk = (net.sf.json.JSONObject)bks.get(0);
            dataName = bk.getString("dataName");
            JSONArray fields = bk.getJSONArray("field");
            fields.stream().forEach(e -> {
                net.sf.json.JSONObject field = (net.sf.json.JSONObject)e;
                String segment = field.getString("dataName");
                segmentList.add(segment);
            });
            bkConcat = Joiner.on((String)"$&").join(segmentList);
            List<String> bkList = Arrays.asList(bkConcat.split("\\$&"));
            Map<String, Long> bkBacklogMap = this.buildBkBacklogMap(activityMap, bkConcat, dataName);
            BaseResultDTO<Map> actionResponse = this.aglieService.getTaskCardAbstractStrBatch(tmTaskId, tmActivityId, bkConcat, activityMap);
            Map pageDataMap = (Map)actionResponse.getResponse();
            QueryResultSet resultSet = this.atdmService.getResultSet(pageDataMap, user);
            Map executeContext = (Map)pageDataMap.get("executeContext");
            String application = executeContext.get("application").toString();
            Map<String, Map<String, Object>> dataFields = this.backlogCardQueryService.getDataFields(columnRuleList, application, labelRuleList, groupRuleList, resultSet, bkList, tmActivityId);
            for (Map.Entry<String, Map<String, Object>> pdmEntry : dataFields.entrySet()) {
                Long backlogId = bkBacklogMap.get(pdmEntry.getKey());
                dataFieldMap.put(backlogId, pdmEntry.getValue());
            }
        }
        catch (Exception e2) {
            log.error("\u3010parse BK failure:{} \u3011", (Object)tmTaskAndActivityBk);
        }
        stopWatch.stop();
        log.info("process data included servers \u3010km;uibot;atdm\u3011:{}", (Object)stopWatch.prettyPrint());
    }

    private Map<String, Long> buildBkBacklogMap(Map<String, Object> activityMap, String bkContact, String dataName) {
        String[] list = bkContact.split("\\$&");
        List tasks = (List)activityMap.get("tasks");
        HashMap<String, Long> result = new HashMap<String, Long>();
        tasks.forEach(e -> {
            if (e.get("bpmData") != null) {
                Object inParams = ((Map)e.get("bpmData")).get(dataName);
                ((List)inParams).forEach(el -> {
                    ArrayList bks = new ArrayList();
                    for (String s : list) {
                        if (el.get(s) == null) continue;
                        bks.add(el.get(s));
                    }
                    String bk = Joiner.on((String)"$&").join(bks);
                    result.put(bk, (Long)e.get("backlogId"));
                });
            }
        });
        return result;
    }

    public void setBusinessMessage(TaskCardDTO taskCardDTO, AuthoredUser user, String pageCode) {
        Map<String, Object> activityData;
        if (!this.atmcService.verifyConfig(CARD_BUSINESS_MESSAGE, CARD_BUSINESS_MESSAGE).booleanValue()) {
            return;
        }
        if (!NON_REAL_TIME.equals(taskCardDTO.getBusinessMessageSourceMethod())) {
            return;
        }
        Map<String, Object> activityDataMap = null;
        BacklogBO backlogBO = this.commonPtmTransformService.selectBacklogForCard(taskCardDTO.getBacklogId());
        if (backlogBO != null && backlogBO.getTmActivityId() != null && (activityData = this.backlogActionCreateService.getEditActions(user, backlogBO.getId(), null)) instanceof Map) {
            activityDataMap = activityData;
            activityDataMap.put("businessMessageSourceType", "api");
            activityDataMap.put("cardId", taskCardDTO.getBacklogId());
            activityDataMap.put("pageCode", pageCode);
            activityDataMap.put("tmTaskId", backlogBO.getTmTaskId());
            activityDataMap.put("tmActivityId", backlogBO.getTmActivityId());
            activityDataMap.put("tenantId", user.getTenantId());
        }
        if (activityDataMap != null) {
            Map<String, Object> businessMessage = this.backlogAbstractUtil.getBusinessMessage(activityDataMap);
            BacklogCardField backlogCardField = this.backlogAbstractUtil.buildBacklogCardField(taskCardDTO.getBacklogId(), pageCode, user.getTenantId(), businessMessage);
            if (CollectionUtils.isNotEmpty(backlogCardField.getValueList())) {
                Map<String, List<String>> businessMessageMap = backlogCardField.getValueList().get(0).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((LinkedHashSet)e.getValue()).stream().map(String::valueOf).collect(Collectors.toList())));
                taskCardDTO.setBusinessMessage(businessMessageMap);
            }
        }
    }

    public void addDataFields(List<TaskCardDTO> list, AuthoredUser user) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km rule process time");
        Map<String, Object> taskCardOptimizeRules = this.themeMapService.getTaskCardOptimizeRules();
        stopWatch.stop();
        log.info(" process time get km rule data :{}", (Object)stopWatch.prettyPrint());
        List<TaskDefCodeData> groupRuleList = this.getGroupRuleList(taskCardOptimizeRules);
        List taskCodeList = groupRuleList.stream().map(TaskDefCodeData::getTaskCode).collect(Collectors.toList());
        List labelRuleList = (List)taskCardOptimizeRules.get("labelRule");
        List<CardColumn> columnRuleList = this.getColumnRuleList(taskCardOptimizeRules);
        labelRuleList.forEach(e -> taskCodeList.add(e.get("taskCode").toString()));
        List<Map> orderRuleList = this.getOrderRuleList(taskCardOptimizeRules);
        columnRuleList.forEach(e -> taskCodeList.add(e.getTaskCode()));
        Map<String, Object> orderMap = orderRuleList.stream().collect(Collectors.toMap(e -> e.get("taskCode").toString(), a -> a, (k1, k2) -> k1));
        try {
            Object businessMessageSourceMethodMap = taskCardOptimizeRules.get("businessMessageSourceMethodMap");
            JSONObject jsonObject = JSONUtil.parseObj((Object)businessMessageSourceMethodMap);
            Set businessMessageSourceMethodNotRealTimeTaskCodes = jsonObject.keySet();
            HashSet callDataFieldTaskCodeList = new HashSet(taskCodeList);
            callDataFieldTaskCodeList.removeAll(businessMessageSourceMethodNotRealTimeTaskCodes);
            Map<Long, Object> dataFieldMap = this.getDataFieldMap(list, user, new ArrayList<String>(callDataFieldTaskCodeList), groupRuleList, labelRuleList, columnRuleList);
            log.info("\u3010dataFiledMap-data: {}\u3011", dataFieldMap);
            HashMap<String, List<CardColumn>> cardColumnMap = new HashMap<String, List<CardColumn>>();
            if (CollectionUtils.isNotEmpty(columnRuleList)) {
                cardColumnMap.putAll(columnRuleList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getTaskCode())).collect(Collectors.groupingBy(o -> o.getTaskCode())));
            }
            list.forEach(e -> {
                if (businessMessageSourceMethodNotRealTimeTaskCodes.contains(e.getTmActivityId())) {
                    e.setBusinessMessageSourceMethod(NON_REAL_TIME);
                    List beanList = jsonObject.getBeanList((Object)e.getTmActivityId(), CardConfigDTO.class);
                    for (int i = beanList.size() - 1; i >= 0; --i) {
                        CardConfigDTO cardConfigDTO = (CardConfigDTO)beanList.get(i);
                        if (cardConfigDTO.getConfig() == null) continue;
                        CardConfigDTO.Config config = cardConfigDTO.getConfig();
                        if (this.isDefaultEffectiveFalse(config)) {
                            config.setLabel(null);
                        }
                        if (!this.configIsEmpty(config)) continue;
                        beanList.remove(i);
                    }
                    e.setCardConfig(beanList);
                } else if (dataFieldMap.get(e.getBacklogId()) != null) {
                    try {
                        this.adaptCardConfig((Map<String, List<CardColumn>>)cardColumnMap, dataFieldMap, (TaskCardDTO)e);
                    }
                    catch (Exception ex) {
                        log.error("adaptCardConfig error,", (Throwable)ex);
                    }
                }
                if (dataFieldMap.get(e.getBacklogId()) != null) {
                    Map dataField = (Map)dataFieldMap.get(e.getBacklogId());
                    e.setGroup((Map)dataField.get("group"));
                    e.setLabels((List)dataField.get("label"));
                    e.setColumns((List)dataField.get("columns"));
                }
                e.setOrder(this.generateOrder(e.getTmActivityId(), orderMap));
            });
            Map<String, List<TaskCardDTO>> listMap = list.stream().collect(Collectors.groupingBy(TaskCardDTO::getTmActivityId));
            HashMap<String, List<CardConfigDTO>> taskCodeConfigMap = new HashMap<String, List<CardConfigDTO>>();
            for (Map.Entry<String, List<TaskCardDTO>> entry : listMap.entrySet()) {
                List<TaskCardDTO> taskCardDTOList = entry.getValue();
                List<CardConfigDTO> configDTOS = this.combine(taskCardDTOList);
                taskCodeConfigMap.put(entry.getKey(), configDTOS);
            }
            list.forEach(o -> o.setCardConfig((List)taskCodeConfigMap.get(o.getTmActivityId())));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Object> getDataFieldMap(List<TaskCardDTO> list, AuthoredUser user, List<String> taskCodeList, List<TaskDefCodeData> groupRuleList, List<Map<String, Object>> labelRuleList, List<CardColumn> columnRuleList) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km definition process time");
        Map<String, List<String>> activityDefinitionMap = this.themeMapService.getActivityDefinitionList(list.stream().map(TaskCardDTO::getTmActivityId).filter(taskCodeList::contains).distinct().collect(Collectors.toList()));
        stopWatch.stop();
        log.info(" process time get km definition data :{}", (Object)stopWatch.prettyPrint());
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        list.stream().filter(e -> taskCodeList.contains(e.getTmActivityId())).forEach(e -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("backlogId", e.getBacklogId());
            map.put("keys", (Long)activityDefinitionMap.get(e.getTmActivityId()));
            dataList.add(map);
        });
        HashMap<Long, Object> dataFieldMap = new HashMap<Long, Object>();
        try {
            this.futureAssembly(dataList, dataFieldMap, user, taskCodeList, groupRuleList, labelRuleList, columnRuleList);
            HashMap<Long, Object> hashMap = dataFieldMap;
            return hashMap;
        }
        catch (Exception e2) {
            log.error(" futureAssembly error:{}", (Object)e2.getMessage());
            HashMap<Long, Object> hashMap = dataFieldMap;
            return hashMap;
        }
    }

    private boolean isDefaultEffectiveFalse(CardConfigDTO.Config config) {
        return config.getLabel() != null && config.getLabel().getDefaultEffective().equals("false");
    }

    private boolean configIsEmpty(CardConfigDTO.Config config) {
        return config.getLabel() == null && config.getColumn() == null && config.getFilter() == null && config.getGroup() == null && config.getOrder() == null;
    }

    private void adaptCardConfig(Map<String, List<CardColumn>> map, Map<Long, Object> dataFieldMap, TaskCardDTO e) {
        List<CardColumn> cardColumns;
        Map dataField = (Map)dataFieldMap.get(e.getBacklogId());
        List label = (List)dataField.get("label");
        Map group = (Map)dataField.get("group");
        List columns = (List)dataField.get("columns");
        HashMap<String, CardConfigDTO.Config.Label> labelMap = new HashMap<String, CardConfigDTO.Config.Label>();
        HashMap businessMessage = new HashMap();
        if (label != null) {
            label.forEach(o -> {
                Object code = o.get("code");
                Object value = o.get("value");
                HashSet objects = new HashSet();
                objects.add(value);
                businessMessage.put(String.valueOf(code), objects);
            });
            labelMap.putAll(label.stream().collect(Collectors.toMap(o -> String.valueOf(o.get("code")), o -> {
                CardConfigDTO.Config.Label label1 = new CardConfigDTO.Config.Label();
                label1.setAliasName(String.valueOf(o.get("name")));
                label1.setDefaultEffective("true");
                label1.setStyle((CardConfigDTO.Config.Label.Style)JSONUtil.toBean((String)JSONUtil.toJsonStr(o.get("style")), CardConfigDTO.Config.Label.Style.class));
                return label1;
            }, (o1, o2) -> o1)));
        }
        HashMap<String, CardConfigDTO.Config.Column> columnMap = new HashMap<String, CardConfigDTO.Config.Column>();
        if (CollectionUtils.isNotEmpty((Collection)columns)) {
            for (Map column : columns) {
                for (Map.Entry entry : column.entrySet()) {
                    HashSet set = (HashSet)businessMessage.get(entry.getKey());
                    if (set == null) {
                        set = new HashSet();
                    }
                    if (entry.getValue() != null) {
                        set.add(entry.getValue());
                    }
                    businessMessage.put(entry.getKey(), set);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(cardColumns = map.get(e.getTmActivityId()))) {
            columnMap.putAll(cardColumns.stream().collect(Collectors.toMap(col -> col.getCode(), o -> {
                CardColumn cardColumn = (CardColumn)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)o), CardColumn.class);
                CardConfigDTO.Config.Column column = new CardConfigDTO.Config.Column();
                column.setValueType(cardColumn.getValueType());
                column.setAliasName(cardColumn.getName());
                column.setDefaultEffective("true");
                return column;
            }, (o1, o2) -> o1)));
        }
        ArrayList<CardConfigDTO> cardConfigDTOS = new ArrayList<CardConfigDTO>();
        if (group != null && !group.isEmpty()) {
            String code = String.valueOf(group.get("code"));
            String name = String.valueOf(group.get("name"));
            Object value = group.get("groupName");
            LinkedHashSet<String> set = (LinkedHashSet<String>)businessMessage.get(code);
            if (set == null) {
                set = new LinkedHashSet<String>();
            }
            if (value != null) {
                set.add(String.valueOf(value));
            }
            businessMessage.put(String.valueOf(code), set);
            CardConfigDTO configDTO = new CardConfigDTO();
            configDTO.setAliasField(code);
            CardConfigDTO.Config config = new CardConfigDTO.Config();
            configDTO.setConfig(config);
            config.setColumn((CardConfigDTO.Config.Column)columnMap.remove(code));
            config.setLabel((CardConfigDTO.Config.Label)labelMap.remove(code));
            CardConfigDTO.Config.Data group1 = new CardConfigDTO.Config.Data();
            group1.setDefaultEffective("true");
            group1.setAliasName(name);
            config.setGroup(group1);
            cardConfigDTOS.add(configDTO);
        }
        if (label != null) {
            label.forEach(o -> {
                String code = String.valueOf(o.get("code"));
                String name = String.valueOf(o.get("name"));
                CardConfigDTO.Config.Column column = (CardConfigDTO.Config.Column)columnMap.remove(code);
                CardConfigDTO configDTO1 = new CardConfigDTO();
                configDTO1.setAliasField(code);
                CardConfigDTO.Config config1 = new CardConfigDTO.Config();
                configDTO1.setConfig(config1);
                config1.setLabel((CardConfigDTO.Config.Label)labelMap.get(code));
                config1.setColumn(column);
                CardConfigDTO.Config.Data filter = new CardConfigDTO.Config.Data();
                filter.setDefaultEffective("true");
                filter.setAliasName(name);
                filter.setDataType("string");
                filter.setNormal(true);
                config1.setFilter(filter);
                CardConfigDTO.Config.Data order = new CardConfigDTO.Config.Data();
                order.setDefaultEffective("true");
                order.setAliasName(name);
                config1.setOrder(order);
                cardConfigDTOS.add(configDTO1);
            });
        }
        columnMap.forEach((k, v) -> {
            CardConfigDTO configDTO1 = new CardConfigDTO();
            configDTO1.setAliasField((String)k);
            CardConfigDTO.Config config1 = new CardConfigDTO.Config();
            configDTO1.setConfig(config1);
            config1.setColumn((CardConfigDTO.Config.Column)v);
            cardConfigDTOS.add(configDTO1);
        });
        HashMap businessMessageStr = Maps.newHashMapWithExpectedSize((int)businessMessage.size());
        businessMessage.forEach((k, v) -> {
            if (CollectionUtils.isNotEmpty((Collection)v)) {
                businessMessageStr.put(k, v.stream().map(String::valueOf).collect(Collectors.toList()));
            }
        });
        e.setBusinessMessage(businessMessageStr);
        e.setCardConfig(cardConfigDTOS);
    }

    private List<CardConfigDTO> combine(List<TaskCardDTO> taskCardDTOList) {
        List configDTOS = taskCardDTOList.stream().filter(o -> CollectionUtils.isNotEmpty(o.getCardConfig())).flatMap(o -> o.getCardConfig().stream()).collect(Collectors.toList());
        Map map = configDTOS.stream().collect(Collectors.toMap(o -> o.getAliasField(), o -> o, (o1, o2) -> {
            CardConfigDTO.Config.Data order1;
            CardConfigDTO.Config.Data filter1;
            CardConfigDTO.Config.Column column1;
            CardConfigDTO.Config.Data group1;
            CardConfigDTO.Config.Label label1;
            CardConfigDTO.Config config1 = o1.getConfig();
            CardConfigDTO.Config config2 = o2.getConfig();
            if (config1 == null) {
                o1.setConfig(config2);
            }
            if (config2 == null) {
                return o1;
            }
            config1 = o1.getConfig();
            if (config1 == null) {
                return o1;
            }
            if (config2.getLabel() != null && (label1 = config1.getLabel()) == null) {
                config1.setLabel(config2.getLabel());
            }
            if (config2.getGroup() != null && (group1 = config1.getGroup()) == null) {
                config1.setGroup(config2.getGroup());
            }
            if (config2.getColumn() != null && (column1 = config1.getColumn()) == null) {
                config1.setColumn(config2.getColumn());
            }
            if (config2.getFilter() != null && (filter1 = config1.getFilter()) == null) {
                config1.setFilter(config2.getFilter());
            }
            if (config2.getOrder() != null && (order1 = config1.getOrder()) == null) {
                config1.setOrder(config2.getOrder());
            }
            return o1;
        }, LinkedHashMap::new));
        return new ArrayList<CardConfigDTO>(map.values());
    }

    private void futureAssembly(List<Map<String, Object>> listData, Map<Long, Object> dataFieldMap, AuthoredUser user, List<String> taskCodeList, List<TaskDefCodeData> groupRuleList, List<Map<String, Object>> labelRuleList, List<CardColumn> columnRuleList) {
        int size = JaProperty.getInteger((String)PARTITION_SIZE, (Integer)200);
        ArrayList completableFutureList = new ArrayList(64);
        List partition = Lists.partition(listData, (int)size);
        AppAuthContext context = AppAuthContextHolder.getContext();
        partition.parallelStream().forEach(list -> {
            AppAuthContextHolder.setContext((AppAuthContext)context);
            Map<String, Object> editActions = this.backlogActionCreateService.getEditActions(user, (List<Map<String, Object>>)list, (Boolean)false);
            Map<String, List<Map>> groupTasks = ((List)editActions.get("tasks")).stream().filter(el -> this.checkTaskCodeQueryOrNot(taskCodeList, el.get("tmActivityId").toString())).collect(Collectors.groupingBy(el -> el.get("tmTaskId") + "-" + el.get("tmActivityId")));
            List tempFutures = groupTasks.entrySet().stream().map(entry -> CompletableFuture.runAsync(JaRunnable.get(() -> this.processData(editActions.get("project"), (List)entry.getValue(), dataFieldMap, user, groupRuleList, labelRuleList, columnRuleList)), (Executor)this.taskExecutor)).collect(Collectors.toList());
            completableFutureList.addAll(tempFutures);
        });
        CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0])).join();
    }

    private Boolean checkTaskCodeQueryOrNot(List<String> taskCodes, String taskCode) {
        return taskCodes.contains(taskCode);
    }

    public void addDataFieldsV2(List<TaskCardDTO> list, AuthoredUser user, String pageCode) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km rule v2 process time");
        JSONObject param = new JSONObject();
        param.putIfAbsent((Object)"pageCode", (Object)pageCode);
        HashSet codes = new HashSet();
        if ("task-card".equals(pageCode)) {
            codes.addAll(list.stream().map(TaskCardDTO::getTmActivityId).collect(Collectors.toSet()));
        } else if ("project-card".equals(pageCode)) {
            codes.addAll(list.stream().map(TaskCardDTO::getTmTaskId).collect(Collectors.toSet()));
        } else {
            stopWatch.stop();
            return;
        }
        if (codes.isEmpty()) {
            stopWatch.stop();
            return;
        }
        param.putIfAbsent((Object)"codes", codes);
        Map<String, Object> taskCardOptimizeRules = this.themeMapService.postCardConfigByType(param);
        stopWatch.stop();
        log.info(" process time v2 get km rule data :{}", (Object)stopWatch.prettyPrint());
        try {
            log.info("\u3010cardConfig-data: {}\u3011", taskCardOptimizeRules);
            Object orderRule = taskCardOptimizeRules.get("orderRule");
            cn.hutool.json.JSONArray orderRuleArray = JSONUtil.parseArray((Object)orderRule);
            List orderRuleList = JSONUtil.toList((cn.hutool.json.JSONArray)orderRuleArray, Map.class);
            Map<String, Object> orderMap = orderRuleList.stream().collect(Collectors.toMap(e1 -> e1.get("taskCode").toString(), a -> a, (k1, k2) -> k1));
            list.forEach(e -> {
                if ("task-card".equals(pageCode)) {
                    Object o;
                    Map config;
                    if (taskCardOptimizeRules.get(e.getTmActivityId()) != null && (config = (Map)JSONUtil.toBean((String)JSONUtil.toJsonStr(o = taskCardOptimizeRules.get(e.getTmActivityId())), (TypeReference)new TypeReference<Map<String, List>>(){}, (boolean)true)) != null) {
                        e.setCardConfig(JSONUtil.toList((cn.hutool.json.JSONArray)JSONUtil.parseArray(config.get("config")), CardConfigDTO.class));
                    }
                    e.setOrder(this.generateOrder(e.getTmActivityId(), orderMap));
                    JSONObject jsonObject = JSONUtil.parseObj((String)JSONUtil.toJsonStr(taskCardOptimizeRules.get("businessMessageSourceMethodMap")));
                    e.setBusinessMessageSourceMethod(jsonObject.getStr((Object)e.getTmActivityId()));
                } else if ("project-card".equals(pageCode)) {
                    Object o;
                    Map config;
                    if (taskCardOptimizeRules.get(e.getTmActivityId()) != null && (config = (Map)JSONUtil.toBean((String)JSONUtil.toJsonStr(o = taskCardOptimizeRules.get(e.getTmTaskId())), (TypeReference)new TypeReference<Map<String, List>>(){}, (boolean)true)) != null) {
                        e.setCardConfig(JSONUtil.toList((cn.hutool.json.JSONArray)JSONUtil.parseArray(config.get("config")), CardConfigDTO.class));
                    }
                    e.setOrder(this.generateOrder(e.getTmActivityId(), orderMap));
                    JSONObject jsonObject = JSONUtil.parseObj((String)JSONUtil.toJsonStr(taskCardOptimizeRules.get("businessMessageSourceMethodMap")));
                    e.setBusinessMessageSourceMethod(jsonObject.getStr((Object)e.getTmTaskId()));
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Generated
    public BacklogBatchQueryBusinessDataService() {
    }

    @Generated
    public AtmcService getAtmcService() {
        return this.atmcService;
    }

    @Generated
    public ThemeMapService getThemeMapService() {
        return this.themeMapService;
    }

    @Generated
    public BacklogAbstractUtil getBacklogAbstractUtil() {
        return this.backlogAbstractUtil;
    }

    @Generated
    public TodoBacklogQueryService getBacklogCardQueryService() {
        return this.backlogCardQueryService;
    }

    @Generated
    public BacklogActionCreateService getBacklogActionCreateService() {
        return this.backlogActionCreateService;
    }

    @Generated
    public AglieService getAglieService() {
        return this.aglieService;
    }

    @Generated
    public AtdmService getAtdmService() {
        return this.atdmService;
    }

    @Generated
    public CommonPtmTransformService getCommonPtmTransformService() {
        return this.commonPtmTransformService;
    }

    @Generated
    public DynamicThreadPool getTaskExecutor() {
        return this.taskExecutor;
    }

    @Generated
    public void setAtmcService(AtmcService atmcService) {
        this.atmcService = atmcService;
    }

    @Generated
    public void setThemeMapService(ThemeMapService themeMapService) {
        this.themeMapService = themeMapService;
    }

    @Generated
    public void setBacklogAbstractUtil(BacklogAbstractUtil backlogAbstractUtil) {
        this.backlogAbstractUtil = backlogAbstractUtil;
    }

    @Generated
    public void setBacklogCardQueryService(TodoBacklogQueryService backlogCardQueryService) {
        this.backlogCardQueryService = backlogCardQueryService;
    }

    @Generated
    public void setBacklogActionCreateService(BacklogActionCreateService backlogActionCreateService) {
        this.backlogActionCreateService = backlogActionCreateService;
    }

    @Generated
    public void setAglieService(AglieService aglieService) {
        this.aglieService = aglieService;
    }

    @Generated
    public void setAtdmService(AtdmService atdmService) {
        this.atdmService = atdmService;
    }

    @Generated
    public void setCommonPtmTransformService(CommonPtmTransformService commonPtmTransformService) {
        this.commonPtmTransformService = commonPtmTransformService;
    }

    @Generated
    public void setTaskExecutor(DynamicThreadPool taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BacklogBatchQueryBusinessDataService)) {
            return false;
        }
        BacklogBatchQueryBusinessDataService other = (BacklogBatchQueryBusinessDataService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtmcService this$atmcService = this.getAtmcService();
        AtmcService other$atmcService = other.getAtmcService();
        if (this$atmcService == null ? other$atmcService != null : !this$atmcService.equals(other$atmcService)) {
            return false;
        }
        ThemeMapService this$themeMapService = this.getThemeMapService();
        ThemeMapService other$themeMapService = other.getThemeMapService();
        if (this$themeMapService == null ? other$themeMapService != null : !this$themeMapService.equals(other$themeMapService)) {
            return false;
        }
        BacklogAbstractUtil this$backlogAbstractUtil = this.getBacklogAbstractUtil();
        BacklogAbstractUtil other$backlogAbstractUtil = other.getBacklogAbstractUtil();
        if (this$backlogAbstractUtil == null ? other$backlogAbstractUtil != null : !this$backlogAbstractUtil.equals(other$backlogAbstractUtil)) {
            return false;
        }
        TodoBacklogQueryService this$backlogCardQueryService = this.getBacklogCardQueryService();
        TodoBacklogQueryService other$backlogCardQueryService = other.getBacklogCardQueryService();
        if (this$backlogCardQueryService == null ? other$backlogCardQueryService != null : !this$backlogCardQueryService.equals(other$backlogCardQueryService)) {
            return false;
        }
        BacklogActionCreateService this$backlogActionCreateService = this.getBacklogActionCreateService();
        BacklogActionCreateService other$backlogActionCreateService = other.getBacklogActionCreateService();
        if (this$backlogActionCreateService == null ? other$backlogActionCreateService != null : !this$backlogActionCreateService.equals(other$backlogActionCreateService)) {
            return false;
        }
        AglieService this$aglieService = this.getAglieService();
        AglieService other$aglieService = other.getAglieService();
        if (this$aglieService == null ? other$aglieService != null : !this$aglieService.equals(other$aglieService)) {
            return false;
        }
        AtdmService this$atdmService = this.getAtdmService();
        AtdmService other$atdmService = other.getAtdmService();
        if (this$atdmService == null ? other$atdmService != null : !this$atdmService.equals(other$atdmService)) {
            return false;
        }
        CommonPtmTransformService this$commonPtmTransformService = this.getCommonPtmTransformService();
        CommonPtmTransformService other$commonPtmTransformService = other.getCommonPtmTransformService();
        if (this$commonPtmTransformService == null ? other$commonPtmTransformService != null : !this$commonPtmTransformService.equals(other$commonPtmTransformService)) {
            return false;
        }
        DynamicThreadPool this$taskExecutor = this.getTaskExecutor();
        DynamicThreadPool other$taskExecutor = other.getTaskExecutor();
        return !(this$taskExecutor == null ? other$taskExecutor != null : !this$taskExecutor.equals(other$taskExecutor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BacklogBatchQueryBusinessDataService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtmcService $atmcService = this.getAtmcService();
        result = result * 59 + ($atmcService == null ? 43 : $atmcService.hashCode());
        ThemeMapService $themeMapService = this.getThemeMapService();
        result = result * 59 + ($themeMapService == null ? 43 : $themeMapService.hashCode());
        BacklogAbstractUtil $backlogAbstractUtil = this.getBacklogAbstractUtil();
        result = result * 59 + ($backlogAbstractUtil == null ? 43 : $backlogAbstractUtil.hashCode());
        TodoBacklogQueryService $backlogCardQueryService = this.getBacklogCardQueryService();
        result = result * 59 + ($backlogCardQueryService == null ? 43 : $backlogCardQueryService.hashCode());
        BacklogActionCreateService $backlogActionCreateService = this.getBacklogActionCreateService();
        result = result * 59 + ($backlogActionCreateService == null ? 43 : $backlogActionCreateService.hashCode());
        AglieService $aglieService = this.getAglieService();
        result = result * 59 + ($aglieService == null ? 43 : $aglieService.hashCode());
        AtdmService $atdmService = this.getAtdmService();
        result = result * 59 + ($atdmService == null ? 43 : $atdmService.hashCode());
        CommonPtmTransformService $commonPtmTransformService = this.getCommonPtmTransformService();
        result = result * 59 + ($commonPtmTransformService == null ? 43 : $commonPtmTransformService.hashCode());
        DynamicThreadPool $taskExecutor = this.getTaskExecutor();
        result = result * 59 + ($taskExecutor == null ? 43 : $taskExecutor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BacklogBatchQueryBusinessDataService(atmcService=" + this.getAtmcService() + ", themeMapService=" + this.getThemeMapService() + ", backlogAbstractUtil=" + this.getBacklogAbstractUtil() + ", backlogCardQueryService=" + this.getBacklogCardQueryService() + ", backlogActionCreateService=" + this.getBacklogActionCreateService() + ", aglieService=" + this.getAglieService() + ", atdmService=" + this.getAtdmService() + ", commonPtmTransformService=" + this.getCommonPtmTransformService() + ", taskExecutor=" + this.getTaskExecutor() + ")";
    }
}

