/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.backlog;

import com.digiwin.athena.abt.application.dto.migration.atmc.bpm.BpmTaskApprovePreviousActivityDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.bpm.BpmTaskPreApproveRequestDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogTransformService;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.BacklogActionCreateParentService;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BusinessKeyService;
import com.digiwin.athena.abt.application.service.atmc.migration.bpm.BpmWorkitemAppendixService;
import com.digiwin.athena.abt.application.service.atmc.migration.bpm.TaskEngineService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.abt.core.meta.enums.ActivityWorkitemSubState;
import com.digiwin.athena.abt.core.meta.enums.AtmcErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.BpmEngineCategoryEnum;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.core.meta.enums.TmTaskCategoryEnum;
import com.digiwin.athena.abt.core.meta.enums.TmTaskPatternEnum;
import com.digiwin.athena.abt.core.meta.enums.WorkitemAppendixType;
import com.digiwin.athena.abt.core.uiils.PatternCategoryUtil;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmActivityMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmActivityStepMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmActivityWorkitemMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.ActivityDataBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmWorkItemRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityStep;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmWorkitemAppendix;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BpmBacklogActionCreateService
extends BacklogActionCreateParentService {
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private BacklogMapper backlogMapper;
    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    @Autowired
    private BusinessKeyService businessKeyService;
    @Autowired
    private BpmActivityMapper bpmActivityMapper;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;
    @Autowired
    private PtmBacklogTransformService ptmBacklogTransformService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private BpmActivityStepMapper bpmActivityStepMapper;
    @Autowired
    private BpmWorkitemAppendixService bpmWorkitemAppendixService;
    @Autowired
    private TaskEngineService taskEngineService;

    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId, Boolean isHistory) {
        return this.getEditActions(authoredUser, workitemId, isHistory, null);
    }

    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId, Boolean isHistory, PtmWorkItemRecordBO ptmWorkItemRecordBO) {
        ActivityDataBO backLogMap = null;
        Boolean isPtm = true;
        List<ActivityDataBO> list = this.commonPtmTransformService.getActivityDataByBacklogId(workitemId, null, isHistory, ptmWorkItemRecordBO);
        if (CollectionUtils.isEmpty(list)) {
            list = this.backlogMapper.getActivityDatasByBacklogId(Long.valueOf(workitemId));
            isPtm = false;
        }
        BpmActivityWorkitem abnormalWorkitem = null;
        if (!isPtm.booleanValue() && (abnormalWorkitem = (BpmActivityWorkitem)this.bpmActivityWorkitemMapper.selectById((Serializable)Long.valueOf(workitemId))) != null && abnormalWorkitem.getType() == 89) {
            list = this.backlogMapper.getActivityDatasByBacklogId(abnormalWorkitem.getSourceWorkitemId());
        }
        if (list.size() > 1) {
            if (!isPtm.booleanValue()) {
                Optional<ActivityDataBO> mainWorkItem = list.stream().filter(item -> item.getGroupId() == null || item.getGroupId() == 0L).findFirst();
                if (mainWorkItem.isPresent()) {
                    backLogMap = mainWorkItem.get();
                }
                list = list.stream().filter(item -> item.getGroupId() != null && item.getGroupId() > 0L).collect(Collectors.toList());
            } else {
                backLogMap = (ActivityDataBO)list.get(0);
            }
        } else if (list.size() == 1) {
            backLogMap = (ActivityDataBO)list.get(0);
        }
        if (null == backLogMap && (backLogMap = this.backlogMapper.getInternalErrorActivityDataByBacklogId(workitemId)) != null) {
            isPtm = false;
            backLogMap.setTmPattern("BUSINESS");
            backLogMap.setTmCategory("ERROR");
            backLogMap.setTmShowFlow(Boolean.FALSE);
            backLogMap.setProcessCreateTime(backLogMap.getTaskStartTime());
            backLogMap.setTmTaskId("__uibot__");
            backLogMap.setTmActivityId("uibotInternalError");
        }
        if (backLogMap == null) {
            throw AtmcErrorCodeEnum.ACTIVITY_CAN_NOT_FIND.getBusinessExceptionWithArgs(new Object[]{workitemId});
        }
        if (backLogMap.getOverdueWorkitemId() != null && backLogMap.getOverdueWorkitemId() > 0L) {
            backLogMap.setTmTaskId("__uibot__");
            backLogMap.setTmActivityId("uibot_overdue_task");
            backLogMap.setTmPattern("UIBOT");
            backLogMap.setTmCategory("UIBOT");
            backLogMap.setTmShowFlow(Boolean.valueOf(false));
            if (!Objects.equals(backLogMap.getDataFrom(), "PTM")) {
                Backlog originalBacklog = this.backlogMapper.selectFirstByActivityStepId(backLogMap.getStepId());
                backLogMap.setPerformerId(originalBacklog.getPerformerId());
                backLogMap.setPerformerName(originalBacklog.getPerformerName());
                backLogMap.setPlanEndTime(originalBacklog.getEndTime());
            }
            backLogMap.setTmActivityName("{\"zh_TW\":\"\u903e\u6642\u8655\u7406\",\"en_US\":\"Overtime Process\",\"zh_CN\":\"\u903e\u65f6\u5904\u7406\"}");
            backLogMap.setBacklogName("{\"zh_TW\":\"\u903e\u6642\u8655\u7406\",\"en_US\":\"Overtime Process\",\"zh_CN\":\"\u903e\u65f6\u5904\u7406\"}");
            backLogMap.setProxyToken(null);
        }
        if (abnormalWorkitem != null) {
            backLogMap.setType(abnormalWorkitem.getType());
        }
        for (ActivityDataBO activityDataBO : list) {
            if (!isPtm.booleanValue()) {
                BpmActivityWorkitem workItem = BpmActivityWorkitem.builder().id(activityDataBO.getWorkItemId()).activityStepId(activityDataBO.getStepId()).performerId(activityDataBO.getPerformerId()).performerName(activityDataBO.getPerformerName()).workitemId(activityDataBO.getBpmWorkItemId()).sourceWorkitemId(activityDataBO.getSourceWorkitemId()).createType(activityDataBO.getCreateType()).state(activityDataBO.getState()).subState(activityDataBO.getSubState()).agentPerformerId(activityDataBO.getAgentPerformerId()).agentPerformerName(activityDataBO.getAgentPerformerName()).comment(activityDataBO.getComment()).performerType(activityDataBO.getPerformerType()).overdueWorkitemId(activityDataBO.getOverdueWorkitemId()).type(activityDataBO.getType()).createType(activityDataBO.getCreateType()).groupId(activityDataBO.getGroupId()).build();
                if (activityDataBO != null) {
                    if (Objects.equals(activityDataBO.getType(), 11)) {
                        List workitemList = this.bpmActivityWorkitemMapper.selectNormalByStepSqlId(workItem.getActivityStepId());
                        if (CollectionUtils.isEmpty((Collection)workitemList)) {
                            activityDataBO.setWorkitemList("[" + JsonUtils.objectToString((Object)workItem) + "]");
                        } else {
                            activityDataBO.setWorkitemList("[" + JsonUtils.objectToString(workitemList.get(0)) + "]");
                        }
                    } else {
                        activityDataBO.setWorkitemList("[" + JsonUtils.objectToString((Object)workItem) + "]");
                    }
                } else {
                    activityDataBO.setWorkitemList(null);
                }
            }
            if (backLogMap.getType() != 89) continue;
            activityDataBO.setBacklogName("{\"zh_TW\":\"\u696d\u52d9\u6578\u64da\u4e0d\u4e00\u81f4\u7570\u5e38\u6392\u9664\",\"en_US\":\"Abnormal Exclude\",\"zh_CN\":\"\u4e1a\u52a1\u6570\u636e\u4e0d\u4e00\u81f4\u5f02\u5e38\u6392\u9664\"}");
            activityDataBO.setPlanEndTime(null);
        }
        Map<String, Object> map = this.getActions(list, "", isPtm);
        map.put("dataFrom", backLogMap.getDataFrom());
        this.processSolve(workitemId, backLogMap, map);
        this.processApproval(workitemId, backLogMap, map);
        this.processReplyInvite(workitemId, backLogMap.getTmCategory(), map);
        this.processApprove(backLogMap, map);
        BpmActivityWorkitem workitem = this.bpmActivityWorkitemMapper.selectReapprovalInfoById(Long.valueOf(workitemId));
        if (workitem == null) {
            workitem = this.commonPtmTransformService.getReapprovalInfoById(workitemId);
        }
        map.put("reapprovalInfo", workitem);
        List<Long> workitemIdList = list.stream().map(ActivityDataBO::getWorkItemId).collect(Collectors.toList());
        List<Map> differentDataList = this.businessKeyService.queryDifferentDataByWorkitemId(authoredUser.getTenantId(), workitemIdList);
        List<BpmActivityWorkitem> dataUniformifyTask = this.businessKeyService.queryDataUniformifyTasks(workitemId);
        map.put("abnormalData", differentDataList);
        map.put("abnormalCards", dataUniformifyTask);
        map.put("type", backLogMap.getType());
        map.put("abnormalWorkitemId", workitemId);
        map.put("submitId", this.getSubmitId(workitemId));
        return map;
    }

    private Map<String, Object> getActions(List<ActivityDataBO> list, String engineType, boolean isPtm) {
        if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
            return null;
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        ActivityDataBO activityDataBO = list.get(0);
        HashMap<String, Object> project = new HashMap<String, Object>();
        root.put("project", project);
        project.put("projectId", activityDataBO.getTaskId());
        project.put("tmProjectId", activityDataBO.getTmTaskId());
        project.put("chargeId", activityDataBO.getChargeId());
        project.put("chargeName", activityDataBO.getChargeName());
        project.put("tenantId", activityDataBO.getTenantId());
        project.put("startTime", activityDataBO.getTaskStartTime());
        project.put("endTime", activityDataBO.getTaskEndTime());
        project.put("projectName", activityDataBO.getTaskName());
        project.put("processCreateTime", activityDataBO.getProcessCreateTime());
        project.put("projectBpmData", activityDataBO.getProjectBpmData() == null ? null : JsonUtils.jsonToObject((String)activityDataBO.getProjectBpmData(), Map.class));
        if (!StringUtils.isEmpty((Object)activityDataBO.getTaskSourceIds())) {
            ArrayList<String> ids = new ArrayList<String>();
            for (String item : activityDataBO.getTaskSourceIds().split(",")) {
                ids.add(item);
            }
            project.put("sourceIds", ids);
        }
        ArrayList<String> processSerialNumberList = new ArrayList<String>();
        for (ActivityDataBO dataDTO : list) {
            String key = dataDTO.getProcessSerialNumber() + dataDTO.getTaskUid();
            if (processSerialNumberList.contains(key)) continue;
            processSerialNumberList.add(key);
        }
        ArrayList tasks = new ArrayList();
        root.put("tasks", tasks);
        block2: for (String processSerialNumber : processSerialNumberList) {
            List activities = list.stream().filter(x -> (x.getProcessSerialNumber() + x.getTaskUid()).equals(processSerialNumber)).collect(Collectors.toList());
            Collections.sort(activities, (o1, o2) -> {
                if (o1.getBacklogId() != null && o2.getBacklogId() != null) {
                    return o2.getBacklogId().compareTo(o1.getBacklogId());
                }
                return o2.getBpmActivitySqlId().compareTo(o1.getBpmActivitySqlId());
            });
            Optional activityOpt = activities.stream().findFirst();
            if (activityOpt.isPresent()) {
                activityDataBO = (ActivityDataBO)activityOpt.get();
            }
            HashMap<String, Object> taskObject = new HashMap<String, Object>();
            tasks.add(taskObject);
            taskObject.put("processSerialNumber", activityDataBO.getProcessSerialNumber());
            taskObject.put("bpmActivitySqlId", activityDataBO.getBpmActivitySqlId());
            taskObject.put("bpmData", activityDataBO.getBpmData() == null ? null : JsonUtils.jsonToObject((String)activityDataBO.getBpmData(), Map.class));
            taskObject.put("stateData", activityDataBO.getBpmStateData() == null ? null : JsonUtils.jsonToObject((String)activityDataBO.getBpmStateData(), Map.class));
            taskObject.put("tmActivityId", activityDataBO.getTmActivityId());
            taskObject.put("compositionId", activityDataBO.getCompositionId());
            taskObject.put("tmCategory", activityDataBO.getTmCategory());
            taskObject.put("tmPattern", activityDataBO.getTmPattern());
            taskObject.put("bpmActivityId", activityDataBO.getBpmActivityId());
            taskObject.put("bpmActivityType", activityDataBO.getBpmActivityType());
            taskObject.put("performerIds", activityDataBO.getPerformerIds() == null ? null : JsonUtils.jsonToObject((String)activityDataBO.getPerformerIds(), new ArrayList().getClass()));
            taskObject.put("businessUnit", activityDataBO.getBusinessUnit() == null ? null : JsonUtils.jsonToObject((String)activityDataBO.getBusinessUnit(), Map.class));
            taskObject.put("tmActivityName", activityDataBO.getTmActivityName());
            taskObject.put("proxyToken", activityDataBO.getProxyToken());
            taskObject.put("traceId", activityDataBO.getTraceId());
            taskObject.put("type", activityDataBO.getType());
            taskObject.put("taskUid", activityDataBO.getTaskUid());
            ArrayList<String> eocNames = new ArrayList<String>();
            if (!StringUtils.isEmpty((Object)activityDataBO.getEocName()) && !eocNames.contains(activityDataBO.getEocName())) {
                eocNames.add(activityDataBO.getEocName());
            }
            taskObject.put("eocName", eocNames);
            if (!StringUtils.isEmpty((Object)activityDataBO.getApprovalState())) {
                taskObject.put("approvalState", GlobalConstant.backlogStatusMap.getOrDefault(activityDataBO.getApprovalState(), ""));
                taskObject.put("isRapprovalInfoShow", activityDataBO.getApprovalState());
            }
            ArrayList backlogs = new ArrayList();
            taskObject.put("backlog", backlogs);
            for (ActivityDataBO dataDTO : activities) {
                if (dataDTO.getBacklogId() == null) continue;
                Integer submitId = this.ptmBacklogMapper.selectSubIdBatByBackId(dataDTO.getPtmBacklogId());
                HashMap<String, Object> backlog = new HashMap<String, Object>();
                backlogs.add(backlog);
                backlog.put("backlogId", dataDTO.getWorkItemId());
                backlog.put("targetTenantId", dataDTO.getTargetTenantId());
                backlog.put("performerId", dataDTO.getPerformerId());
                backlog.put("performerName", dataDTO.getPerformerName());
                backlog.put("performerAgentId", dataDTO.getPerformerAgentId());
                backlog.put("performerAgentName", dataDTO.getPerformerAgentName());
                backlog.put("performerState", dataDTO.getPerformerState());
                backlog.put("readCount", dataDTO.getReadCount());
                backlog.put("startTime", dataDTO.getStartTime());
                backlog.put("planEndTime", dataDTO.getPlanEndTime());
                backlog.put("endTime", dataDTO.getEndTime());
                backlog.put("closed", dataDTO.getBacklogClosed());
                backlog.put("backlogName", dataDTO.getBacklogName());
                backlog.put("ptmBacklogId", dataDTO.getPtmBacklogId());
                backlog.put("submitId", submitId);
                backlog.put("ptmWorkItemId", dataDTO.getPtmWorkItemId());
                backlog.put("merge", dataDTO.getMerge());
                backlog.put("planEndTimeMin", dataDTO.getPlanEndTimeMin());
                backlog.put("planEndTimeMax", dataDTO.getPlanEndTimeMax());
                backlog.put("createType", dataDTO.getCreateType());
                if (!StringUtils.isEmpty((Object)dataDTO.getEocName()) && !eocNames.contains(dataDTO.getEocName())) {
                    eocNames.add(dataDTO.getEocName());
                }
                if (dataDTO.getEndTime() == null) {
                    if (dataDTO.getMerge().booleanValue() && isPtm) {
                        backlog.put("remainTime", TimeUtils.dateInterval((LocalDateTime)LocalDateTime.now(), (LocalDateTime)dataDTO.getPlanEndTimeMin()));
                        backlog.put("overdueDate", TimeUtils.dateInterval((LocalDateTime)dataDTO.getPlanEndTimeMin(), (LocalDateTime)LocalDateTime.now()));
                    } else {
                        backlog.put("remainTime", TimeUtils.dateInterval((LocalDateTime)LocalDateTime.now(), (LocalDateTime)dataDTO.getPlanEndTime()));
                        backlog.put("overdueDate", TimeUtils.dateInterval((LocalDateTime)dataDTO.getPlanEndTime(), (LocalDateTime)LocalDateTime.now()));
                    }
                }
                backlog.put("workitemList", dataDTO.getWorkitemList() == null ? null : JsonUtils.jsonToObject((String)dataDTO.getWorkitemList(), tasks.getClass()));
                backlog.put("finishedActionId", dataDTO.getFinishedActionId());
                if (StringUtils.isEmpty((Object)dataDTO.getFinishedActionId()) && Objects.equals(3, dataDTO.getStepState())) {
                    if (Objects.equals(ActivityWorkitemSubState.END_TASK_UNDO.getValue(), dataDTO.getStepSubState())) {
                        backlog.put("finishedActionId", "athena_bpm_cancel");
                    } else {
                        backlog.put("finishedActionId", "uibot_action_id_finished");
                    }
                }
                backlog.put("bpmSignReason", dataDTO.getStepSignReason());
                if (Objects.equals(engineType, BpmEngineCategoryEnum.TaskEngine.getCategory())) continue;
                continue block2;
            }
        }
        return root;
    }

    private void processSolve(long workitemId, ActivityDataBO backLogMap, Map<String, Object> map) {
        if (Objects.equals(TmTaskPatternEnum.BUSINESS.getValue(), backLogMap.getTmPattern()) && Objects.equals(TmTaskCategoryEnum.SOLVE.getValue(), backLogMap.getTmCategory())) {
            List tasks;
            JSONArray jsonArray = new JSONArray();
            HashMap<String, List<String>> startApproveMap = new HashMap<String, List<String>>();
            List<Map> actList = this.bpmActivityMapper.selectNoFinishedListByOriginBacklogId(Long.valueOf(workitemId));
            if (CollectionUtils.isEmpty((Collection)actList)) {
                actList = this.ptmBacklogTransformService.selectNoFinishedListByOriginBacklogIdForSolve(workitemId);
            }
            for (Map m : actList) {
                JSONObject dataJson = JSONObject.fromObject(m.get("data"));
                if (!dataJson.containsKey((Object)"originalQueryVariableName")) continue;
                String detailField = null;
                if (dataJson.containsKey((Object)"detailField") && dataJson.get("detailField") != null) {
                    detailField = dataJson.getString("detailField");
                }
                String tmTaskId = m.get("tm_task_id").toString();
                String tmActivityId = m.get("tm_activity_id").toString();
                List<String> startApproveIdList = null;
                if (startApproveMap.containsKey(tmActivityId)) {
                    startApproveIdList = (List<String>)startApproveMap.get(tmActivityId);
                } else {
                    startApproveIdList = this.getStartApproveActivity(tmTaskId, tmActivityId);
                    startApproveMap.put(tmActivityId, startApproveIdList);
                }
                if (CollectionUtils.isEmpty(startApproveIdList) || !startApproveIdList.contains(backLogMap.getTmActivityId())) continue;
                HashMap<String, Object> terminateMap = new HashMap<String, Object>();
                if (m.containsKey("dataFrom") && Objects.equals(m.get("dataFrom"), "PTM")) {
                    terminateMap.put("serialNumber", m.get("processSerialNumber"));
                    terminateMap.put("performerId", m.get("personInCharge"));
                    terminateMap.put("performerType", 0);
                    terminateMap.put("comment", "");
                } else {
                    BpmActivityStep activityStep = this.bpmActivityStepMapper.selectNoCompletedByBpmActivitySqlId(Long.valueOf(m.get("bpmActivitySqlId").toString()));
                    JSONObject workItem = activityStep.getWorkitemList().getJSONObject(0);
                    terminateMap.put("processSerialNumber", m.get("process_serial_number"));
                    terminateMap.put("performerId", workItem.get("performerId"));
                    terminateMap.put("workitemId", workItem.get("workitemId"));
                    terminateMap.put("comment", "");
                    terminateMap.put("locale", LocaleContextHolder.getLocale().toString());
                }
                JSONArray dataKeys = dataJson.getJSONArray(dataJson.getString("originalQueryVariableName"));
                List<JSONObject> detailAllDataKeys = this.getDetailAllDataKeys(dataKeys, detailField);
                for (int i = 0; i < dataKeys.size(); ++i) {
                    JSONObject dkJson = dataKeys.getJSONObject(i);
                    if (detailField != null && dkJson.containsKey((Object)detailField)) {
                        JSONArray subKeys = dkJson.getJSONArray(detailField);
                        for (Object o : subKeys) {
                            JSONObject kv = new JSONObject();
                            kv.put((Object)"dataKey", o);
                            kv.put((Object)"processParameter", terminateMap);
                            kv.put((Object)"allKey", detailAllDataKeys);
                            jsonArray.add((Object)kv);
                        }
                        continue;
                    }
                    JSONObject kv = new JSONObject();
                    kv.put((Object)"dataKey", (Object)dkJson);
                    kv.put((Object)"processParameter", terminateMap);
                    kv.put((Object)"allKey", (Object)dataKeys);
                    jsonArray.add((Object)kv);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)jsonArray) && !CollectionUtils.isEmpty((Collection)(tasks = (List)map.get("tasks")))) {
                tasks.forEach(task -> {
                    Map taskMap = (Map)task;
                    taskMap.put("abortDataKeys", jsonArray);
                });
            }
        }
    }

    private void processReplyInvite(long workitemId, String tmCategory, Map<String, Object> map) {
        BpmWorkitemAppendix appendix;
        if (Objects.equals(tmCategory, TmTaskCategoryEnum.REPLY.getValue()) && (appendix = this.bpmWorkitemAppendixService.getByBacklogId(workitemId)) != null && !Objects.equals(appendix.getErrorCode(), WorkitemAppendixType.ReSend.getValue())) {
            HashMap<String, Object> appendixMap = new HashMap<String, Object>();
            appendixMap.put("backlogId", appendix.getId());
            appendixMap.put("errorCode", appendix.getErrorCode());
            appendixMap.put("email", appendix.getEmail());
            appendixMap.put("supplierName", appendix.getSupplierName());
            List tasks = (List)map.get("tasks");
            if (!CollectionUtils.isEmpty((Collection)tasks)) {
                Map task = (Map)tasks.get(0);
                task.put("replyInvite", appendixMap);
            }
        }
    }

    private void processApprove(ActivityDataBO backLogMap, Map<String, Object> map) {
        if (backLogMap == null || StringUtils.isEmpty((Object)backLogMap.getWorkitemList()) || !PatternCategoryUtil.isApproval((String)backLogMap.getTmCategory())) {
            return;
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)backLogMap.getWorkitemList());
        String workItemId = jsonArray.getJSONObject(0).getString("workitemId");
        if (StringUtils.isEmpty((Object)workItemId)) {
            return;
        }
        if (!Objects.equals("PTM", backLogMap.getDataFrom())) {
            return;
        }
        if (CollectionUtils.isEmpty(this.getPreApproveList(workItemId).getActivities())) {
            return;
        }
        map.put("hasApprove", true);
    }

    private Integer getSubmitId(Long workItemId) {
        Integer submitId = null;
        if (workItemId != null) {
            submitId = this.ptmBacklogMapper.selectSubIdBatByBackId(workItemId);
        }
        return submitId;
    }

    private List<String> getStartApproveActivity(String tmTaskId, String tmActivityId) {
        TmActivityResponseDTO resonse = this.themeMapService.getActivityAction(tmTaskId, tmActivityId, TmPageName.TASK_CARD_NAME.getValue());
        return resonse.getStartApproveActivity();
    }

    private List<JSONObject> getDetailAllDataKeys(JSONArray dataKeys, String detailField) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (int i = 0; i < dataKeys.size(); ++i) {
            JSONObject dkJson = dataKeys.getJSONObject(i);
            if (detailField == null || !dkJson.containsKey((Object)detailField)) continue;
            result.addAll((Collection<JSONObject>)dkJson.getJSONArray(detailField));
        }
        return result;
    }

    private BpmTaskApprovePreviousActivityDTO getPreApproveList(String workItemId) {
        BpmTaskPreApproveRequestDTO requestDTO = BpmTaskPreApproveRequestDTO.builder().locale(LocaleContextHolder.getLocale().toLanguageTag()).workitemId(workItemId).build();
        return this.taskEngineService.queryPreApprove(requestDTO);
    }
}

