/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.backlog;

import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.CardColumn;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResult;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResultSet;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskDefCodeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TodoBacklogQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TodoBacklogQueryService.class);

    public Map<String, Map<String, Object>> getDataFields(List<CardColumn> columnRuleList, String application, List<Map<String, Object>> labelRuleList, List<TaskDefCodeData> groupRuleList, QueryResultSet resultSet, List<String> bkList, String tmActivityId) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        if (bkList == null || bkList.isEmpty()) {
            return result;
        }
        try {
            QueryResult queryResult = (QueryResult)resultSet.getQueryResults().get(0);
            queryResult.getData().forEach(e -> {
                CharSequence[] bzKey = new String[bkList.size()];
                for (int i = 0; i < bkList.size(); ++i) {
                    if (e.get(bkList.get(i)) == null) continue;
                    bzKey[i] = e.get(bkList.get(i)).toString();
                }
                String key = String.join((CharSequence)"$&", bzKey);
                HashMap<String, Object> data = new HashMap<String, Object>();
                Map<Object, Object> groupDataMap = new HashMap();
                List<Object> labelDataList = new ArrayList();
                HashMap orderDataMap = new HashMap();
                groupDataMap = this.parseGroup(application, groupRuleList, (Map<String, Object>)e, tmActivityId);
                labelDataList = this.parseLabel(labelRuleList, (Map<String, Object>)e, tmActivityId);
                List<Map<String, String>> columnValues = this.parseColumn(columnRuleList, (Map<String, Object>)e, tmActivityId);
                data.put("group", groupDataMap);
                data.put("label", labelDataList);
                data.put("order", orderDataMap);
                data.put("columns", columnValues);
                result.put(key, data);
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return result;
    }

    private Map<String, String> parseGroup(String application, List<TaskDefCodeData> groupRuleList, Map<String, Object> dataFields, String tmActivityId) {
        Optional<TaskDefCodeData> taskDefCodeData = groupRuleList.stream().filter(e -> e.getTaskCode().equals(tmActivityId)).findFirst();
        HashMap<String, String> result = new HashMap<String, String>();
        if (taskDefCodeData.isPresent()) {
            TaskDefCodeData codeData = taskDefCodeData.get();
            result.put("code", application + "-" + codeData.getBkCode());
            result.put("name", codeData.getName());
            result.put("groupName", dataFields.get(codeData.getBkCode()).toString());
            result.put("groupCode", application + "-" + codeData.getBkCode() + "-" + dataFields.get(codeData.getBkCode()));
        }
        if (result.get("groupName") == null || "".equals(result.get("groupName"))) {
            return new HashMap<String, String>();
        }
        return result;
    }

    private List<Map<String, Object>> parseLabel(List<Map<String, Object>> labelKeys, Map<String, Object> dataFields, String tmActivityId) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Optional<Map> taskDefCodeData = labelKeys.stream().filter(e -> e.get("taskCode").equals(tmActivityId)).findFirst();
        if (taskDefCodeData.isPresent()) {
            Map codeData = taskDefCodeData.get();
            List<Map> labels = (List<Map>)codeData.get("labels");
            if (labels == null) {
                return resultList;
            }
            if (labels.size() > 2) {
                labels = labels.stream().limit(2L).collect(Collectors.toList());
            }
            labels.forEach(label -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                Map labelField = label;
                switch (labelField.get("obtainType").toString()) {
                    case "match": {
                        result.put("type", "complex");
                        result.put("code", labelField.get("code"));
                        result.put("name", labelField.get("name"));
                        String value = dataFields.get(labelField.get("code")).toString();
                        List returnFields = (List)labelField.get("returnFields");
                        returnFields.forEach(e -> {
                            if (e.get("value").toString().equals(value)) {
                                result.put("value", e.get("name").toString());
                                result.put("orderWeight", e.get("orderWeight").toString());
                                HashMap style = new HashMap();
                                Map mongoStyle = (Map)e.get("style");
                                style.put("color", mongoStyle.get("color"));
                                result.put("style", style);
                            }
                        });
                        break;
                    }
                    case "ordinary": {
                        result.put("type", "complex");
                        result.put("code", labelField.get("code"));
                        result.put("name", labelField.get("name"));
                        result.put("value", dataFields.get(labelField.get("code")).toString());
                        List returnFieldsSimple = (List)labelField.get("returnFields");
                        HashMap style = new HashMap();
                        if (returnFieldsSimple.size() != 1) break;
                        Map mongoStyle = (Map)((Map)returnFieldsSimple.get(0)).get("style");
                        style.put("color", mongoStyle.get("color"));
                        result.put("style", style);
                    }
                }
                if (result.get("value") != null && !"".equals(result.get("value"))) {
                    resultList.add(result);
                }
            });
        }
        return resultList;
    }

    private List<Map<String, String>> parseColumn(List<CardColumn> columnRuleList, Map<String, Object> dataFields, String tmActivityId) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        columnRuleList.stream().filter(e -> e.getTaskCode().equals(tmActivityId)).forEach(e -> {
            HashMap<String, String> element = new HashMap<String, String>();
            if (dataFields.get(e.getCode()) != null) {
                element.put(e.getCode(), dataFields.get(e.getCode()).toString());
                result.add(element);
            }
        });
        return result;
    }
}

