/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.bk;

import com.digiwin.athena.abt.application.dto.migration.atmc.mongodb.MongodbService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.BKUtils;
import com.digiwin.athena.abt.core.meta.dto.IndexData;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkTaskActivityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BkTaskActivityService.class);
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private MongodbService mongodbService;
    Map<String, Object> tmActivityDataSourceMap = new HashMap<String, Object>();

    public void insertOriBk(List<JSONObject> oriBkList, List<Object> oriObjBkList, Long cardId, String tenantId, String type) {
        this.insertOriBk(oriBkList, oriObjBkList, cardId, tenantId, type, "ori");
    }

    public void insertOriBk(List<JSONObject> oriBkList, List<Object> oriObjBkList, Long cardId, String tenantId, String type, String source) {
        HashMap<String, Object> dataMap;
        String collectionName = tenantId;
        IndexData indexData = new IndexData();
        indexData.append("cardId", Integer.valueOf(1));
        indexData.append("bkSearch.index", Integer.valueOf(1));
        this.mongodbService.createCollectionLock(collectionName, indexData.getIndexList());
        ArrayList<Map> dataList = new ArrayList<Map>();
        for (JSONObject jSONObject : oriBkList) {
            dataMap = new HashMap<String, Object>();
            String bkStr = JsonUtils.objectToString((Object)jSONObject);
            String bkContent = bkStr.replaceAll("[{}\\\"]", "").replace(",", "&");
            TreeMap treeMap = (TreeMap)JsonUtils.jsonToObject((String)bkStr, TreeMap.class);
            dataMap.put("bk", treeMap);
            TreeMap bkSortMap = BKUtils.recursionToTreeMap((Map<String, Object>)jSONObject);
            String searchJsonStr = JsonUtils.objectToString((Object)bkSortMap);
            String searchContent = searchJsonStr.replaceAll("[{}\\\"]", "").replace(",", "&");
            dataMap.put("searchContent", searchContent);
            dataMap.put("bkContent", bkContent);
            dataMap.put("cardId", cardId);
            dataMap.put("type", type);
            dataMap.put("tenantId", tenantId);
            dataMap.put("CREATE_DATE", LocalDateTime.now());
            dataMap.put("modifyDate", LocalDateTime.now());
            dataMap.put("source", source);
            List<Map<String, Object>> bkSearchList = BKUtils.convertBkIndex((Map<String, Object>)jSONObject);
            dataMap.put("bkSearch", bkSearchList);
            dataMap.put("indexState", 1);
            dataList.add(dataMap);
        }
        for (Object object : oriObjBkList) {
            dataMap = new HashMap();
            dataMap.put("bk", object);
            dataMap.put("bkContent", object);
            dataMap.put("cardId", cardId);
            dataMap.put("type", type);
            dataMap.put("tenantId", tenantId);
            dataMap.put("CREATE_DATE", LocalDateTime.now());
            dataMap.put("modifyDate", LocalDateTime.now());
            dataMap.put("source", source);
            List<Map<String, Object>> bkSearchList = BKUtils.convertBkIndexSimple(object);
            dataMap.put("bkSearch", bkSearchList);
            dataMap.put("indexState", 1);
            dataList.add(dataMap);
        }
        log.info("{}", (Object)cardId);
        this.mongodbService.insert(dataList, collectionName);
    }

    public Map<String, Object> getTmBusinessKeyNew(String tmTaskId, String tmActivityId, JSONObject bpmData) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<JSONObject> bkValueList = new ArrayList<JSONObject>();
        ArrayList<Object> bkObjectValueList = new ArrayList<Object>();
        Map dataSourcesMap = null;
        if (this.tmActivityDataSourceMap.containsKey(tmTaskId + tmActivityId) && this.tmActivityDataSourceMap.get(tmTaskId + tmActivityId) != null) {
            dataSourcesMap = (Map)this.tmActivityDataSourceMap.get(tmTaskId + tmActivityId);
        } else {
            Map tmActivityMap = this.themeMapService.getActivityAction2(tmTaskId, tmActivityId, TmPageName.TASK_DETAIL_NAME.getValue());
            if (tmActivityMap != null && tmActivityMap.size() > 0) {
                Map map = dataSourcesMap = tmActivityMap.containsKey("dataSources") ? (Map)tmActivityMap.get("dataSources") : null;
            }
        }
        if (dataSourcesMap == null || dataSourcesMap.size() == 0) {
            return resultMap;
        }
        HashSet<String> businessKeySet = new HashSet<String>();
        for (Map.Entry entry : dataSourcesMap.entrySet()) {
            this.getTmActivityParams(businessKeySet, entry.getValue());
        }
        for (String key : businessKeySet) {
            if (!bpmData.containsKey((Object)key) || bpmData.get(key) == null) continue;
            if (bpmData.get(key) instanceof Collection) {
                JSONArray jsonArray = bpmData.getJSONArray(key);
                jsonArray.forEach(obj -> bkValueList.add(JSONObject.fromObject((Object)JsonUtils.objectToString((Object)obj))));
                continue;
            }
            if (bpmData.get(key) instanceof Map) {
                bkValueList.add(bpmData.getJSONObject(key));
                continue;
            }
            bkObjectValueList.add(bpmData.get(key));
        }
        if (!CollectionUtils.isEmpty(bkValueList)) {
            resultMap.put("complex", bkValueList);
        }
        if (!CollectionUtils.isEmpty(bkValueList)) {
            resultMap.put("simple", bkObjectValueList);
        }
        return resultMap;
    }

    private void getTmActivityParams(Set<String> businessKeySet, Object dataObj) {
        block5: {
            block6: {
                if (!(dataObj instanceof Collection)) break block6;
                JSONArray list = JSONArray.fromObject((Object)dataObj);
                for (Object object : list) {
                    this.getTmActivityParams(businessKeySet, object);
                }
                break block5;
            }
            if (!(dataObj instanceof Map)) break block5;
            JSONObject map = JSONObject.fromObject((Object)dataObj);
            if (!map.containsKey("actionParams") || map.get("actionParams") == null) {
                for (Map.Entry entry : map.entrySet()) {
                    this.getTmActivityParams(businessKeySet, entry.getValue());
                }
            } else {
                JSONArray tmActionParameterDTOS = JSONArray.fromObject(map.get("actionParams"));
                for (JSONObject parameterDTO : tmActionParameterDTOS) {
                    if (!"PROCESS_VARIABLE".equals(parameterDTO.get("type"))) continue;
                    businessKeySet.add(parameterDTO.getString("value"));
                    break;
                }
            }
        }
    }
}

