/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.bk;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.dto.migration.atmc.mongodb.MongodbService;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.ParserBo;
import com.digiwin.athena.abt.application.utils.BKUtils;
import com.digiwin.athena.abt.core.meta.dto.IndexData;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmActivityWorkitemMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class BusinessKeyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessKeyService.class);
    @Autowired
    private MongodbService mongodbService;
    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    public void insertBkTaskActivity(List<ParserBo> bkList, Long cardId, String tenantId, String type) {
        IndexData indexData = new IndexData();
        indexData.append("cardId", Integer.valueOf(1));
        indexData.append("bkSearch.index", Integer.valueOf(1));
        this.mongodbService.createCollectionLock(tenantId, indexData.getIndexList());
        ArrayList<Map> dataList = new ArrayList<Map>();
        for (ParserBo parserBo : bkList) {
            JSONObject bk = parserBo.getBkInfo();
            String bkStr = JsonUtils.objectToString((Object)bk);
            String bkContent = bkStr.replaceAll("\\{|}|\"", "").replace(",", "&");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            TreeMap treeMap = (TreeMap)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)bk), TreeMap.class);
            dataMap.put("bk", treeMap);
            dataMap.put("bkContent", bkContent);
            TreeMap bkSortMap = BKUtils.recursionToTreeMap((Map<String, Object>)bk);
            String searchJsonStr = JsonUtils.objectToString((Object)bkSortMap);
            String searchContent = searchJsonStr.replaceAll("\\{|}|\"", "").replace(",", "&");
            dataMap.put("searchContent", searchContent);
            dataMap.put("cardId", cardId);
            dataMap.put("type", type);
            dataMap.put("tenantId", tenantId);
            dataMap.put("entityName", parserBo.getEntityName());
            dataMap.put("createDate", LocalDateTime.now());
            dataMap.put("modifyDate", LocalDateTime.now());
            List<Map<String, Object>> bkSearchList = BKUtils.convertBkIndex((Map<String, Object>)bk);
            dataMap.put("bkSearch", bkSearchList);
            dataMap.put("indexState", 1);
            dataList.add(dataMap);
        }
        this.mongodbService.insert(dataList, tenantId);
    }

    public List<Map> queryDifferentDataByWorkitemId(String collection, List<Long> workitemIdList) {
        if (CollectionUtils.isEmpty(workitemIdList)) {
            return new ArrayList<Map>();
        }
        ArrayList<String> dealTypeList = new ArrayList<String>();
        dealTypeList.add("ignore");
        dealTypeList.add("end");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"workitem").and("cardId").in(workitemIdList).and("optType").exists(true).and("dealType").nin(dealTypeList).and("completed").exists(false));
        return this.mongodbService.query(collection, query);
    }

    public List<BpmActivityWorkitem> queryDataUniformifyTasks(Long backlogId) {
        ArrayList<BpmActivityWorkitem> result = new ArrayList<BpmActivityWorkitem>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_workitem_id", (Object)backlogId);
        queryWrapper.eq((Object)"type", (Object)89);
        List exceptionWorkitemList = this.bpmActivityWorkitemMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)exceptionWorkitemList)) {
            return exceptionWorkitemList;
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"source_backlog_id", (Object)backlogId);
        queryWrapper1.eq((Object)"type", (Object)89);
        List exceptionBacklogList = this.ptmBacklogMapper.selectList((Wrapper)queryWrapper1);
        if (CollectionUtils.isNotEmpty((Collection)exceptionBacklogList)) {
            exceptionBacklogList.forEach(exceptionBacklog -> {
                BpmActivityWorkitem bpmActivityWorkitem = BpmActivityWorkitem.builder().id(exceptionBacklog.getBacklogId()).performerId(exceptionBacklog.getPerformerId()).performerName(exceptionBacklog.getPerformerName()).workitemId(exceptionBacklog.getWorkItemId().toString()).sourceWorkitemId(exceptionBacklog.getSourceBacklogId()).closedTime(exceptionBacklog.getClosedTime()).build();
                result.add(bpmActivityWorkitem);
            });
        }
        return result;
    }
}

