/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.bpm.impl;

import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.ReplyTaskMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.bpm.BpmWorkitemAppendixService;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmActivityWorkitemMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmWorkitemAppendixMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmWorkitemAppendix;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmWorkitemAppendixServiceImpl
implements BpmWorkitemAppendixService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BpmWorkitemAppendixServiceImpl.class);
    @Autowired
    private BpmWorkitemAppendixMapper bpmWorkitemAppendixMapper;
    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    @Autowired
    private PtmBacklogTransformService ptmBacklogTransformService;
    private static MessageUtils staticMessageUtils;

    @Override
    public BpmWorkitemAppendix getByBacklogId(Long backlogId) {
        BpmWorkitemAppendix result = null;
        Long originalBacklogId = null;
        BpmActivityWorkitem workitem = this.bpmActivityWorkitemMapper.selectPartialById(backlogId);
        if (workitem != null) {
            List workitemList = this.bpmActivityWorkitemMapper.selectAllByStepSqlId(workitem.getActivityStepId());
            if (CollectionUtils.isNotEmpty((Collection)workitemList)) {
                for (BpmActivityWorkitem wi : workitemList) {
                    if (!Objects.equals(wi.getType(), 1) || Objects.equals(wi.getId(), backlogId)) continue;
                    originalBacklogId = wi.getId();
                    break;
                }
            }
        } else {
            PtmBacklog backlog = this.ptmBacklogTransformService.getReplyOriginalBacklog(backlogId);
            if (backlog != null) {
                originalBacklogId = backlog.getBacklogId();
            }
        }
        if (originalBacklogId != null) {
            result = (BpmWorkitemAppendix)this.bpmWorkitemAppendixMapper.selectById((Serializable)originalBacklogId);
        }
        return result;
    }

    @Override
    public ReplyTaskMessageDTO getReplyTaskMessage(Long backlogId) {
        ReplyTaskMessageDTO result = ReplyTaskMessageDTO.builder().code(0).build();
        BpmWorkitemAppendix appendix = this.getByBacklogId(backlogId);
        if (appendix != null) {
            result = BpmWorkitemAppendixServiceImpl.translateReplyTaskMessage(appendix.getErrorCode());
        }
        return result;
    }

    public static ReplyTaskMessageDTO translateReplyTaskMessage(Integer workitemAppendixType) {
        if (staticMessageUtils == null) {
            staticMessageUtils = (MessageUtils)SpringUtil.getBean(MessageUtils.class);
        }
        ReplyTaskMessageDTO result = ReplyTaskMessageDTO.builder().code(0).build();
        if (workitemAppendixType != null) {
            result.setCode(workitemAppendixType);
            switch (workitemAppendixType) {
                case 1001: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.NoEmail.1001"));
                    break;
                }
                case 1002: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.NoRegister.1002"));
                    break;
                }
                case 1003: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.NoPermission.1003"));
                    break;
                }
                case 1004: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.PermissionFull.1004"));
                    break;
                }
                case 1005: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.NoTenant.1005"));
                    break;
                }
                case 1006: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.Invited.1006"));
                    break;
                }
                case 1007: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.Inviting.1007"));
                    break;
                }
                case 1008: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.ReSend.1008"));
                    break;
                }
                case 1009: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.phone.1009"));
                }
            }
        }
        return result;
    }

    @Override
    public BpmWorkitemAppendix getByPtmBacklogId(Long backlogId) {
        BpmWorkitemAppendix result = null;
        Long originalBacklogId = null;
        PtmBacklog backlog = this.ptmBacklogTransformService.getReplyOriginalBacklog(backlogId);
        if (backlog != null) {
            originalBacklogId = backlog.getBacklogId();
        }
        if (originalBacklogId != null) {
            result = (BpmWorkitemAppendix)this.bpmWorkitemAppendixMapper.selectById((Serializable)originalBacklogId);
        }
        return result;
    }
}

