/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.cache.impl;

import com.digiwin.athena.abt.application.service.atmc.migration.cache.CacheQService;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class CacheQServiceImpl
implements CacheQService {
    private static String keyPrefix = "atmc:cache:";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public boolean hasKey(String key) {
        return this.stringRedisTemplate.hasKey((Object)(keyPrefix + key));
    }

    @Override
    public boolean hasKey(String serviceName, String functionName, String paraStr) {
        return this.hasKey(this.getFormatKey(serviceName, functionName, paraStr));
    }

    @Override
    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)(keyPrefix + key));
    }

    @Override
    public void cache(String key, String value) {
        this.stringRedisTemplate.boundValueOps((Object)(keyPrefix + key)).set((Object)value);
    }

    @Override
    public void cache(String key, String value, Duration duration) {
        this.stringRedisTemplate.boundValueOps((Object)(keyPrefix + key)).set((Object)value, duration);
    }

    @Override
    public void cache(String serviceName, String functionName, String paraStr, String value) {
        this.cache(this.getFormatKey(serviceName, functionName, paraStr), value);
    }

    @Override
    public void cache(String serviceName, String functionName, String paraStr, String value, Duration duration) {
        this.cache(this.getFormatKey(serviceName, functionName, paraStr), value, duration);
    }

    @Override
    public Object get(String key) {
        key = keyPrefix + key;
        return this.stringRedisTemplate.boundValueOps((Object)key).get();
    }

    @Override
    public Object get(String serviceName, String functionName, String paraStr) {
        return this.get(this.getFormatKey(serviceName, functionName, paraStr));
    }

    private String getFormatKey(String serviceName, String functionName, String paraStr) {
        return String.format("%s.%s(%s)", serviceName, functionName, paraStr);
    }

    @Override
    public void batchDelete(String pattern) {
        Set keys = this.stringRedisTemplate.keys((Object)(keyPrefix + pattern));
        this.stringRedisTemplate.delete((Collection)keys);
    }

    @Override
    public void cacheNoPrefix(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
    }
}

