/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.history;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.tenantToken.TenantTokenService;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskBacklogHistoryMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmMergeBacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmAgentPerformerDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskBacklogHistoryDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.jugg.agile.framework.core.config.JaProperty;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TaskBacklogHistoryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskBacklogHistoryService.class);
    @Autowired
    private TaskBacklogHistoryMapper historyMapper;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private TenantTokenService tenantTokenService;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    UserService userService;
    public static final String ORDER_TYPE_DESC = "desc";
    public static final String ORDER_TYPE_ASC = "asc";

    public IPage<TaskBacklogHistoryDTO> findTaskBacklogH(AuthoredUser user, Map<String, Object> paramMap) {
        LambdaQueryWrapper<TaskBacklogHistoryDTO> queryWrapper = this.buildQueryWrapper(paramMap);
        this.buildQueryCondition(user, paramMap);
        Page<TaskBacklogHistoryDTO> page = this.buildPage(paramMap);
        page.setSearchCount(false);
        this.buildQueryOrderWrapper(queryWrapper, paramMap);
        IPage<TaskBacklogHistoryDTO> pageList = this.historyMapper.findHistoryPage(queryWrapper, paramMap, page);
        pageList = this.batchAddProxyInfo(pageList);
        if (pageList.getRecords().size() == 0) {
            return pageList;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter formatterTo = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List<Long> backlogIdList = pageList.getRecords().stream().filter(t -> !"0".equals(t.getType()) && Objects.equals(t.getDataFrom(), "PTM") && t.getMerge() != false).map(TaskBacklogHistoryDTO::getId).collect(Collectors.toList());
        Map<Long, PtmMergeBacklogBO> ptmMergeBacklogDTOMap = this.commonPtmTransformService.dealBacklogData(backlogIdList, true);
        List taskIdList = pageList.getRecords().stream().filter(t -> "0".equals(t.getType())).map(TaskBacklogHistoryDTO::getId).collect(Collectors.toList());
        ArrayList<Task> tasks = new ArrayList();
        if (CollectionUtils.isNotEmpty(taskIdList)) {
            tasks = this.taskMapper.queryByMainTaskIdIds(taskIdList);
        }
        for (TaskBacklogHistoryDTO historyDTO : pageList.getRecords()) {
            String taskTargetName = MessageUtils.getMessageByCurrentLanguage((Object)historyDTO.getDefName());
            historyDTO.setDefName(taskTargetName);
            String endTimeStr = historyDTO.getEndTime().format(formatter) + " 23:59:59";
            LocalDateTime endTime = LocalDateTime.parse(endTimeStr, formatterTo);
            historyDTO.setEndTime(endTime);
            historyDTO.setName(MessageUtils.getMessageByCurrentLanguage((Object)historyDTO.getName()));
            historyDTO.setBacklogTaskName(MessageUtils.getMessageByCurrentLanguage((Object)historyDTO.getBacklogTaskName()));
            historyDTO.setProjectName(MessageUtils.getMessageByCurrentLanguage((Object)historyDTO.getProjectName()));
            historyDTO.setProjectDefName(MessageUtils.getMessageByCurrentLanguage((Object)historyDTO.getProjectDefName()));
            String type = historyDTO.getType();
            historyDTO.setExtraTimeMap(this.getExtraTimeMap(historyDTO.getState(), historyDTO.getClosedTime(), historyDTO.getStartTime(), historyDTO.getEndTime()));
            if ("0".equals(type)) {
                this.dealTaskH(historyDTO, tasks);
                continue;
            }
            this.dealBacklogH(historyDTO, ptmMergeBacklogDTOMap);
        }
        return pageList;
    }

    private void buildQueryOrderWrapper(LambdaQueryWrapper<TaskBacklogHistoryDTO> queryWrapper, Map<String, Object> paramMap) {
        if (!paramMap.containsKey("orderList")) {
            queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getClosedTime);
            return;
        }
        List orderList = (List)paramMap.get("orderList");
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getClosedTime);
            return;
        }
        List newOrderList = orderList.stream().sorted(Comparator.comparing(o -> (int)((Integer)o.get("order")))).collect(Collectors.toList());
        for (Map order : newOrderList) {
            String schema = order.get("schema").toString();
            String orderType = order.get("orderType").toString();
            if ("defName".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getDefName);
                    continue;
                }
                if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getDefName);
                    continue;
                }
                log.error("orderType:{} is not exist", (Object)orderType);
                continue;
            }
            if ("type".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getType);
                    continue;
                }
                if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getType);
                    continue;
                }
                log.error("orderType:{} is not exist", (Object)orderType);
                continue;
            }
            if ("name".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getName);
                    continue;
                }
                if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getName);
                    continue;
                }
                log.error("orderType:{} is not exist", (Object)orderType);
                continue;
            }
            if ("closedTime".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getClosedTime);
                    continue;
                }
                if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getClosedTime);
                    continue;
                }
                log.error("orderType:{} is not exist", (Object)orderType);
                continue;
            }
            if ("projectName".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getProjectName);
                    continue;
                }
                if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getProjectName);
                    continue;
                }
                log.error("orderType:{} is not exist", (Object)orderType);
                continue;
            }
            if ("projectDefName".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getProjectDefName);
                    continue;
                }
                if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getProjectDefName);
                    continue;
                }
                log.error("orderType:{} is not exist", (Object)orderType);
                continue;
            }
            if ("projectStartTime".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getProjectStartTime);
                    continue;
                }
                if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getProjectStartTime);
                    continue;
                }
                log.error("orderType:{} is not exist", (Object)orderType);
                continue;
            }
            if ("projectEndTime".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getProjectEndTime);
                    continue;
                }
                if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getProjectEndTime);
                    continue;
                }
                log.error("orderType:{} is not exist", (Object)orderType);
                continue;
            }
            log.error("schema:{} is not support order!", (Object)schema);
        }
    }

    private void dealBacklogH(TaskBacklogHistoryDTO historyDTO, Map<Long, PtmMergeBacklogBO> ptmMergeBacklogDTOMap) {
        PtmMergeBacklogBO ptmMergeBacklogBO;
        int isProxy = StringUtils.isEmpty((Object)historyDTO.getProxyUserId()) ? 0 : 1;
        historyDTO.setIsProxy(isProxy);
        if (Objects.equals(historyDTO.getDataFrom(), "PTM") && historyDTO.getMerge().booleanValue() && MapUtils.isNotEmpty(ptmMergeBacklogDTOMap) && (ptmMergeBacklogBO = ptmMergeBacklogDTOMap.get(historyDTO.getId())) != null) {
            historyDTO.setPlanEndTimeMin(ptmMergeBacklogBO.getPlanEndTimeMin());
            historyDTO.setPlanEndTimeMax(ptmMergeBacklogBO.getPlanEndTimeMax());
        }
    }

    private TaskBacklogHistoryDTO dealTaskH(TaskBacklogHistoryDTO historyDTO, List<Task> tasks) {
        List taskList = tasks.stream().filter(t -> t.getMainTaskId().equals(historyDTO.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(taskList)) {
            return historyDTO;
        }
        ArrayList itemList = new ArrayList();
        ArrayList<Long> itemTaskIds = new ArrayList<Long>();
        for (Task task : taskList) {
            String remark = task.getRemark();
            itemTaskIds.add(task.getId());
            if (StringUtils.isEmpty((Object)remark)) continue;
            HashMap<String, JSONObject> msgMap = new HashMap<String, JSONObject>();
            msgMap.put("remark", JSONObject.fromObject((Object)remark));
            itemList.add(msgMap);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"type", (Object)1);
        queryWrapper.eq((Object)"state", (Object)0);
        HashMap<String, ArrayList<Long>> historyParamMap = new HashMap<String, ArrayList<Long>>(2);
        historyParamMap.put("backlogTaskIds", itemTaskIds);
        List backlogList = this.historyMapper.findHistoryByParam(queryWrapper, historyParamMap);
        if (CollectionUtils.isNotEmpty((Collection)backlogList)) {
            for (TaskBacklogHistoryDTO backlog : backlogList) {
                backlog.setName(MessageUtils.getMessageByCurrentLanguage((Object)backlog.getName()));
                backlog.setExtraTimeMap(this.getExtraTimeMap(backlog.getState(), backlog.getClosedTime(), backlog.getStartTime(), backlog.getEndTime()));
                itemList.add(backlog);
            }
        }
        if (CollectionUtils.isNotEmpty(itemList)) {
            historyDTO.setItemTaskList(itemList);
        }
        return historyDTO;
    }

    private LambdaQueryWrapper<TaskBacklogHistoryDTO> buildQueryWrapper(Map<String, Object> paramMap) {
        String keyWord;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        boolean isKeyWordEmpty = StringUtils.isEmpty((Object)paramMap.get("name"));
        String string = keyWord = isKeyWordEmpty ? null : paramMap.get("name").toString();
        if (!isKeyWordEmpty) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(TaskBacklogHistoryDTO::getName, (Object)keyWord)).or()).like(TaskBacklogHistoryDTO::getProjectName, (Object)keyWord)).or()).like(TaskBacklogHistoryDTO::getSummary, (Object)keyWord)).or()).like(TaskBacklogHistoryDTO::getHistoryMessage, (Object)keyWord)).or()).like(TaskBacklogHistoryDTO::getSearchMessage, (Object)keyWord)).or()).like(TaskBacklogHistoryDTO::getOldPerformerName, (Object)keyWord)).or()).like(TaskBacklogHistoryDTO::getDirectionPerformerName, (Object)keyWord));
        }
        if (!StringUtils.isEmpty((Object)paramMap.get("type"))) {
            queryWrapper.eq(TaskBacklogHistoryDTO::getType, paramMap.get("type"));
        }
        if (!StringUtils.isEmpty((Object)paramMap.get("state"))) {
            queryWrapper.eq(TaskBacklogHistoryDTO::getState, paramMap.get("state"));
        }
        if (!CollectionUtils.isEmpty((Collection)((Collection)paramMap.get("defCodes")))) {
            queryWrapper.in(TaskBacklogHistoryDTO::getDefCode, (Collection)paramMap.get("defCodes"));
        }
        if (!CollectionUtils.isEmpty((Collection)((Collection)paramMap.get("projectDefCodes")))) {
            queryWrapper.in(TaskBacklogHistoryDTO::getProjectDefCode, (Collection)paramMap.get("projectDefCodes"));
        }
        return queryWrapper;
    }

    private void buildQueryCondition(AuthoredUser user, Map<String, Object> paramMap) {
        Object projectEndTimeObj;
        Object projectStartTimeObj;
        Object endTimeObj;
        paramMap.put("tenantId", user.getTenantId());
        paramMap.put("charge", user.getUserId());
        Object startTimeObj = paramMap.get("startTime");
        if (!StringUtils.isEmpty((Object)startTimeObj)) {
            String startTime = startTimeObj + " 00:00:00";
            paramMap.put("startTime", startTime);
        }
        if (!StringUtils.isEmpty((Object)(endTimeObj = paramMap.get("endTime")))) {
            String endTime = endTimeObj + " 23:59:59";
            paramMap.put("endTime", endTime);
        }
        if (!StringUtils.isEmpty((Object)(projectStartTimeObj = paramMap.get("projectStartTime")))) {
            String projectStartTime = projectStartTimeObj + " 00:00:00";
            paramMap.put("projectStartTime", projectStartTime);
        }
        if (!StringUtils.isEmpty((Object)(projectEndTimeObj = paramMap.get("projectEndTime")))) {
            String projectEndTime = projectEndTimeObj + " 23:59:59";
            paramMap.put("projectEndTime", projectEndTime);
        }
        this.buildCardTraceParameter(paramMap);
    }

    private Page<TaskBacklogHistoryDTO> buildPage(Map<String, Object> paramMap) {
        Object pageObj = paramMap.get("page");
        int page = StringUtils.isEmpty((Object)pageObj) ? 0 : Integer.valueOf(pageObj.toString());
        Object rowsObj = paramMap.get("rows");
        int rows = StringUtils.isEmpty((Object)rowsObj) ? 10 : Integer.valueOf(rowsObj.toString());
        return new Page((long)page, (long)rows);
    }

    private Map<String, Object> getExtraTimeMap(String state, LocalDateTime closedTime, LocalDateTime startTime, LocalDateTime endTime) {
        Duration duration = null;
        if (endTime == null || closedTime == null) {
            return this.countTimeNum(duration);
        }
        if ("0".equals(state)) {
            duration = Duration.between(endTime, closedTime);
        } else if ("1".equals(state)) {
            duration = Duration.between(closedTime, startTime);
        }
        return this.countTimeNum(duration);
    }

    private Map<String, Object> countTimeNum(Duration duration) {
        if (duration == null) {
            return null;
        }
        long days = duration.toDays();
        long hours = duration.toHours();
        long minutes = duration.toMinutes();
        long millis = duration.toMillis();
        Long timeNum = days;
        String type = "day";
        if (days < 1L && hours >= 1L) {
            timeNum = hours;
            type = "hour";
        } else if (days < 1L && hours < 1L && minutes >= 1L) {
            timeNum = minutes;
            type = "minute";
        } else if (days < 1L && hours < 1L && minutes < 1L && millis >= 1L) {
            timeNum = millis / 1000L;
            type = "second";
        }
        HashedMap resultMap = new HashedMap();
        resultMap.put("timeNum", timeNum);
        resultMap.put("type", type);
        return resultMap;
    }

    private IPage<TaskBacklogHistoryDTO> batchAddProxyInfo(IPage<TaskBacklogHistoryDTO> pageList) {
        if (null == pageList || null == pageList.getRecords()) {
            return pageList;
        }
        HashMap<Long, TaskBacklogHistoryDTO> tempMap = new HashMap<Long, TaskBacklogHistoryDTO>();
        HashMap<Long, TaskBacklogHistoryDTO> agentMap = new HashMap<Long, TaskBacklogHistoryDTO>();
        ArrayList<Long> queryLists = new ArrayList<Long>();
        ArrayList<Long> queryAgLists = new ArrayList<Long>();
        for (TaskBacklogHistoryDTO temp : pageList.getRecords()) {
            if (!"TaskEngine".equals(temp.getEngineType()) || !Objects.equals(temp.getType(), "1")) {
                if (StringUtils.isEmpty((Object)temp.getProxyToken())) continue;
                temp.setProxyToken(this.tenantTokenService.queryVirtualToken(temp.getTenantId()));
                continue;
            }
            queryLists.add(temp.getTaskId());
            queryAgLists.add(temp.getId());
            tempMap.put(temp.getTaskId(), temp);
            agentMap.put(temp.getId(), temp);
        }
        if (queryLists.isEmpty()) {
            return pageList;
        }
        List<PtmTaskRecordBO> taskResult = this.ptmService.getTaskRecordByTaskIds(queryLists);
        List<PtmAgentPerformerDTO> agentList = this.ptmService.queryAgentPerformerList(queryAgLists);
        if (CollectionUtils.isNotEmpty(taskResult)) {
            for (PtmTaskRecordBO tempPtmDto : taskResult) {
                if (!tempMap.containsKey(tempPtmDto.getId())) continue;
                TaskBacklogHistoryDTO historyDto = (TaskBacklogHistoryDTO)tempMap.get(tempPtmDto.getId());
                if (StringUtils.isEmpty((Object)tempPtmDto.getProxyToken())) continue;
                historyDto.setProxyToken(this.tenantTokenService.queryVirtualToken(tempPtmDto.getTenantId()));
            }
        }
        if (CollectionUtils.isNotEmpty(agentList)) {
            agentList.stream().forEach(agent -> {
                if (!agentMap.containsKey(agent.getBacklogId())) {
                    return;
                }
                TaskBacklogHistoryDTO historyDto = (TaskBacklogHistoryDTO)agentMap.get(agent.getBacklogId());
                historyDto.setPerformerType(agent.getPerformerType());
                historyDto.setProxyUserName(agent.getAgentPerformerName());
            });
        }
        return pageList;
    }

    private Map<String, String> getArchiveProperties() {
        String type = JaProperty.get((String)"sdData.archive.type");
        String date = JaProperty.get((String)"sdData.archive.date");
        String periodDay = JaProperty.get((String)"sdData.archive.periodDay");
        log.info(" archive properties type,date,periodDay:{},{},{}", new Object[]{type, date, periodDay});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", type);
        map.put("date", date);
        map.put("periodDay", periodDay);
        return map;
    }

    private void addArchiveParams(Map<String, Object> paramMap) {
        try {
            Map<String, String> archiveProperties = this.getArchiveProperties();
            if ("date".equals(archiveProperties.get("type"))) {
                paramMap.put("closedTime", archiveProperties.get("date"));
            } else if ("period".equals(archiveProperties.get("type"))) {
                LocalDateTime today = LocalDateTime.now();
                int periodDays = Integer.parseInt(archiveProperties.get("periodDay"));
                LocalDateTime previousDateTime = today.minusDays(periodDays);
                LocalDateTime startOfDay = previousDateTime.withHour(0).withMinute(0).withSecond(0).withNano(0);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String formattedDateTime = startOfDay.format(formatter);
                paramMap.put("closedTime", formattedDateTime);
            }
        }
        catch (Exception e) {
            log.error(" add archive params error", (Throwable)e);
        }
    }

    private void buildCardTraceParameter(Map<String, Object> paramMap) {
        String type;
        String begineCreateDate = MapUtils.getString(paramMap, (Object)"begineCreateDate");
        String endCreateDate = MapUtils.getString(paramMap, (Object)"endCreateDate");
        if (StrUtil.isNotBlank((CharSequence)begineCreateDate)) {
            paramMap.put("begineCreateDate", begineCreateDate + " 00:00:00");
        }
        if (StrUtil.isNotBlank((CharSequence)endCreateDate)) {
            paramMap.put("endCreateDate", endCreateDate + " 23:59:59");
        }
        if (StrUtil.isBlank((CharSequence)(type = MapUtils.getString(paramMap, (Object)"type")))) {
            this.buildTaskCardSourceTraceParameter(paramMap);
            this.buildTaskCardDirectionTraceParameter(paramMap);
            this.buildProjectCardSourceTraceParameter(paramMap);
            return;
        }
        if ("0".equals(type)) {
            this.buildProjectCardSourceTraceParameter(paramMap);
            return;
        }
        this.buildTaskCardSourceTraceParameter(paramMap);
        this.buildTaskCardDirectionTraceParameter(paramMap);
    }

    private void buildTaskCardSourceTraceParameter(Map<String, Object> paramMap) {
        List taskSourceStates = (List)MapUtil.get(paramMap, (Object)"source", List.class);
        if (CollectionUtil.isEmpty((Collection)taskSourceStates)) {
            return;
        }
        boolean contains = taskSourceStates.contains(2);
        if (contains) {
            taskSourceStates.add(3);
        }
        paramMap.put("taskSourceStates", taskSourceStates);
    }

    private void buildTaskCardDirectionTraceParameter(Map<String, Object> paramMap) {
        List taskDirectionStates = (List)MapUtil.get(paramMap, (Object)"direction", List.class);
        if (CollectionUtil.isEmpty((Collection)taskDirectionStates)) {
            return;
        }
        boolean contains = taskDirectionStates.contains(2);
        if (contains) {
            taskDirectionStates.add(3);
        }
        paramMap.put("taskDirectionStates", taskDirectionStates);
    }

    private void buildProjectCardSourceTraceParameter(Map<String, Object> paramMap) {
        List projectSourceState = (List)MapUtil.get(paramMap, (Object)"source", List.class);
        if (CollectionUtil.isEmpty((Collection)projectSourceState)) {
            return;
        }
        boolean b = projectSourceState.contains(10);
        if (b) {
            CollUtil.removeAny((Collection)projectSourceState, (Object[])new Integer[]{10});
            projectSourceState.add(3);
        }
        paramMap.put("projectSourceState", projectSourceState);
    }
}

