/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.parser.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.IEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.TaskEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.ParserBo;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.TaskBkMetadata;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.IBkMetadataParser;
import com.digiwin.athena.abt.application.service.atmc.migration.parser.IBkInstanceParser;
import com.digiwin.athena.abt.application.service.atmc.migration.parser.IParser;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="taskParser")
public class TaskParser
implements IParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskParser.class);
    private IBkMetadataParser bkMetadataParser;
    private IBkInstanceParser bkInstanceParser;

    public TaskParser(@Qualifier(value="taskBkMetadataParser") IBkMetadataParser bkMetadataParser, @Qualifier(value="taskBkInstanceParser") IBkInstanceParser bkInstanceParser) {
        this.bkMetadataParser = bkMetadataParser;
        this.bkInstanceParser = bkInstanceParser;
    }

    @Override
    public List<ParserBo> parse(IEvent event, AuthoredUser user) throws Exception {
        TaskEvent taskEvent = (TaskEvent)event;
        TaskBkMetadata bkMetadata = (TaskBkMetadata)this.bkMetadataParser.parse(taskEvent.getTempId(), taskEvent.getType(), user);
        if (null == bkMetadata) {
            return Collections.emptyList();
        }
        List<JSONObject> bkInfo = this.bkInstanceParser.parse(bkMetadata, taskEvent.getBkData());
        if (CollectionUtils.isEmpty(bkInfo)) {
            LOGGER.warn("taskEvent\u4e3a{}\u89e3\u6790\u51fa\u6765\u7684\u4e1a\u52a1\u4e3b\u952e\u4e3a\u7a7a\uff01", bkInfo);
        }
        return bkInfo.stream().map(bk -> new ParserBo((JSONObject)bk, bkMetadata.getEntityName())).collect(Collectors.toList());
    }

    public static void main(String[] args) throws JsonProcessingException {
        String str = "{\"data\": {\n                    \"detailField\": \"uuid_data\",\n                    \"processEmergency\": 50,\n                    \"dueDate\": \"2021-10-11\",\n                    \"purchase\": [\n                        {\n                            \"key1\":[\n                                {\n                                    \"purchase_no\": \"331-101009004\",\n                                    \"purchase_seq\": \"0001\",\n                                    \"purchase_sub_seq\": \"\"\n                                },\n                                {\n                                    \"purchase_no\": \"331-101009004\",\n                                    \"purchase_seq\": \"0002\",\n                                    \"purchase_sub_seq\": \"\"\n                                }\n                            ]\n                        },\n                        {\n                            \"key2\":[\n                                {\n                                    \"purchase_no\": \"331-101009004\",\n                                    \"purchase_seq\": \"0003\",\n                                    \"purchase_sub_seq\": \"\"\n                                },\n                                {\n                                    \"purchase_no\": \"331-101009004\",\n                                    \"purchase_seq\": \"0004\",\n                                    \"purchase_sub_seq\": \"\"\n                                }\n                            ]\n                        }\n                        \n                    ],\n                    \"proxyToken\": \"bf075f29-b20e-4358-a87b-c94e65f8b3ae\",\n                    \"sourceIds\": \"311-101009005\",\n                    \"personInCharge\": \"emp008\",\n                    \"process_EOC\": {\n                        \"eoc_company_id\": \"TCm02\",\n                        \"eoc_site_id\": \"Pt02\"\n                    }\n                }}";
        ObjectMapper mapper = new ObjectMapper();
        JSONObject jsonObject = JSONObject.fromObject((Object)str);
        JsonNode jsonNode = mapper.readTree(JsonUtils.objectToString((Object)jsonObject));
        JsonNode aa = jsonNode.at("/data/purchase/0/key1");
        System.out.println();
    }
}

