/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.project;

import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityPageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmDataState;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.commontype.CardPresentConfigQryService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.AglieService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmProcessMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmProcess;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmCommonProjectHandleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BpmCommonProjectHandleService.class);
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private BpmProcessMapper bpmProcessMapper;
    @Autowired
    private CardPresentConfigQryService cardPresentConfigQryService;
    @Autowired
    private AglieService aglieService;

    public Map getProjectCardSelfAbstract(AuthoredUser user, long projectId, boolean needHistoryInfo) {
        Task task = (Task)this.taskMapper.selectById((Serializable)Long.valueOf(projectId));
        if (task == null) {
            task = this.commonPtmTransformService.getTask(projectId);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (task != null) {
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);
            this.setCheckSummaryForProjectCardAbstract(map, task, needHistoryInfo);
        }
        return map;
    }

    private void setCheckSummaryForProjectCardAbstract(Map<String, Object> map, Task task, boolean needHistoryInfo) {
        Map pageData;
        Map response;
        TmDataState dataState;
        TmDataState dataState2;
        map.put("overdue", false);
        String tmTaskId = (String)map.get("tmTaskId");
        long projectId = (Long)map.get("projectId");
        TmTaskDefineResponseDTO themeMap = this.themeMapService.getTask(tmTaskId);
        if (themeMap == null || themeMap.getPages() == null) {
            return;
        }
        Map pages = themeMap.getPages();
        TmActivityPageDTO projectCardPage = null;
        if (!pages.containsKey(TmPageName.PROJECT_CARD_NAME.getValue())) {
            return;
        }
        String json = JsonUtils.objectToString(pages.get(TmPageName.PROJECT_CARD_NAME.getValue()));
        projectCardPage = (TmActivityPageDTO)JsonUtils.jsonToObject((String)json, TmActivityPageDTO.class);
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates()) && CollectionUtils.isNotEmpty((dataState2 = projectCardPage.getDataStateByDataStateType(Lists.newArrayList((Object[])new String[]{"summary", "businessInfo", "searchKey", "projectInfo"}))).getSummaryFields())) {
            projectCardPage.setSummaryFields(dataState2.getSummaryFields());
        }
        if (CollectionUtils.isEmpty(projectCardPage.getSummaryFields())) {
            return;
        }
        Map activityData = this.getActivityData(task);
        activityData.put("needHistoryInfo", needHistoryInfo);
        BaseResultDTO<Map<String, Object>> actionResponse = this.aglieService.getProjectCardDataByProjectDataAbstract(tmTaskId, projectId, activityData);
        if (actionResponse == null || actionResponse.getResponse() == null) {
            return;
        }
        map.put("scheduleRefreshCardMessage", projectCardPage.getScheduleRefreshCardMessage());
        map.put("summaryLayout", ((Map)actionResponse.getResponse()).get("summaryLayoutStr"));
        map.put("historyMessage", ((Map)actionResponse.getResponse()).get("historyMessage"));
        map.put("searchMessage", ((Map)actionResponse.getResponse()).get("searchMessage"));
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates()) && !StringUtils.isEmpty((String)(dataState = projectCardPage.getDataStateByDataStateType(Lists.newArrayList((Object[])new String[]{"summary"}))).getOverduePropertyName())) {
            projectCardPage.setOverduePropertyName(dataState.getOverduePropertyName());
        }
        if (!StringUtils.isEmpty((String)projectCardPage.getOverduePropertyName()) && (response = (Map)actionResponse.getResponse()).containsKey("pageData") && response.get("pageData") != null && response.get("pageData") instanceof Map && MapUtils.isNotEmpty((Map)(pageData = (Map)response.get("pageData"))) && pageData.containsKey(projectCardPage.getOverduePropertyName())) {
            Object overdue = pageData.get(projectCardPage.getOverduePropertyName());
            map.put("overdue", Objects.equals(overdue, 1.0));
        }
        this.cardPresentConfigQryService.setCardPresentConfigs(map, TmPageName.PROJECT_CARD_NAME.getValue());
    }

    public Map getActivityData(Task task) {
        HashMap<String, Object> project = new HashMap<String, Object>();
        project.put("projectId", task.getId());
        project.put("tmProjectId", task.getTmTaskId());
        project.put("chargeId", task.getPersonInCharge());
        project.put("chargeName", task.getPersonInChargeName());
        project.put("tenantId", task.getTenantId());
        project.put("startTime", task.getStartTime());
        project.put("endTime", task.getEndTime());
        project.put("projectName", task.getName());
        ArrayList tasks = new ArrayList();
        List<BpmProcess> processList = this.bpmProcessMapper.selectListByProjectId(task.getId());
        if (CollectionUtils.isEmpty((Collection)processList)) {
            processList = this.commonPtmTransformService.getProjectByProjectCardId(task.getId());
        }
        for (BpmProcess bpmProcess : processList) {
            HashMap<String, String> taskObject = new HashMap<String, String>();
            taskObject.put("processSerialNumber", bpmProcess.getProcessSerialNumber());
            taskObject.put("bpmData", (String)bpmProcess.getData());
            taskObject.put("businessUnit", (String)bpmProcess.getBusinessUnit());
            taskObject.put("proxyToken", bpmProcess.getProxyToken());
            tasks.add(taskObject);
        }
        HashMap<String, Cloneable> activityData = new HashMap<String, Cloneable>();
        activityData.put("project", project);
        activityData.put("tasks", tasks);
        return activityData;
    }
}

