/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.project;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityPageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmDataState;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.commontype.CardPresentConfigQryService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.AglieService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.BacklogAbstractUtil;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskWorkitemMessageMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmProcess;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskWorkitemMessage;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonProjectHandleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonProjectHandleService.class);
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Resource
    private BacklogAbstractUtil backlogAbstractUtil;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private AglieService aglieService;
    @Autowired
    private TaskWorkitemMessageMapper taskWorkitemMessageMapper;
    @Autowired
    private CardPresentConfigQryService cardPresentConfigQryService;

    public Map getProjectCardSelfAbstract(AuthoredUser user, long projectId, CardAbstractDTO cardAbstractDTO) {
        Task task = this.commonPtmTransformService.getTask(projectId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (task != null) {
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);
            Map activityData = this.setCheckSummaryForProjectCardAbstract(map, task, cardAbstractDTO);
            if (activityData != null && BooleanUtils.isTrue((Boolean)cardAbstractDTO.getNeedBusinessMessage())) {
                activityData.put("businessMessageSourceType", cardAbstractDTO.getBusinessMessageSourceType());
                activityData.put("cardId", projectId);
                activityData.put("pageCode", TmPageName.PROJECT_CARD_NAME.getValue());
                activityData.put("tmTaskId", task.getTmTaskId());
                activityData.put("tenantId", task.getTenantId());
                this.backlogAbstractUtil.getAndSaveBusinessMessage(activityData);
            }
        }
        return map;
    }

    private Map setCheckSummaryForProjectCardAbstract(Map<String, Object> map, Task task, CardAbstractDTO cardAbstractDTO) {
        Map pageData;
        TmDataState dataState;
        TmDataState dataState2;
        map.put("overdue", false);
        String tmTaskId = (String)map.get("tmTaskId");
        long projectId = (Long)map.get("projectId");
        TmTaskDefineResponseDTO themeMap = this.themeMapService.getTask(tmTaskId);
        if (themeMap == null || themeMap.getPages() == null) {
            return null;
        }
        Map pages = themeMap.getPages();
        TmActivityPageDTO projectCardPage = null;
        if (!pages.containsKey(TmPageName.PROJECT_CARD_NAME.getValue())) {
            return null;
        }
        String json = JsonUtils.objectToString(pages.get(TmPageName.PROJECT_CARD_NAME.getValue()));
        projectCardPage = (TmActivityPageDTO)JsonUtils.jsonToObject((String)json, TmActivityPageDTO.class);
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates()) && CollectionUtils.isNotEmpty((dataState2 = projectCardPage.getDataStateByDataStateType(Lists.newArrayList((Object[])new String[]{"summary", "businessInfo", "searchKey", "projectInfo"}))).getSummaryFields())) {
            projectCardPage.setSummaryFields(dataState2.getSummaryFields());
        }
        if (CollectionUtils.isEmpty(projectCardPage.getSummaryFields())) {
            return null;
        }
        boolean enableQueryApi = true;
        if (!cardAbstractDTO.isEnableQueryApi()) {
            enableQueryApi = BooleanUtils.isNotFalse((Boolean)projectCardPage.getEnableQueryApi());
        }
        Map<String, String> cardAbstractMap = new HashMap();
        Map activityData = this.getActivityData(task);
        activityData.put("needHistoryInfo", cardAbstractDTO.getNeedHistoryInfo());
        if (enableQueryApi) {
            BaseResultDTO<Map<String, Object>> actionResponse = this.aglieService.getProjectCardDataByProjectDataAbstract(tmTaskId, projectId, activityData);
            if (actionResponse == null || actionResponse.getResponse() == null) {
                return activityData;
            }
            cardAbstractMap = (Map)actionResponse.getResponse();
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.select(new String[]{"summary", "history_message", "search_message"});
            queryWrapper.eq((Object)"card_id", (Object)projectId);
            List workitemMessageList = this.taskWorkitemMessageMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)workitemMessageList)) {
                TaskWorkitemMessage taskWorkitemMessage = (TaskWorkitemMessage)workitemMessageList.get(0);
                cardAbstractMap = Maps.newHashMapWithExpectedSize((int)3);
                cardAbstractMap.put("summaryLayoutStr", taskWorkitemMessage.getSummary());
                cardAbstractMap.put("historyMessage", taskWorkitemMessage.getHistoryMessage());
                cardAbstractMap.put("searchMessage", taskWorkitemMessage.getSearchMessage());
            }
        }
        if (MapUtil.isEmpty(cardAbstractMap)) {
            return activityData;
        }
        map.put("scheduleRefreshCardMessage", projectCardPage.getScheduleRefreshCardMessage());
        map.put("scheduleRefreshCardType", projectCardPage.getScheduleRefreshCardType());
        map.put("summaryLayout", cardAbstractMap.get("summaryLayoutStr"));
        map.put("historyMessage", cardAbstractMap.get("historyMessage"));
        map.put("searchMessage", cardAbstractMap.get("searchMessage"));
        map.put("projectMessage", cardAbstractMap.get("projectMessage"));
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates()) && !StringUtils.isEmpty((String)(dataState = projectCardPage.getDataStateByDataStateType(Lists.newArrayList((Object[])new String[]{"summary"}))).getOverduePropertyName())) {
            projectCardPage.setOverduePropertyName(dataState.getOverduePropertyName());
        }
        if (!StringUtils.isEmpty((String)projectCardPage.getOverduePropertyName()) && cardAbstractMap.containsKey("pageData") && cardAbstractMap.get("pageData") != null && cardAbstractMap.get("pageData") instanceof Map && MapUtils.isNotEmpty((Map)(pageData = (Map)cardAbstractMap.get("pageData"))) && pageData.containsKey(projectCardPage.getOverduePropertyName())) {
            Object overdue = pageData.get(projectCardPage.getOverduePropertyName());
            map.put("overdue", Objects.equals(overdue, 1.0));
        }
        this.cardPresentConfigQryService.setCardPresentConfigs(map, TmPageName.PROJECT_CARD_NAME.getValue());
        return activityData;
    }

    public Map getActivityData(Task task) {
        HashMap<String, Object> project = new HashMap<String, Object>();
        project.put("projectId", task.getId());
        project.put("tmProjectId", task.getTmTaskId());
        project.put("chargeId", task.getPersonInCharge());
        project.put("chargeName", task.getPersonInChargeName());
        project.put("tenantId", task.getTenantId());
        project.put("startTime", task.getStartTime());
        project.put("endTime", task.getEndTime());
        project.put("projectName", task.getName());
        List<Map<String, Object>> tasks = this.getTasks(task.getId());
        HashMap<String, Object> activityData = new HashMap<String, Object>();
        activityData.put("project", project);
        activityData.put("tasks", tasks);
        return activityData;
    }

    private List<Map<String, Object>> getTasks(Long projectCardId) {
        ArrayList<Map<String, Object>> tasks = new ArrayList<Map<String, Object>>();
        List<BpmProcess> processList = this.commonPtmTransformService.getProjectByProjectCardId(projectCardId);
        for (BpmProcess bpmProcess : processList) {
            HashMap<String, String> taskObject = new HashMap<String, String>();
            taskObject.put("processSerialNumber", bpmProcess.getProcessSerialNumber());
            taskObject.put("bpmData", (String)bpmProcess.getData());
            taskObject.put("businessUnit", (String)bpmProcess.getBusinessUnit());
            taskObject.put("proxyToken", bpmProcess.getProxyToken());
            taskObject.put("tmTaskId", bpmProcess.getTmTaskId());
            tasks.add(taskObject);
        }
        return tasks;
    }

    public void saveProjectCardData(Long projectId) {
        Task task = this.commonPtmTransformService.getTask(projectId);
        if (task != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);
            Map activityData = this.getActivityData(task);
            activityData.put("businessMessageSourceType", "api");
            activityData.put("cardId", projectId);
            activityData.put("pageCode", TmPageName.PROJECT_CARD_NAME.getValue());
            activityData.put("tmTaskId", task.getTmTaskId());
            activityData.put("tenantId", task.getTenantId());
            this.backlogAbstractUtil.getAndSaveBusinessMessage(activityData);
        }
    }

    public Map getProjectActivityData(Long projectId) {
        Task task = this.commonPtmTransformService.getTask(projectId);
        if (task != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);
            return this.getActivityData(task);
        }
        return null;
    }
}

