/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.ptm.impl;

import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogRecordDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardItemDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRecordDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.ptm.PtmProjectTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.enums.BpmEngineCategoryEnum;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCard;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.mq.retry.exception.RetryMQException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PtmProjectTransformServiceImpl
implements PtmProjectTransformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmProjectTransformServiceImpl.class);
    @Autowired
    private PtmService ptmService;
    @Autowired
    private ThemeMapService themeMapService;

    @Override
    public ProjectCardDTO translateProjectCardForMQTT(PtmProjectCard projectCard, String autherUserId) {
        if (Objects.nonNull(projectCard) && null == projectCard.getHide()) {
            throw new RetryMQException("\u9879\u76ee\u5361\u672a\u5165atmc\u5e93,id = " + projectCard.getId() + ",\u91cd\u56de\u961f\u5217\u8fdb\u884c\u91cd\u8bd5");
        }
        if (Objects.isNull(projectCard) || projectCard.getHide() == 1) {
            return null;
        }
        ArrayList<PtmProjectCard> projectCardList = new ArrayList<PtmProjectCard>();
        projectCardList.add(projectCard);
        List<Long> projectCardIds = projectCardList.stream().map(PtmProjectCard::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(projectCardIds)) {
            return null;
        }
        List<PtmProjectCardItemDTO> ptmProjectCardList = this.ptmService.queryProjectCardListByProjectCardId(projectCardIds, autherUserId);
        log.info("translateProjectCard-list:{}", ptmProjectCardList);
        List<ProjectCardDTO> list = this.setProjectCardList(projectCardList, ptmProjectCardList);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        PtmProjectCardRecordDTO projectCardRecordDTO = this.ptmService.getProjectCardRecord(projectCard.getId());
        ProjectCardDTO projectCardDTO = ProjectCardDTO.builder().id(projectCardRecordDTO.getId()).name(projectCardRecordDTO.getProjectName()).withName(projectCardRecordDTO.getProjectWithName()).projectName(projectCardRecordDTO.getProjectDefName()).projectDefWithName(projectCardRecordDTO.getProjectDefWithName()).tmTaskId(projectCardRecordDTO.getProjectDefCode()).tmPattern(projectCardRecordDTO.getProjectDefPattern()).startTime(projectCardRecordDTO.getStartTime()).endTime(projectCardRecordDTO.getEndTime()).importance(false).createTime(projectCardRecordDTO.getCreateTime()).emergency(0L).changed(false).changedMainTaskId(0L).isOwner(true).ownerUserId(projectCardRecordDTO.getPersonInCharge()).ownerUserName(projectCardRecordDTO.getPersonInChargeName()).readCount(0L).overdue(LocalDateTime.now().isAfter(projectCardRecordDTO.getEndTime())).modifyDate(null).hasDataChanged(false).tasks(null).majorData(null).lastNewSourceIds(null).engineType(BpmEngineCategoryEnum.TaskEngine.getValue()).reAssignAble(false).personInCharge(projectCardRecordDTO.getPersonInCharge()).personInChargeName(projectCardRecordDTO.getPersonInChargeName()).dataFrom("PTM").build();
        return projectCardDTO;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ProjectCardDTO> setProjectCardList(List<PtmProjectCard> projectCardList, List<PtmProjectCardItemDTO> ptmProjectCardList) {
        ArrayList<ProjectCardDTO> list = new ArrayList<ProjectCardDTO>();
        ArrayList<String> tmProjectCodes = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(ptmProjectCardList)) {
            List<PtmProjectRecordBO> lastProjectRecordList = this.ptmService.getLastProjectRecordByProjectCardIds(ptmProjectCardList.stream().map(x -> x.getId()).distinct().collect(Collectors.toList()));
            HashMap ptmTaskRecordMap = new HashMap();
            ArrayList taskIdList = new ArrayList();
            ptmProjectCardList.forEach(ptmProjectCard -> taskIdList.addAll(ptmProjectCard.getBacklogs().stream().map(x -> x.getTaskId()).distinct().collect(Collectors.toList())));
            if (CollectionUtils.isNotEmpty(taskIdList)) {
                List<PtmTaskRecordBO> taskList = this.ptmService.getTaskRecordByTaskIds(taskIdList.stream().distinct().collect(Collectors.toList()));
                taskList.forEach(t -> ptmTaskRecordMap.put(t.getId(), t));
            }
            ptmProjectCardList.stream().forEach(ptmProjectCard -> {
                Map mergeData;
                Optional<PtmProjectCard> c;
                ProjectCardDTO card = ProjectCardDTO.builder().id(ptmProjectCard.getId()).name(ptmProjectCard.getProjectName()).withName(ptmProjectCard.getProjectWithName()).startTime(ptmProjectCard.getStartTime()).endTime(ptmProjectCard.getEndTime()).importance(false).createTime(ptmProjectCard.getCreateTime()).taskCount(ptmProjectCard.getBacklogCount().intValue()).emergency((long)ptmProjectCard.getEmergencyProjectCount().intValue() > 0L ? 1L : 0L).emergencyProjectCount(ptmProjectCard.getEmergencyProjectCount().intValue()).subProjectCount(ptmProjectCard.getProjectCount().intValue()).subProjectFinishedCount(ptmProjectCard.getProjectFinishedCount().intValue()).changed(false).changedMainTaskId(0L).isOwner(true).ownerUserId(ptmProjectCard.getPersonInCharge()).ownerUserName(ptmProjectCard.getPersonInChargeName()).readCount(0L).overdue(LocalDateTime.now().isAfter(ptmProjectCard.getEndTime())).modifyDate(null).hasDataChanged(false).tasks(null).projectName(ptmProjectCard.getProjectDefName()).projectDefWithName(ptmProjectCard.getProjectDefWithName()).tmTaskId(ptmProjectCard.getProjectDefCode()).tmPattern(ptmProjectCard.getProjectDefPattern()).majorData(null).lastNewSourceIds(null).engineType(ptmProjectCard.getEngineType()).reAssignAble(false).reassign(ptmProjectCard.getReassign()).handover(ptmProjectCard.getHandover()).personInCharge(ptmProjectCard.getPersonInCharge()).personInChargeName(ptmProjectCard.getPersonInChargeName()).interrupt(ptmProjectCard.getInterrupt()).dataFrom("PTM").interrupt(ptmProjectCard.getInterrupt()).oldPerformerId(ptmProjectCard.getOldPerformerId()).oldPerformerName(ptmProjectCard.getOldPerformerName()).build();
                if (tmProjectCodes.stream().filter(x -> Objects.equals(x, ptmProjectCard.getProjectDefCode())).count() == 0L) {
                    tmProjectCodes.add(ptmProjectCard.getProjectDefCode());
                }
                if (CollectionUtils.isNotEmpty((Collection)projectCardList) && (c = projectCardList.stream().filter(x -> Objects.equals(x.getId(), ptmProjectCard.getId())).findFirst()).isPresent()) {
                    card.setSummary(c.get().getSummary());
                    card.setHistoryMessage(c.get().getHistoryMessage());
                    card.setSearchMessage(c.get().getSearchMessage());
                    card.setReadCount(c.get().getReadCount().intValue());
                    card.setImportance(c.get().getFavorite() > 0);
                    card.setSubmitId(c.get().getSubmitId());
                    card.setTenantId(c.get().getTenantId());
                    Optional<PtmProjectRecordBO> lastProjectRecordOptional = lastProjectRecordList.stream().filter(x -> Objects.equals(x.getProjectCardId(), ptmProjectCard.getId())).findFirst();
                    if (lastProjectRecordOptional.isPresent()) {
                        PtmProjectRecordBO lastProjectRecord = lastProjectRecordOptional.get();
                        if (lastProjectRecord.getCreateTime() == null || c.get().getModifyDate() == null || c.get().getReadCount() == null) {
                            System.out.println();
                        }
                        if (lastProjectRecord.getCreateTime().isAfter(c.get().getModifyDate()) || Objects.equals(c.get().getReadCount(), 0)) {
                            card.setLastNewSourceIds(lastProjectRecord.getSourceIds());
                        }
                    }
                }
                if (!StringUtils.isEmpty((Object)ptmProjectCard.getMergeData()) && MapUtils.isNotEmpty((Map)(mergeData = (Map)JsonUtils.jsonToObject((String)ptmProjectCard.getMergeData(), Map.class))) && mergeData.size() == 1) {
                    card.setMajorData(mergeData.values().stream().findFirst().get().toString());
                }
                ArrayList<Map<String, Object>> tasks = new ArrayList<Map<String, Object>>();
                card.setTasks(tasks);
                if (CollectionUtils.isNotEmpty(ptmProjectCard.getBacklogs())) {
                    List<PtmBacklogRecordDTO> exceptionBacklogRecords = ptmProjectCard.getBacklogs().stream().filter(x -> ((PtmTaskRecordBO)ptmTaskRecordMap.get(x.getTaskId())).getHasException() != false || LocalDateTime.now().isAfter(x.getPlanEndTime())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(exceptionBacklogRecords)) {
                        exceptionBacklogRecords = ptmProjectCard.getBacklogs().stream().sorted(Comparator.comparing(PtmBacklogRecordDTO::getCreateTime)).limit(1L).collect(Collectors.toList());
                    }
                    exceptionBacklogRecords.forEach(exceptionBacklogRecord -> {
                        HashMap<String, Object> task = new HashMap<String, Object>();
                        task.put("backlogId", exceptionBacklogRecord.getId());
                        task.put("bpmProcessId", exceptionBacklogRecord.getProjectId());
                        task.put("days", 0);
                        task.put("startTime", exceptionBacklogRecord.getCreateTime());
                        task.put("endTime", exceptionBacklogRecord.getPlanEndTime());
                        task.put("exception", ((PtmTaskRecordBO)ptmTaskRecordMap.get(exceptionBacklogRecord.getTaskId())).getHasException());
                        task.put("executeType", "manual".equals(((PtmTaskRecordBO)ptmTaskRecordMap.get(exceptionBacklogRecord.getTaskId())).getTaskDefExecuteType()));
                        task.put("name", ((PtmTaskRecordBO)ptmTaskRecordMap.get(exceptionBacklogRecord.getTaskId())).getTaskDefName());
                        if (LocalDateTime.now().isAfter(exceptionBacklogRecord.getPlanEndTime())) {
                            task.put("overdue", true);
                            task.put("overdueDays", Duration.between(exceptionBacklogRecord.getPlanEndTime(), LocalDateTime.now()).toDays());
                            task.put("overdueHours", Duration.between(exceptionBacklogRecord.getPlanEndTime(), LocalDateTime.now()).toHours());
                            task.put("overdueMinutes", Duration.between(exceptionBacklogRecord.getPlanEndTime(), LocalDateTime.now()).toMinutes());
                        } else {
                            task.put("overdue", false);
                            task.put("overdueDays", 0);
                            task.put("overdueHours", 0);
                            task.put("overdueMinutes", 0);
                        }
                        task.put("performerId", exceptionBacklogRecord.getPerformerId());
                        task.put("performerName", exceptionBacklogRecord.getPerformerName());
                        task.put("projectId", exceptionBacklogRecord.getProjectId());
                        task.put("tmTaskId", ptmProjectCard.getProjectDefCode());
                        task.put("tmActivityId", exceptionBacklogRecord.getTaskDefCode());
                        task.put("tmPattern", ((PtmTaskRecordBO)ptmTaskRecordMap.get(exceptionBacklogRecord.getTaskId())).getTaskDefPattern());
                        task.put("tmCategory", ((PtmTaskRecordBO)ptmTaskRecordMap.get(exceptionBacklogRecord.getTaskId())).getTaskDefCategory());
                        tasks.add(task);
                    });
                }
                this.setProjectCardState(card);
                list.add(card);
            });
        }
        try {
            List<TmTaskDefineResponseDTO> projectCacheMap = this.themeMapService.getBatchTaskAssigns(tmProjectCodes);
            for (ProjectCardDTO projectCardDTO : list) {
                Optional<TmTaskDefineResponseDTO> tmTaskDefineDTO = projectCacheMap.stream().filter(define -> Objects.equals(define.getTaskId(), projectCardDTO.getTmTaskId())).findFirst();
                if (tmTaskDefineDTO.isPresent()) {
                    projectCardDTO.setReAssignAble(((TmTaskDefineResponseDTO)tmTaskDefineDTO.get()).getAssignConfig() != null ? ((TmTaskDefineResponseDTO)tmTaskDefineDTO.get()).getAssignConfig().getAssignAble() : false);
                    continue;
                }
                projectCardDTO.setReAssignAble(Boolean.FALSE);
            }
        }
        catch (Exception e) {
            log.warn("[PTM\u9879\u76ee\u5217\u8868\u53ef\u5426\u8f6c\u6d3e] \u51fa\u73b0\u5f02\u5e38\uff1a{},\u67e5\u8be2\u5185\u5bb9\uff1a{}", (Object)e, tmProjectCodes);
        }
        HashMap<String, String> approveActivityNameMap = new HashMap<String, String>();
        for (ProjectCardDTO project : list) {
            for (Map map : project.getTasks()) {
                if (!"APPROVAL".equals(map.get("tmCategory"))) continue;
                String tmTaskId = (String)map.get("tmTaskId");
                String tmActivityId = (String)map.get("tmActivityId");
                StringBuilder tmBuilder = new StringBuilder();
                tmBuilder.append(tmTaskId).append("-").append(tmActivityId);
                String key = tmBuilder.toString();
                if (approveActivityNameMap.containsKey(key)) {
                    map.put("subName", approveActivityNameMap.get(key));
                    continue;
                }
                try {
                    TmActivityResponseDTO themeActivity = this.themeMapService.getActivityAction(tmTaskId, tmActivityId, TmPageName.PROJECT_CARD_NAME.getValue());
                    map.put("subName", themeActivity.getStartApproveActivityName());
                    approveActivityNameMap.put(key, themeActivity.getStartApproveActivityName());
                }
                catch (Exception e) {
                    approveActivityNameMap.put(key, null);
                    log.warn("[\u67e5\u8be2kg\u5ba1\u6838\u7c7b\u578b\u6d3b\u52a8\u7684\u5b50\u6807\u9898] \u51fa\u73b0\u5f02\u5e38\uff1a{},\u67e5\u8be2\u5185\u5bb9\uff1a{}", (Object)e, tmProjectCodes);
                }
            }
        }
        HashMap<String, TmTaskDefineResponseDTO> taskDefineMap = new HashMap<String, TmTaskDefineResponseDTO>();
        for (ProjectCardDTO projectCardDTO : list) {
            try {
                void var9_14;
                if (taskDefineMap.containsKey(projectCardDTO.getTmTaskId())) {
                    TmTaskDefineResponseDTO tmTaskDefineResponseDTO = (TmTaskDefineResponseDTO)taskDefineMap.get(projectCardDTO.getTmTaskId());
                } else {
                    TmTaskDefineResponseDTO tmTaskDefineResponseDTO = this.themeMapService.getTask(projectCardDTO.getTmTaskId());
                    taskDefineMap.put(projectCardDTO.getTmTaskId(), tmTaskDefineResponseDTO);
                }
                if (var9_14 == null || var9_14.getConfig() == null) continue;
                if (var9_14.getConfig().containsKey("action")) {
                    projectCardDTO.setAction((Map)var9_14.getConfig().get("action"));
                }
                projectCardDTO.setHiddenForUser(MapUtils.getBoolean((Map)var9_14.getConfig(), (Object)"hiddenForUser", (Boolean)Boolean.FALSE));
            }
            catch (Exception exception) {
                log.warn("[PTM\u9879\u76ee\u5217\u8868\u81ea\u5b9a\u4e49\u9879\u76ee\u5361\u6253\u5f00\u65b9\u5f0f] \u51fa\u73b0\u5f02\u5e38\uff1a{},\u67e5\u8be2\u5185\u5bb9\uff1a{}", (Object)exception, (Object)projectCardDTO.getTmTaskId());
            }
        }
        taskDefineMap.clear();
        return list;
    }

    private void setProjectCardState(ProjectCardDTO projectCardDTO) {
        boolean hasException = false;
        boolean hasOverdue = false;
        for (Map<String, Object> task : projectCardDTO.getTasks()) {
            if (task.containsKey("exception") && ((Boolean)task.get("exception")).booleanValue()) {
                hasException = true;
            }
            if (!task.containsKey("overdue") || !((Boolean)task.get("overdue")).booleanValue()) continue;
            hasOverdue = true;
        }
        projectCardDTO.setException(hasException);
        projectCardDTO.setOverdue(hasOverdue);
    }
}

