/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.impl;

import com.digiwin.athena.abt.application.dto.migration.atmc.agile.CardDataParam;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.AglieService;
import com.digiwin.athena.abt.application.utils.AtmcStrUtil;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AglieServiceImpl
implements AglieService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AglieServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;

    @Override
    public BaseResultDTO<Map> getTaskCardAbstractStr(String tmTaskId, String tmActivityId, Long backlogId, Object activityDataDTO, Integer count, String langName) {
        return this.getTaskCardLayoutAbstract(tmTaskId, tmActivityId, backlogId, activityDataDTO, null, count, langName);
    }

    public BaseResultDTO<Map> getTaskCardLayoutAbstract(String tmTaskId, String tmActivityId, Long backlogId, Object activityDataDTO, String flag, Integer count, String langName) {
        String url = this.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/task/card/abstract/{tmTaskId}/{tmActivityId}/{backlogId}", tmTaskId, tmActivityId, backlogId);
        url = url + "?count=" + (count == null ? 0 : count);
        if (StringUtils.isNotEmpty((String)flag)) {
            url = url + "&flag=" + flag;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (StringUtils.isNotEmpty((String)langName)) {
            headers.add("locale", langName);
        } else {
            this.addLang(headers);
        }
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }

    @Override
    public BaseResultDTO<HashMap> getTaskCardDataSize(String tmTaskId, String tmActivityId, Object activityDataDTO) {
        String url = this.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/task/{tmTaskId}/{tmActivityId}/data/size", tmTaskId, tmActivityId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<HashMap>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map<String, Object>> getCardBusinessMessage(String tmTaskId, String tmActivityId, Object activityDataDTO) {
        String url = this.getUibotUri();
        url = StringUtils.isBlank((String)tmActivityId) ? url + AtmcStrUtil.format("api/ai/v1/bot/card/businessMessage/{tmTaskId}", tmTaskId) : url + AtmcStrUtil.format("api/ai/v1/bot/card/businessMessage/{tmTaskId}/{tmActivityId}", tmTaskId, tmActivityId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        headers.add("security-token", null);
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("flag", false);
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map<String, Object>> getProjectCardDataByProjectDataAbstract(String tmTaskId, Long projectId, Object activityDataDTO) {
        String url = this.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/project/card/abstract/{tmTaskId}/{projectId}", tmTaskId, projectId);
        return this.getCardData(url, activityDataDTO);
    }

    private String getUibotUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getUibotUri();
    }

    private BaseResultDTO<Map<String, Object>> getCardData(String uri, Object activityDataDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, param);
        ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map<String, Map<Long, Map<Long, Map<String, Object>>>>> getBatchCardBusinessMessage(String tmTaskId, String tmActivityId, CardDataParam cardDataParam) {
        String url = this.getUibotUri();
        url = StringUtils.isBlank((String)tmActivityId) ? url + "api/ai/v1/bot/card/businessBatchMessage/" + tmTaskId : url + "api/ai/v1/bot/card/businessBatchMessage/" + tmTaskId + "/" + tmActivityId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        headers.add("security-token", null);
        HttpEntity httpEntity = new HttpEntity((Object)cardDataParam, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Map<Long, Map<Long, Map<String, Object>>>>>>(){}, new Object[0]);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map> getTaskCardAbstractStrBatch(String tmTaskId, String tmActivityId, String bks, Object activityDataDTO) {
        return this.getTaskCardLayoutAbstractBatch(tmTaskId, tmActivityId, bks, activityDataDTO, null);
    }

    private BaseResultDTO<Map> getTaskCardLayoutAbstractBatch(String tmTaskId, String tmActivityId, String bkContact, Object activityDataDTO, String flag) {
        String url = this.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/task/card/abstract/batch/{tmTaskId}/{tmActivityId}/{bkContact}", tmTaskId, tmActivityId, bkContact);
        if (StringUtils.isNotEmpty((String)flag)) {
            url = url + "?flag=" + flag;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }
}

