/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.AimEventDO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageBatchUserDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AimServiceImpl
implements AimService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AimServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public void message(AuthoredUser authoredUser, MessageDO message) {
        LogDto logDto = new LogDto("\u8bf7\u6c42aim\u5b58\u50a8\u65b0\u6d88\u606f\u5f00\u59cb\uff0c\u53c2\u6570\uff1a " + JsonUtils.objectToString((Object)message), message.getTenantId());
        log.info(logDto.toString());
        String url = this.envProperties.getAimUri() + "/api/aim/v1/message";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)message, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            if (respEntity.getStatusCode().value() != 200 || !((BaseResultDTO)respEntity.getBody()).isOK()) {
                log.error("\u8bf7\u6c42aim\u5b58\u50a8\u65b0\u6d88\u606f\u5931\u8d25\uff0cstatusCode: {}, responseBody: {}.", (Object)respEntity.getStatusCode().value(), respEntity.getBody());
            }
        }
        catch (Exception ex) {
            LogDto logDtoError = new LogDto("\u8bf7\u6c42aim\u5b58\u50a8\u65b0\u6d88\u606f\u5931\u8d25: ", message.getTenantId());
            log.error(logDtoError.toString());
            log.error("\u8bf7\u6c42aim\u5b58\u50a8\u65b0\u6d88\u606f\u5931\u8d25\uff0cerror: {}.", (Throwable)ex);
        }
    }

    @Override
    public void sendMsgRemindToClient(String token, String tenantId, String userId, AppMessageDTO appMessageDTO) {
        LogDto logDto = new LogDto("\u8bf7\u6c42aim\u53d1\u9001\u65b0\u6d88\u606f\u5f00\u59cb\uff0curl\uff1a" + appMessageDTO.getDetailUrl(), tenantId + appMessageDTO.getDetailUrl());
        log.info(logDto.toString());
        this.initMsgCreateTime(appMessageDTO);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HttpEntity httpEntity = new HttpEntity((Object)appMessageDTO, (MultiValueMap)headers);
        String url = this.envProperties.getAimUri() + "/api/aim/v2/send/message/remind/to/client";
        log.info("\u3010\u8bf7\u6c42aim\u53d1\u9001\u65b0\u6d88\u606f\u5165\u53c2\u5f00\u59cb\u3011\uff1aurl\uff1a{}\uff0ctenantId\uff1a{}\uff0cuserId\uff1a{}\uff0cappMessageDTO\uff1a{}", new Object[]{url, tenantId, userId, appMessageDTO});
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        log.info("\u3010\u8bf7\u6c42aim\u53d1\u9001\u65b0\u6d88\u606f\u5165\u53c2\u7ed3\u679c\uff1a{}\u3011", (Object)responseEntity);
        ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }

    private void initMsgCreateTime(AppMessageDTO appMessageDTO) {
        if (null == appMessageDTO) {
            return;
        }
        Object msgContent = appMessageDTO.getContent();
        if (null == msgContent) {
            appMessageDTO.setContent(new HashMap());
            msgContent = appMessageDTO.getContent();
        }
        if (msgContent instanceof Map) {
            Map msgContentMap = (Map)msgContent;
            msgContentMap.put("msgCreateTime", System.currentTimeMillis());
        }
    }

    @Override
    public void sendUrageDealNotice(AuthoredUser user, AimEventDO event) {
        log.info("sendUrageDealNotice-user:{},event:{}", (Object)JsonUtils.objectToString((Object)user), (Object)JsonUtils.objectToString((Object)event));
        String url = this.envProperties.getAimUri() + "/api/aim/v1/event/mq/send/urge/deal/event";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)event, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            if (respEntity.getStatusCode().value() != 200 || !((BaseResultDTO)respEntity.getBody()).isOK()) {
                log.error("Failed to request aim to send reminder event \uff0cstatusCode: {}, responseBody: {}.", (Object)respEntity.getStatusCode().value(), respEntity.getBody());
            }
        }
        catch (Exception ex) {
            log.error("Failed to request aim to send reminder event\uff0cerror: {}.", (Throwable)ex);
        }
    }

    @Override
    public void sendMessageToClient(String token, String tenantId, List<String> userIdList, MessageDO message) {
        LogDto logDto = new LogDto("\u8bf7\u6c42aim\u53d1\u9001\u65b0\u6d88\u606f\u5f00\u59cb\uff0cuserIds\uff1a" + userIdList, tenantId + userIdList.toString());
        log.info(logDto.toString());
        MessageBatchUserDTO messageBatchUserDTO = new MessageBatchUserDTO();
        messageBatchUserDTO.setMessage(message);
        messageBatchUserDTO.setUserIdList(userIdList);
        messageBatchUserDTO.setTenantId(tenantId);
        String url = this.envProperties.getAimUri() + "/api/aim/v2/send/message/to/client";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HttpEntity httpEntity = new HttpEntity((Object)messageBatchUserDTO, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public void sendMsg4AllChannel(String token, String tenantId, String appCode, String sceneId, Map<String, Object> data) {
        log.info("[sendMsg4AllChannel] start tenantId = {},appCode = {},data = {}", new Object[]{tenantId, appCode, JsonUtils.objectToString(data)});
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("appCode", appCode);
        params.put("sceneId", sceneId);
        params.put("data", data);
        String url = this.envProperties.getAimUri() + "/api/aim/message/center/send";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public void sendToAppClient(AuthoredUser authoredUser, MessageDO message) {
        log.info("[sendToAppClient] start message = {}", (Object)JsonUtils.objectToString((Object)message));
        String url = this.envProperties.getAimUri() + "/api/aim/v2/send/message/to/app/client";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)message, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            if (respEntity.getStatusCode().value() != 200 || !((BaseResultDTO)respEntity.getBody()).isOK()) {
                log.error("[sendToAppClient] \u53d1\u9001App \u6d88\u606f\u63a8\u6ce2 \u5931\u8d25 \uff0cstatusCode: {}, responseBody: {}", (Object)respEntity.getStatusCode().value(), respEntity.getBody());
            }
        }
        catch (Exception ex) {
            log.error("[sendToAppClient]\u53d1\u9001App \u6d88\u606f\u63a8\u6ce2 \u5931\u8d25", (Throwable)ex);
        }
    }
}

