/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.EocEmployeeDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.EocResultDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.iam.ProxyUserDTOWithCodeResp;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EocServiceImpl
implements EocService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EocServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;

    @Override
    public ProxyUserResp getProxyUser(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("agentDate", df.format(LocalDateTime.now()));
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "api/eoc/v2/emp/agent";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ProxyUserDTOWithCodeResp.class, new Object[0]);
        ProxyUserDTOWithCodeResp baseResult = (ProxyUserDTOWithCodeResp)((Object)responseEntity.getBody());
        if (baseResult.getCode() == 200 && baseResult.getData() != null) {
            return baseResult.getData();
        }
        return null;
    }

    @Override
    public String getEocEmpInfo(String userId, AuthoredUser user) {
        String eocEmpId = "";
        EocEmployeeDTO employee = this.getEmployee(userId, null);
        if (Objects.isNull(employee)) {
            return eocEmpId;
        }
        return employee.getId();
    }

    private EocEmployeeDTO getEmployee(String userId, String empId) {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/emp/info";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userId", userId);
        param.put("empId", empId);
        param.put("showException", false);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
            EocResultDTO result = (EocResultDTO)responseEntity.getBody();
            if (result != null) {
                if (result.isSuccess()) {
                    return (EocEmployeeDTO)JsonUtils.jsonToObject((String)JSONObject.fromObject((Object)result.getData()).toString(), EocEmployeeDTO.class);
                }
                log.warn(result.getMessage());
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getEocByTenantAndUser(AuthoredUser user, String tenantSid, String userId) {
        if (StringUtils.isEmpty((String)tenantSid) || StringUtils.isEmpty((String)userId)) {
            return "";
        }
        String eocUserId = "";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.envProperties.getEocUri() + "/api/eoc/v2/emp/tenant/user/id/info";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantSid", tenantSid);
        paramMap.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JSONObject jsonObject = JSONObject.fromObject(((Map)response.getBody()).get("data"));
                eocUserId = jsonObject.getString("id");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return eocUserId;
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }
}

