/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.iam.UserDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.iam.UserLangMetadataDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.tenant.WithTenantRespDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.usersetting.BaseUserSettingDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.usersetting.PersonalizedDto;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.core.meta.enums.AtmcErrorCodeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.sf.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class UserServiceImpl
implements UserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private EocService eocService;
    private static final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    public static final String CATALOG_ID = "basic";
    public static final String MESSAGE_NOTICE_TYPE_KEY = "MessageSendType";

    @Override
    public UserDTO query(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/full";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserDTO.class, new Object[0]);
        return (UserDTO)responseEntity.getBody();
    }

    @Override
    public UserDTO query(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/full";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserDTO.class, new Object[0]);
        UserDTO userDTO = (UserDTO)responseEntity.getBody();
        if (userDTO == null || StringUtils.isEmpty((Object)userDTO.getId())) {
            log.error("[IAM] \u67e5\u8be2 " + userId + " \u7684\u7528\u6237\u4fe1\u606f\u5931\u8d25,  {}", (Object)userDTO);
            userDTO = null;
        }
        return userDTO;
    }

    @Override
    public UserDTO getTargetUser(String userId, String token) {
        UserDTO targetUser = null;
        ProxyUserResp proxyUserResp = this.eocService.getProxyUser(userId, token);
        if (proxyUserResp != null && StringUtils.hasText((String)proxyUserResp.getUserId())) {
            targetUser = this.query(proxyUserResp.getUserId(), token);
        }
        if (targetUser == null) {
            targetUser = this.query(userId, token);
        }
        return targetUser;
    }

    @Override
    public String getUserLangMetadataAllTenant(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        log.info("getUserLangMetadataAllTenant-userId:{}", (Object)userId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("catalogId", CATALOG_ID);
        params.put("key", "dapAcceptLanguage");
        params.put("userId", userId);
        params.put("tenantSid", 0);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        log.info("{}.{}", (Object)token, (Object)JsonUtils.objectToString(params));
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/user/get";
        try {
            UserLangMetadataDTO baseResult;
            ResponseEntity respEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserLangMetadataDTO.class, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue() && null != (baseResult = (UserLangMetadataDTO)((Object)respEntity.getBody())) && HttpStatus.OK.value() == baseResult.getCode().intValue()) {
                Optional<Object> langOpt = Optional.ofNullable(baseResult.getData()).map(data -> data.get("value"));
                return langOpt.isPresent() ? String.valueOf(langOpt.get()) : this.defaultLanguage();
            }
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)JsonUtils.objectToString((Object)respEntity.getBody()));
        }
        catch (Exception ex) {
            log.error("{}, \u8bf7\u6c42body\u4f53\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a", new Object[]{AtmcErrorCodeEnum.IAM_GET_USERMETADATA_FAIL.getErrCode(), JsonUtils.objectToString(params), ex});
            throw ExceptionUtil.wrap((String)AtmcErrorCodeEnum.IAM_GET_USERMETADATA_FAIL.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public boolean getMessageDoNotDisturbUserId(String userId, String tenantId, String token) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", token);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantId", tenantId);
            param.put("userId", userId);
            param.put("catalogId", CATALOG_ID);
            param.put("key", "doNotDisturb");
            HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/user/metadata/value";
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            Map result = (Map)responseEntity.getBody();
            if (result.containsKey("data")) {
                return "1".equals(result.get("data").toString());
            }
            return false;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    @Override
    public String queryUserEmail(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/withtenant";
        try {
            ResponseEntity dataEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, WithTenantRespDto.class, new Object[0]);
            if (dataEntity.getBody() != null) {
                WithTenantRespDto baseDto = (WithTenantRespDto)dataEntity.getBody();
                if (null == baseDto || null == baseDto.getEmail()) {
                    logger.error("Query user email with no data return:{}", (Object)userId);
                    return null;
                }
                return baseDto.getEmail();
            }
        }
        catch (Exception e) {
            logger.error("Query User Email info Error error with param:{}", (Object)userId, (Object)e);
            return null;
        }
        return null;
    }

    @Override
    public PersonalizedDto queryPersonalizedInfo(Long tenantSid, String userId, String key, String catalogId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantSid", tenantSid);
        param.put("userId", userId);
        param.put("catalogId", catalogId);
        param.put("key", key);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        log.info("[UserServiceImpl.queryPersonalizedInfo],param :{},headers :{}", param, (Object)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/user/get";
        ResponseEntity dataEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, BaseUserSettingDto.class, new Object[0]);
        if (dataEntity.getBody() == null) {
            logger.error("can not find user meta response body  with:{}", param);
            return null;
        }
        if (((BaseUserSettingDto)dataEntity.getBody()).getData() == null) {
            logger.error("can not find user meta response data  with:{}", param);
            return null;
        }
        BaseUserSettingDto baseDto = (BaseUserSettingDto)dataEntity.getBody();
        return (PersonalizedDto)JsonUtils.jsonToObject((String)JsonUtils.objectToString(baseDto.getData()), PersonalizedDto.class);
    }

    @Override
    public List<String> getEmployee(List<String> userList, AuthoredUser user) {
        ArrayList<String> memberList = new ArrayList<String>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/list";
        HttpEntity httpEntity = new HttpEntity(userList, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        if (responseEntity.getStatusCode() == HttpStatus.OK && ((Map)responseEntity.getBody()).get("data") != null) {
            JSONArray jsonArray = JSONArray.fromObject(((Map)responseEntity.getBody()).get("data"));
            for (Object object : jsonArray) {
                Map map = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(object), Map.class);
                if (!"0".equals(map.get("type").toString())) continue;
                String id = this.eocService.getEocEmpInfo(map.get("id").toString(), user);
                memberList.add(id);
            }
        }
        return memberList;
    }

    @Override
    public String getUserLangNameByUserId(String userId, String tenantId, String token) {
        return this.getUserLangMetadataAllTenant(userId, token);
    }

    private String defaultLanguage() {
        return org.apache.commons.lang.StringUtils.equals((String)"SIMPLIFIED_CHINESE", (String)this.envProperties.getDefaultLanguage()) ? Locale.SIMPLIFIED_CHINESE.toString() : Locale.TRADITIONAL_CHINESE.toString();
    }
}

