/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.impl;

import com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.ImService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ImServiceImpl
implements ImService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    private boolean disableIM() {
        return StringUtils.isBlank((String)this.getImUri());
    }

    @Override
    public void removeTeam(String bizId, int type, AuthoredUser user) {
        if (this.disableIM()) {
            return;
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", user.getToken());
            String url = this.getImUri() + "/team/removeTeam";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("bizId", bizId);
            paramMap.put("type", type);
            paramMap.put("source", "atmc");
            HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateTeamInfo(AuthoredUser user, String tid, String cardIds) {
        if (this.disableIM()) {
            return;
        }
        Object resultMap = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.getImUri() + "/team/updateTeam";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tid", tid);
        paramMap.put("cardIds", cardIds);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        log.info("\u66f4\u65b0\u7fa4\u6d88\u606f\uff1a{}", (Object)responseEntity);
    }

    @Override
    public Map getTeamInfo(AuthoredUser user, String bizId, int type, String source) {
        Object response;
        if (this.disableIM()) {
            return null;
        }
        Map resultMap = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.getImUri() + "/team/getMasterByBizIdAndTypeAndSource";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bizId", bizId);
        paramMap.put("type", type);
        paramMap.put("source", source);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        if (responseEntity.getStatusCode() == HttpStatus.OK && (response = ((Map)responseEntity.getBody()).get("response")) != null && response != "") {
            resultMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(response), Map.class);
        }
        return resultMap;
    }

    @Override
    public void removeTeamByParam(String bizId, int type, String cardId, String businessKey, AuthoredUser user) {
        if (this.disableIM()) {
            return;
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", user.getToken());
            String url = this.getImUri() + "/team/removeTeam";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("bizId", bizId);
            paramMap.put("type", type);
            paramMap.put("cardId", cardId);
            paramMap.put("businessKey", businessKey);
            paramMap.put("source", "pcc");
            HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            log.info("\u6279\u91cf\u89e3\u6563\u7fa4\uff1a{}", paramMap);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            log.info("\u6279\u91cf\u89e3\u6563\u7fa4\u6210\u529f\uff1a{}", (Object)response);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u89e3\u6563\u7fa4\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    public void createTeam(AuthoredUser user, String owner, String teamName, String bizId, int type, int ifMaster, int visiable, List<String> memberList, String pId, List<Map> externalAccounts, List<Map> externalEocMembers, String businessKey) {
        if (memberList != null && memberList.size() > 0) {
            memberList.removeIf(s -> StringUtils.isEmpty((String)s));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.getImUri() + "/team/createAsync";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("owner", owner);
        paramMap.put("teamName", teamName);
        paramMap.put("bizName", teamName);
        paramMap.put("bizId", bizId);
        paramMap.put("type", type);
        paramMap.put("ifMaster", ifMaster);
        paramMap.put("visible", visiable);
        paramMap.put("memberIds", memberList);
        paramMap.put("pId", pId);
        paramMap.put("source", "atmc");
        if (externalAccounts != null && externalAccounts.size() > 0) {
            paramMap.put("externalAccounts", externalAccounts);
        }
        if (externalEocMembers != null && externalEocMembers.size() > 0) {
            paramMap.put("externalEocMembers", externalEocMembers);
        }
        paramMap.put("businessKey", businessKey);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        System.out.println(responseEntity);
    }

    @Override
    public void addTeamMembers(AuthoredUser user, String bizId, int type, List<String> memberList) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.getImUri() + "/team/addMembers";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bizId", bizId);
        paramMap.put("type", type);
        paramMap.put("memberIds", memberList);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        System.out.println(responseEntity);
    }

    private String getImUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getImUri();
    }
}

