/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.impl;

import com.digiwin.athena.abt.application.aspect.ptm.PtmException;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.HttpAssistantServiceImpl;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogRecordDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardDetailDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardItemDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRecordDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRouteDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmSolveTask;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmSpecialBacklogDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmTaskCardDataDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.TaskActivityItemVO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmActivityRecordDTO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmBacklogItemBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskCardItemBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmWorkItemRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmAgentPerformerDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmTaskCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.ReassignTrace;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class PtmServiceImpl
implements PtmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private HttpAssistantServiceImpl httpAssistantService;

    @Override
    @PtmException
    public PtmProjectRecordBO getProjectRecord(Long projectId) {
        PtmProjectRecordBO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/project?id={projectId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectId", projectId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectRecordBO>>(){}, param);
        result = (PtmProjectRecordBO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public PtmTaskRecordBO getTaskRecord(Long taskId, Long workItemId) {
        PtmTaskRecordBO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task?id={taskId}&workItemId={workItemId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("taskId", taskId);
        param.put("workItemId", workItemId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmTaskRecordBO>>(){}, param);
        result = (PtmTaskRecordBO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmActivityRecordDTO getActivityRecord(Long activityId) {
        PtmActivityRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task/activity?id={activityId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("activityId", activityId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmActivityRecordDTO>>(){}, param);
        result = (PtmActivityRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public PtmBacklogRecordDTO getBacklogRecord(Long backlogId) {
        PtmBacklogRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/item/backlog?id={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmBacklogRecordDTO>>(){}, param);
        result = (PtmBacklogRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public PtmWorkItemRecordBO getWorkItemRecord(Long workItemId) {
        PtmWorkItemRecordBO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/item?id={workItemId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("workItemId", workItemId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmWorkItemRecordBO>>(){}, param);
        result = (PtmWorkItemRecordBO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public List<PtmBacklogItemBO> getBacklogByBacklogId(Long backlogId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/task/list?backlogId={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemBO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public PtmProjectCardRecordDTO getProjectCardRecord(Long projectCardId) {
        PtmProjectCardRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/project/card?id={projectCardId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectCardId", projectCardId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardRecordDTO>>(){}, param);
        result = (PtmProjectCardRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmProjectCardRouteDTO getProjectRoute(Long projectId) {
        PtmProjectCardRouteDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/project/routes?id={projectId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectId", projectId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardRouteDTO>>(){}, param);
        result = (PtmProjectCardRouteDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardDataDTO> getTaskDataByBacklogId(Long backlogId, String type) {
        return this.getTaskData(backlogId, null, null, type);
    }

    @PtmException
    public List<PtmTaskCardDataDTO> getTaskData(Long backlogId, Long activityId, Long taskId, String type) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/data";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        if (Objects.nonNull(backlogId)) {
            rootPara.put("backlogId", backlogId);
        }
        if (Objects.nonNull(activityId)) {
            rootPara.put("activityId", activityId);
        }
        if (Objects.nonNull(taskId)) {
            rootPara.put("taskId", taskId);
        }
        rootPara.put("type", type);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardDataDTO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public List<PtmTaskRecordBO> getTaskRecordByTaskIds(List<Long> taskIds) {
        String url = this.envProperties.getPtmUri() + "api/data/task/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("idList", taskIds);
        rootPara.put("needData", false);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskRecordBO>>>(){}, rootPara);
        List result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public List<PtmActivityRecordDTO> getActivityRecordByActivityIds(List<Long> activityIds) {
        ArrayList<PtmActivityRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("idList", activityIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmActivityRecordDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectRecordBO> getProjectRecordByProjectIds(List<Long> projectIds) {
        return this.getProjectRecordByProjectIdsV2(projectIds, true);
    }

    @Override
    @PtmException
    public List<PtmProjectRecordBO> getProjectRecordByProjectIdsV2(List<Long> projectIds, boolean needData) {
        String url = this.envProperties.getPtmUri() + "api/data/project/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("idList", projectIds);
        rootPara.put("needData", needData);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectRecordBO>>>(){}, rootPara);
        List result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public List<PtmWorkItemRecordBO> getWorkItemRecordByWorkItemIds(List<Long> workItemIds) {
        ArrayList<PtmWorkItemRecordBO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/item/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("idList", workItemIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmWorkItemRecordBO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmSolveTask> getSolveTaskListV2(Long backlogId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "/v2/api/backlog/solve-task/list?backlogId={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmSolveTask>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public List<PtmBacklogItemBO> getBacklogByBacklogIds(List<Long> backlogIdList) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/task/list/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("backlogIds", backlogIdList);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemBO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public PtmWorkItemRecordBO getReExecuteWorkItem(Integer type, Long workItemId, String approvalTaskCode) {
        PtmWorkItemRecordBO result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/previous/item";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("id", workItemId);
        rootPara.put("type", type);
        if (StringUtils.isNotBlank((String)approvalTaskCode)) {
            rootPara.put("taskDefCode", approvalTaskCode);
        }
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmWorkItemRecordBO>>(){}, rootPara);
        result = (PtmWorkItemRecordBO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<Map> getSolveTaskList(List<Long> originalBacklogIds) {
        ArrayList<Map> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/task/card/solve/task-list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("originalBacklogIds", originalBacklogIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    @PtmException
    public PtmProjectCardDetailDTO getProjectCardDetail(Long projectCardId) {
        PtmProjectCardDetailDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/detail?id={projectCardId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectCardId", projectCardId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardDetailDTO>>(){}, param);
        result = (PtmProjectCardDetailDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardItemBO> queryTaskCardListByCodes(List<String> codes) {
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("codes", codes);
        return this.reqPtmTaskCard(rootPara, "api/task/card/processing/simplifyList");
    }

    @Override
    public List<PtmProjectCardItemDTO> queryProjectCardListByCodes(List<String> codes) {
        String url = this.envProperties.getPtmUri() + "api/project/card/processing/simplifyList";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        HashMap<String, List<String>> rootPara = new HashMap<String, List<String>>();
        rootPara.put("codes", codes);
        return this.httpAssistantService.post(new TypeReference<List<PtmProjectCardItemDTO>>(){}, url, headers, rootPara);
    }

    private List<PtmTaskCardItemBO> reqPtmTaskCard(Map<String, Object> params, String reqUrl) {
        List<PtmTaskCardItemBO> result = null;
        String url = this.envProperties.getPtmUri() + reqUrl;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        result = this.httpAssistantService.post(new TypeReference<List<PtmTaskCardItemBO>>(){}, url, headers, params);
        if (result == null) {
            result = new ArrayList<PtmTaskCardItemBO>();
        }
        return result;
    }

    @Override
    public List<ReassignTrace> selectReassignOrHandoverTrace(String workItemId, Integer type) {
        if (StringUtils.isBlank((String)workItemId)) {
            return new ArrayList<ReassignTrace>();
        }
        String url = this.envProperties.getPtmUri() + "/v2/api/workitem/reassign/handover/trace?fromWorkItemId={fromWorkItemId}&traceType={traceType}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("fromWorkItemId", workItemId);
        paramMap.put("traceType", type);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<ReassignTrace>>>(){}, paramMap);
        return (List)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
    }

    @Override
    public List<PtmBacklogRecordDTO> getBacklogRecordByBacklogIds(List<Long> backlogIds) {
        ArrayList<PtmBacklogRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/item/backlog/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("idList", backlogIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogRecordDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardDataDTO> getTaskDataByBacklogIds(List<Map<String, Object>> backlogIds, String type, String isAllQuery) {
        return this.getTaskData(backlogIds, null, null, type, isAllQuery);
    }

    public List<PtmTaskCardDataDTO> getTaskData(List<Map<String, Object>> backlogIds, Long activityId, Long taskId, String type, String isAllQuery) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "v2/api/task/card/data/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        if (Objects.nonNull(backlogIds)) {
            rootPara.put("taskDataRequireKeyModels", backlogIds);
        }
        if (Objects.nonNull(activityId)) {
            rootPara.put("activityId", activityId);
        }
        if (Objects.nonNull(taskId)) {
            rootPara.put("taskId", taskId);
        }
        rootPara.put("type", type);
        rootPara.put("isAllQuery", isAllQuery);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardDataDTO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmSpecialBacklogDTO> getSpecialBacklog(List<Long> workItemIds) {
        if (CollectionUtils.isEmpty(workItemIds)) {
            return null;
        }
        String url = this.envProperties.getPtmUri() + "/api/task/card/derive-cards";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> rootPara = new HashMap<String, List<Long>>();
        rootPara.put("workItemIds", workItemIds);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmSpecialBacklogDTO>>>(){}, rootPara);
        return (List)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
    }

    @Override
    public Map<Long, TaskActivityItemVO> getReExecuteWorkItemByBacklogId(Integer type, Long backlogId, String approvalTaskCode) {
        Map result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/previous/item/byBacklogId";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("backlogId", backlogId);
        rootPara.put("type", type);
        if (StringUtils.isNotBlank((String)approvalTaskCode)) {
            rootPara.put("taskDefCode", approvalTaskCode);
        }
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<Long, TaskActivityItemVO>>>(){}, rootPara);
        result = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectCardItemDTO> queryProjectCardListByProjectCardId(List<Long> projectCardIdList, String autherUserId) {
        return this.queryProjectCard(null, projectCardIdList, autherUserId, false);
    }

    private List<PtmProjectCardItemDTO> queryProjectCard(List<String> userIds, List<Long> projectCardIdList, String autherUserId, Boolean queryTrace) {
        List<PtmProjectCardItemDTO> result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/processing/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("queryProjectCard-authoredUser:{}", (Object)JsonUtils.objectToString((Object)authoredUser));
        headers.add("token", authoredUser.getToken());
        String userId = StringUtils.isBlank((String)autherUserId) ? authoredUser.getUserId() : autherUserId;
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            rootPara.put("userIds", userIds);
        }
        if (CollectionUtils.isNotEmpty(projectCardIdList)) {
            rootPara.put("projectCardIds", projectCardIdList);
        }
        if (Boolean.TRUE.equals(queryTrace)) {
            rootPara.put("queryTrace", queryTrace);
        }
        if ((result = this.httpAssistantService.post(new TypeReference<List<PtmProjectCardItemDTO>>(){}, url, headers, rootPara)) == null) {
            result = new ArrayList<PtmProjectCardItemDTO>();
        }
        return result;
    }

    @Override
    public List<PtmProjectRecordBO> getLastProjectRecordByProjectCardIds(List<Long> projectCardIds) {
        ArrayList<PtmProjectRecordBO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/project/card/processing/latest-project/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> rootPara = new HashMap<String, List<Long>>();
        rootPara.put("projectCardIds", projectCardIds);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectRecordBO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectCardITraceDTO> queryProjectCardTrace(List<Long> list, String userId) {
        List<PtmProjectCardITraceDTO> result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/trace/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("queryProjectCard-authoredUser:{}", (Object)JsonUtils.objectToString((Object)authoredUser));
        headers.add("token", authoredUser.getToken());
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("userId", userId);
        rootPara.put("projectCardIds", list);
        result = this.httpAssistantService.post(new TypeReference<List<PtmProjectCardITraceDTO>>(){}, url, headers, rootPara);
        if (result == null) {
            result = new ArrayList<PtmProjectCardITraceDTO>();
        }
        return result;
    }

    @Override
    public List<PtmTaskCardITraceDTO> queryTaskCardTrace(List<Long> taskCards, String userId) {
        List<PtmTaskCardITraceDTO> result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/trace/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("queryProjectCard-authoredUser:{}", (Object)JsonUtils.objectToString((Object)authoredUser));
        headers.add("token", authoredUser.getToken());
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("userId", userId);
        rootPara.put("taskCardIds", taskCards);
        result = this.httpAssistantService.post(new TypeReference<List<PtmTaskCardITraceDTO>>(){}, url, headers, rootPara);
        if (result == null) {
            result = new ArrayList<PtmTaskCardITraceDTO>();
        }
        return result;
    }

    @Override
    public List<Map<String, String>> queryBacklogIds(List<Long> ids, String type, String code) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        String url = this.envProperties.getPtmUri() + "v2/api/backlog/ids/by-condition-list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("ids", ids);
        rootPara.put("type", type);
        rootPara.put("code", code);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map<String, String>>>>(){}, rootPara);
        return (List)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
    }

    @Override
    @PtmException
    public List<Long> getCompleteAgentBacklog(String agentPerformerId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/agent/backlog?agentPerformId={agentPerformId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("agentPerformId", agentPerformerId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Long>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result == null ? new ArrayList() : result;
    }

    @Override
    @PtmException
    public List<PtmAgentPerformerDTO> queryAgentPerformerList(List<Long> backlogIds) {
        List result = Lists.newArrayList();
        String url = this.envProperties.getPtmUri() + "/v2/api/workitem/performerInfo/by/backlogIds";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        headers.add("routerKey", authoredUser.getTenantId());
        HashMap param = Maps.newHashMap();
        param.put("backlogIds", backlogIds);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmAgentPerformerDTO>>>(){}, (Map)param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }
}

