/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmAppDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmApplication;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmAssignConfigDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmDataState;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.enums.AtmcErrorCodeEnum;
import com.digiwin.athena.abt.core.uiils.BusinessExceptionUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.sf.json.JSONArray;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ThemeMapServiceImpl
implements ThemeMapService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThemeMapServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public Map getActivityAction2(String tmTaskId, String tmActivityId, String pageCode) {
        Map result = null;
        String uri = this.envProperties.getDataMapUri() + "/restful/standard/datamap/task/activityDefinitionWithMergeRule?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);
        try {
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, param);
            result = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            return result;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    @Override
    public TmActivityResponseDTO getActivityAction(String tmTaskId, String tmActivityId, String pageCode) {
        TmActivityResponseDTO result = null;
        String uri = this.envProperties.getDataMapUri() + "/restful/standard/datamap/task/activityDefinitionWithMergeRule?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";
        if ("__uibot__".equals(tmTaskId)) {
            uri = this.envProperties.getDataMapUri() + "/restful/standard/datamap/record/activityDefinition?activityId={activityId}&pageCode={pageCode}";
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmActivityResponseDTO>>(){}, param);
            BaseResultDTO resultDTO = (BaseResultDTO)respEntity.getBody();
            if (resultDTO == null) {
                throw AtmcErrorCodeEnum.KM_RTN_ERROR.getBusinessExceptionWithArgs(new Object[]{tmActivityId});
            }
            if (!resultDTO.isOK()) {
                throw BusinessExceptionUtils.getBusinessException((Integer)respEntity.getStatusCodeValue(), (String)resultDTO.getErrorCode(), (Object)resultDTO.getErrorMessage(), (String)uri, null);
            }
            result = (TmActivityResponseDTO)resultDTO.getResponse();
        }
        catch (RestClientException ex) {
            if (ex.getCause() instanceof HttpMessageConversionException) {
                throw AtmcErrorCodeEnum.KM_RTN_ERROR.getBusinessExceptionWithArgs(new Object[]{tmActivityId});
            }
            throw ex;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
        if (result != null) {
            if (result.getPages() != null && CollectionUtils.isNotEmpty(result.getPages().getDataStates()) && result.getPages().getDataStates().size() > 0) {
                TmDataState dataState = result.getPages().getDataStates().get(0);
                result.getPages().setCardCache(dataState.getCardCache());
            }
            if (result.getPages() != null && result.getPages().getCardCache() == null) {
                result.getPages().setCardCache(true);
            }
            if (result.getAssignAble() == null) {
                result.setAssignAble(true);
            }
            if (Objects.equals(result.getAssignAble(), Boolean.TRUE) && result.getAssignConfig() == null) {
                TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder().assignAble(result.getAssignAble()).assignTo(result.getAssignTo()).build();
                result.setAssignConfig(assignConfig);
            }
        } else {
            throw AtmcErrorCodeEnum.KM_RTN_NULL.getBusinessExceptionWithArgs(new Object[]{tmActivityId});
        }
        return result;
    }

    @Override
    public String getActivityTargetCode(String tmTaskId, String tmActivityId, String pageCode) {
        TmActivityResponseDTO result = new TmActivityResponseDTO();
        String uri = this.envProperties.getDataMapUri() + "/restful/standard/datamap/task/activityStartTargetCode?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmActivityResponseDTO>>(){}, param);
            result = (TmActivityResponseDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
        if (result != null) {
            return result.getTargetApproveActivity();
        }
        return null;
    }

    @Override
    public Map executeFormula(String formulaId) {
        Map result = null;
        String uri = this.envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/tenantSettings/formula?formulaId={formulaId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formulaId", formulaId);
        try {
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, param);
            result = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            return result;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    @Override
    public TmTaskDefineResponseDTO getTask(String taskId) {
        TmTaskDefineResponseDTO result = null;
        String uri = this.envProperties.getDataMapUri() + "/restful/standard/datamap/task/definitionByTaskId?taskId={taskId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", taskId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmTaskDefineResponseDTO>>(){}, param);
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
        result = (TmTaskDefineResponseDTO)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
        if (result != null) {
            if (result.getMerge() == null) {
                result.setMerge(true);
            }
            if (result.getAssignAble() == null) {
                result.setAssignAble(true);
            }
            if (Objects.equals(result.getAssignAble(), Boolean.TRUE) && result.getAssignConfig() == null) {
                TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder().assignAble(result.getAssignAble()).assignTo(result.getAssignTo()).build();
                result.setAssignConfig(assignConfig);
            }
        }
        return result;
    }

    @Override
    public JSONArray getTmTaskAndActivityBk(String objectType, String objectValue, AuthoredUser user) {
        JSONArray result = null;
        String url = "";
        try {
            net.sf.json.JSONObject jsonObject;
            url = this.envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/view/bk";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            log.info("current user: " + user);
            if (null == user) {
                headers.set("token", this.getToken());
                log.info(" context token: " + this.getToken());
            } else {
                headers.set("token", user.getToken());
            }
            HashMap<String, String> paramDetailMap = new HashMap<String, String>();
            paramDetailMap.put("objectType", objectType);
            paramDetailMap.put("objectValue", objectValue);
            HashMap<String, HashMap<String, String>> paramMap = new HashMap<String, HashMap<String, String>>();
            paramMap.put("request", paramDetailMap);
            HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, BaseResultDTO.class, new Object[0]);
            Object response = ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            if (response != null && (jsonObject = (net.sf.json.JSONObject)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)response), net.sf.json.JSONObject.class)).containsKey((Object)"bkInfo")) {
                result = jsonObject.getJSONArray("bkInfo");
            }
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
        return result;
    }

    @Override
    public List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList) {
        String url = this.envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/applicationRelation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("codes", codeList);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>(){}, new Object[0]);
            log.info("[getAppInfoByCodeAndType]  type = {}, codes = {}, result = {}", new Object[]{type, JsonUtils.objectToString(codeList), JsonUtils.objectToString((Object)respEntity)});
        }
        catch (Exception e) {
            log.error("[getAppInfoByCodeAndType] execute km [knowledgegraph/task/applicationRelation] fail, error = {}", (Object)e.getMessage());
        }
        if (null != respEntity && null != respEntity.getBody()) {
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        return null;
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }

    private String getToken() {
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        }
        return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
    }

    @Override
    public String getTaskNamesByCodes(String code) {
        List tasks;
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(code);
        String url = this.envProperties.getDataMapUri() + "/restful/standard/datamap/view/taskNamesByCodes";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap params = new HashMap();
        HashMap<String, ArrayList<String>> query = new HashMap<String, ArrayList<String>>();
        query.put("code", codes);
        params.put("query", query);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
            log.info("[getTaskName]  codes = {}, result = {}", (Object)JsonUtils.objectToString(codes), (Object)JsonUtils.objectToString((Object)respEntity));
        }
        catch (Exception e) {
            log.error("[getTaskName] execute datamap [/view/taskNamesByCodes] fail, error = {}", (Object)e.getMessage());
        }
        if (null != respEntity && null != respEntity.getBody() && !(tasks = (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("")).isEmpty()) {
            Map map = (Map)tasks.get(0);
            return JSON.toJSONString((Object)JSONPath.eval((Object)map, (String)"$.lang.name"));
        }
        return null;
    }

    @Override
    public String getProjectNamesByCodes(String code) {
        List tasks;
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(code);
        String url = this.envProperties.getDataMapUri() + "/restful/standard/datamap/view/projectNamesByCodes";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap params = new HashMap();
        HashMap<String, ArrayList<String>> query = new HashMap<String, ArrayList<String>>();
        query.put("code", codes);
        params.put("query", query);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
            log.info("[getTaskName]  codes = {}, result = {}", (Object)JsonUtils.objectToString(codes), (Object)JsonUtils.objectToString((Object)respEntity));
        }
        catch (Exception e) {
            log.error("[getTaskName] execute datamap [/view/taskNamesByCodes] fail, error = {}", (Object)e.getMessage());
        }
        if (null != respEntity && null != respEntity.getBody() && !(tasks = (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("")).isEmpty()) {
            Map map = (Map)tasks.get(0);
            return JSON.toJSONString((Object)JSONPath.eval((Object)map, (String)"$.lang.name"));
        }
        return null;
    }

    @Override
    public List<TmTaskDefineResponseDTO> getBatchTaskAssigns(List<String> taskCodes) {
        List result = null;
        String url = this.envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/batch/taskBasic";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap rootPara = new HashMap();
        HashMap<String, List<String>> qPara = new HashMap<String, List<String>>();
        qPara.put("codes", taskCodes);
        rootPara.put("q", qPara);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmTaskDefineResponseDTO>>>(){}, rootPara);
            result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            result.forEach(x -> {
                if (x.getAssignAble() == null) {
                    x.setAssignAble(true);
                }
                if (Objects.equals(x.getAssignAble(), Boolean.TRUE) && x.getAssignConfig() == null) {
                    TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder().assignAble(x.getAssignAble()).assignTo(x.getAssignTo()).build();
                    x.setAssignConfig(assignConfig);
                }
            });
        }
        return result;
    }

    @Override
    public Map<String, Object> postCardConfigByType(JSONObject jsonObject) {
        String url = this.envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/cardConfigByType";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", this.getToken());
        Map<String, Object> result = new HashMap<String, Object>();
        HashMap<String, JSONObject> body = new HashMap<String, JSONObject>();
        body.put("cardConfigQuery", jsonObject);
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            JSONObject respJson = (JSONObject)this.restTemplate.postForObject(url, (Object)requestEntity, JSONObject.class, new Object[0]);
            Map map = (Map)JsonUtils.jsonToObject((String)respJson.toJSONString(0), (TypeReference)new TypeReference<Map<String, Object>>(){});
            result = (Map)map.get("response");
            return result;
        }
        catch (Exception e) {
            log.error("\u3010km server error\u3011:{}", (Throwable)e);
            return result;
        }
    }

    @Override
    public List<TmActivityResponseDTO> getBatchActivityAssigns(List<Map> activities) {
        List result = null;
        String url = this.envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/batch/activityBasic";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap rootPara = new HashMap();
        HashMap<String, List<Map>> qPara = new HashMap<String, List<Map>>();
        qPara.put("taskAndActivities", activities);
        rootPara.put("q", qPara);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmActivityResponseDTO>>>(){}, rootPara);
            result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            result.forEach(x -> {
                if (x.getAssignAble() == null) {
                    x.setAssignAble(true);
                }
                if (Objects.equals(x.getAssignAble(), Boolean.TRUE) && x.getAssignConfig() == null) {
                    TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder().assignAble(x.getAssignAble()).assignTo(x.getAssignTo()).build();
                    x.setAssignConfig(assignConfig);
                }
            });
        }
        return result;
    }

    @Override
    public Map<String, Object> getTaskCardOptimizeRules() {
        String getAppIdUrl = this.envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/cardConfig";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, Object> result = new HashMap<String, Object>();
        HashMap param = new HashMap();
        try {
            Object response;
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity entryResp = this.restTemplate.exchange(getAppIdUrl, HttpMethod.GET, httpEntity, Map.class, param);
            if (entryResp.getStatusCode() == HttpStatus.OK && null != entryResp.getBody() && (response = ((Map)entryResp.getBody()).get("response")) != null && response != "") {
                result = (Map)response;
            }
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)getAppIdUrl, (Object)e);
            throw e;
        }
        return result;
    }

    @Override
    public Map<String, List<String>> getActivityDefinitionList(List<String> list) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        String url = this.envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/activityDefinitionList";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", this.getToken());
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("taskId", "");
        body.put("activityIds", list);
        body.put("pageCode", "task-card");
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            BaseResultDTO resultDTO = (BaseResultDTO)respEntity.getBody();
            if (!resultDTO.isOK()) {
                throw BusinessExceptionUtils.getBusinessException((Integer)respEntity.getStatusCodeValue(), (String)resultDTO.getErrorCode(), (Object)resultDTO.getErrorMessage(), (String)url, null);
            }
            Map map = (Map)resultDTO.getResponse();
            list.forEach(el -> {
                Object o = map.get(el);
                JSONObject activityDefinition = JSONUtil.parseObj(o);
                JSONObject jsonObject = JSONUtil.parseObj((Object)activityDefinition.get((Object)"pages"));
                cn.hutool.json.JSONArray jsonArray = JSONUtil.parseArray((Object)jsonObject.get((Object)"dataStates"));
                JSONObject dataState = jsonArray.stream().map(e -> (JSONObject)e).filter(e -> e.get((Object)"type") != null).filter(e -> "all".equals(e.get((Object)"type").toString())).findFirst().get();
                JSONObject taskCardFields = JSONUtil.parseObj((Object)dataState.get((Object)"taskCardFields"));
                String dateSourceName = taskCardFields.getStr((Object)"dateSourceName") == null ? taskCardFields.getStr((Object)"dataSourceName") : taskCardFields.getStr((Object)"dateSourceName");
                JSONObject dataSources = JSONUtil.parseObj((Object)activityDefinition.get((Object)"dataSources"));
                Object dataSource = dataSources.get((Object)dateSourceName);
                JSONObject datasourceJson = JSONUtil.parseObj((Object)dataSource);
                cn.hutool.json.JSONArray actionParams = JSONUtil.parseArray((Object)datasourceJson.get((Object)"actionParams"));
                ArrayList<String> objects = new ArrayList<String>();
                Optional<Object> optional = actionParams.stream().filter(e -> "PROCESS_VARIABLE".equals(((JSONObject)e).get((Object)"type"))).findFirst();
                if (optional.isPresent()) {
                    JSONObject actionParam = JSONUtil.parseObj((Object)optional.get());
                    String value = actionParam.getStr((Object)"value");
                    objects.add(value);
                    result.put((String)el, (List<String>)objects);
                }
            });
            return result;
        }
        catch (Exception e) {
            log.error("get activity error\uff1a" + e.getMessage());
            e.printStackTrace();
            return result;
        }
    }

    @Override
    public String getAppCode(String type, String code) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("code", code);
        paramMap.put("type", type);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", this.getToken());
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/app/applicationByTypeAndCode?type={type}&code={code}";
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmApplication>>(){}, paramMap);
            TmApplication tmApplication = (TmApplication)((BaseResultDTO)response.getBody()).getResponseWithException("");
            if (null != tmApplication) {
                return tmApplication.getApplication();
            }
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
        }
        return null;
    }
}

