/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.atmc.migration.tenantToken.impl;

import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.TenantService;
import com.digiwin.athena.abt.application.service.atmc.migration.tenantToken.TenantTokenService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TenantTokenServiceImpl
implements TenantTokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantTokenServiceImpl.class);
    private final String TENANT_VIRTUAL_TOKEN_PREFIX = "atmc:cache:tenant:virtualToken:";
    @Autowired
    private TenantService tenantService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public String queryVirtualToken(String tenantId) {
        try {
            String virtualToken = this.getCacheVirtualToken(tenantId);
            if (StringUtils.isEmpty((Object)virtualToken)) {
                JSONObject apiResult = this.tenantService.queryApiVirtualToken(tenantId);
                if (apiResult.isEmpty() || !apiResult.containsKey((Object)"token")) {
                    return null;
                }
                long virtualExpireInitial = apiResult.getLong("tokenExpiresIn");
                long cacheExpire = virtualExpireInitial < 10000L ? virtualExpireInitial : virtualExpireInitial / 10L;
                virtualToken = apiResult.getString("token");
                this.stringRedisTemplate.opsForValue().set((Object)("atmc:cache:tenant:virtualToken:" + tenantId), (Object)virtualToken, cacheExpire / 1000L, TimeUnit.SECONDS);
            }
            return virtualToken;
        }
        catch (Exception e) {
            log.warn("QueryVirtualToken error", (Throwable)e);
            return null;
        }
    }

    private String getCacheVirtualToken(String tenantId) {
        String virtualTokenKey = "atmc:cache:tenant:virtualToken:" + tenantId;
        if (Boolean.FALSE.equals(this.stringRedisTemplate.hasKey((Object)virtualTokenKey))) {
            return null;
        }
        return (String)this.stringRedisTemplate.opsForValue().get((Object)virtualTokenKey);
    }
}

