/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.utils;

public class AtmcStrUtil {
    public static String parse(String openToken, String closeToken, String text, Object ... args) {
        if (args == null || args.length <= 0) {
            return text;
        }
        int argsIndex = 0;
        if (text == null || text.isEmpty()) {
            return "";
        }
        char[] src = text.toCharArray();
        int offset = 0;
        int start = text.indexOf(openToken, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    offset = end + closeToken.length();
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    String value = argsIndex <= args.length - 1 ? (args[argsIndex] == null ? "" : args[argsIndex].toString()) : expression.toString();
                    builder.append(value);
                    offset = end + closeToken.length();
                    ++argsIndex;
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public static String format(String text, Object ... args) {
        return AtmcStrUtil.parse("{", "}", text, args);
    }

    public static void main(String[] args) {
        String tenantId = "1";
        String format = AtmcStrUtil.format("/api/aim/v1/misc/message/deleteByTenant/{tenantId}", tenantId);
        System.out.println(format);
    }
}

