/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardActivityDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardInfoDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardItemDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    public static final String SUMMARY_LAYOUT = "summaryLayout";
    public static final String HISTORY_MESSAGE = "historyMessage";
    public static final String SEARCH_MESSAGE = "searchMessage";
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);

    public static <T> List<List<T>> spliceArrays(List<T> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return null;
        }
        int totalSize = datas.size();
        int count = totalSize % splitSize == 0 ? totalSize / splitSize : totalSize / splitSize + 1;
        ArrayList<List<T>> rows = new ArrayList<List<T>>(splitSize);
        for (int i = 0; i < count; ++i) {
            List<T> cols = datas.subList(i * splitSize, i == count - 1 ? totalSize : splitSize * (i + 1));
            rows.add(cols);
        }
        return rows;
    }

    public static List<Integer> split(String value, String split) {
        String[] arr = value.split(split);
        ArrayList<Integer> strList = new ArrayList<Integer>(arr.length);
        for (String s : arr) {
            strList.add(Integer.parseInt(s));
        }
        return strList;
    }

    public static boolean isNoBk(String active) {
        return !"bk".equals(active);
    }

    public static String getActivityMessageStr(CardInfoDto cardInfoDto) {
        return CommonUtils.getActivityMessageStr(cardInfoDto, Maps.newHashMap());
    }

    public static String getActivityMessageStr(String activityMessage, Long activityId, Map<String, Object> cardData) {
        if (activityId != null && cardData != null) {
            CardActivityDto cardActivity = CommonUtils.getCardActivity(activityMessage);
            CardInfoDto cardInfoDto = new CardInfoDto();
            cardInfoDto.setCardItemList(Lists.newArrayList((Object[])new CardItemDto[]{new CardItemDto(activityId, cardData)}));
            return cardActivity == null ? CommonUtils.getActivityMessageStr(cardInfoDto) : CommonUtils.getActivityMessageStr(cardInfoDto, cardActivity.getActivityMsg());
        }
        return activityMessage;
    }

    public static CardActivityDto getCardActivity(String activityMessage) {
        if (StringUtils.isNotEmpty((String)activityMessage)) {
            try {
                return (CardActivityDto)JsonUtils.jsonToObject((String)activityMessage, CardActivityDto.class);
            }
            catch (Exception var2) {
                log.warn("\u8f6c\u6362\u6d3b\u52a8\u7ea7\u6458\u8981\u4fe1\u606f\u9519\u8bef:{},\u539f:{}", (Object)var2.getMessage(), (Object)activityMessage);
            }
        }
        return null;
    }

    public static String getActivityMessageStr(CardInfoDto cardInfoDto, Map<Long, Map<String, Set<String>>> activityMsg) {
        List<CardItemDto> cardItemList = cardInfoDto.getCardItemList();
        if (CollectionUtils.isEmpty(cardItemList) || activityMsg == null) {
            return null;
        }
        for (CardItemDto cardItemDto : cardItemList) {
            Long activityId = cardItemDto.getActivityId();
            if (activityId == null) continue;
            Map map = activityMsg.computeIfAbsent(cardItemDto.getActivityId(), e -> new HashMap());
            Map<String, Object> cardInfo = cardItemDto.getCardInfo();
            CommonUtils.addCardText(map, cardInfo, SUMMARY_LAYOUT);
            CommonUtils.addCardText(map, cardInfo, HISTORY_MESSAGE);
            CommonUtils.addCardText(map, cardInfo, SEARCH_MESSAGE);
        }
        CardActivityDto cardActivityDto = new CardActivityDto();
        cardActivityDto.setActivityMsg(activityMsg);
        return JsonUtils.objectToString((Object)cardActivityDto);
    }

    private static void addCardText(Map<String, Set<String>> map, Map<String, Object> cardInfo, String key) {
        Set textList = map.computeIfAbsent(key, e -> new HashSet());
        String summaryText = MapUtils.getString(cardInfo, (Object)key);
        if (StringUtils.isNotBlank((String)summaryText)) {
            String[] split;
            for (String s : split = summaryText.split("<br>")) {
                String[] dataSplit;
                String[] rowSplit = s.split("\uff1a");
                if (rowSplit.length > 1) {
                    dataSplit = rowSplit[1].split(",");
                    textList.add(rowSplit[0]);
                } else {
                    dataSplit = rowSplit[0].split(",");
                }
                textList.addAll(Arrays.asList(dataSplit));
            }
        }
    }

    public static Map<String, Object> getCardMap(String summary, String history, String search) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put(SUMMARY_LAYOUT, summary);
        map.put(HISTORY_MESSAGE, history);
        map.put(SEARCH_MESSAGE, search);
        return map;
    }

    public static void addDepData(Map<String, Object> row, LinkedHashSet<Object> list, String[] paths, int level) {
        Object o = row.get(paths[level]);
        if (level >= paths.length - 1) {
            if (o != null) {
                list.add(o);
            }
        } else {
            List dRows;
            int nextLevel = level + 1;
            if (o instanceof Map) {
                CommonUtils.addDepData((Map)o, list, paths, nextLevel);
            } else if (o instanceof List && CollectionUtils.isNotEmpty((Collection)(dRows = (List)o))) {
                for (Map dRow : dRows) {
                    CommonUtils.addDepData(dRow, list, paths, nextLevel);
                }
            }
        }
    }
}

