/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.appcore.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentSubmitUtils {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentSubmitUtils.class);
    private final List<Future> futureList = new ArrayList<Future>();
    private final ExecutorService executorService;

    public ConcurrentSubmitUtils(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public static ConcurrentSubmitUtils build(ExecutorService executorService) {
        return new ConcurrentSubmitUtils(executorService);
    }

    public ConcurrentSubmitUtils addCollections(Runnable task) {
        this.futureList.add(this.executorService.submit(task));
        return this;
    }

    public void getCollectionsWithTimeout(long timeout, TimeUnit timeUnit) {
        try {
            log.info("futureList.size\uff1a" + this.futureList.size());
            for (Future objectFuture : this.futureList) {
                objectFuture.get(timeout, timeUnit);
            }
        }
        catch (InterruptedException e) {
            e.getStackTrace();
            log.warn("[ConcurrentSubmit InterruptedException] error:{}, stack:{}", (Object)e, (Object)e.getStackTrace());
            Thread.currentThread().interrupt();
            throw BusinessException.create((String)e.getMessage());
        }
        catch (ExecutionException e) {
            e.getStackTrace();
            log.warn("[ConcurrentSubmit ExecutionException] error:{}, stack:{}", (Object)e, (Object)e.getStackTrace());
            throw BusinessException.create((String)e.getMessage());
        }
        catch (TimeoutException e) {
            e.getStackTrace();
            this.futureList.forEach(future -> future.cancel(true));
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }
}

