/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.application.dto.migration.abt.excel.CellTypeHolder;
import com.digiwin.athena.abt.application.dto.migration.abt.excel.ExcelParserBean;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.ExcelTypeEnum;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class ExcelUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    public static final int ENUM_PROMPT_LENGTH_LIMIT = 255;
    public static final String MAIN_SHEET_NAME = "sheet1";

    private static String handleLocale(String locale) {
        if (StringUtils.isEmpty((String)locale)) {
            return "zh_CN";
        }
        if (locale.equals("en")) {
            return "en_US";
        }
        return locale;
    }

    public static XSSFRichTextString addRequiredMark(XSSFWorkbook wb, String s, Font cellFont) {
        XSSFFont font = wb.createFont();
        font.setColor((short)10);
        font.setBold(true);
        XSSFRichTextString str = new XSSFRichTextString("*" + s);
        str.applyFont(0, 1, (Font)font);
        if (1 < str.getString().length()) {
            str.applyFont(1, str.length(), cellFont);
        }
        return str;
    }

    public static void excelRuleStringLength(String locale, Sheet sheet, int min, int max, int firstRow, int lastRow, int firstCol, int lastCol) {
        ExcelUtil.excelRuleStringLengthWithAnnotation(locale, sheet, min, max, firstRow, lastRow, firstCol, lastCol, "");
    }

    public static void excelRuleStringLengthWithAnnotation(String locale, Sheet sheet, int min, int max, int firstRow, int lastRow, int firstCol, int lastCol, String annotationStr) {
        locale = ExcelUtil.handleLocale(locale);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createNumericConstraint(6, 0, String.valueOf(min), String.valueOf(max));
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        String title = MessageUtil.getMessageByLocale("excel.string.title.length", locale, max);
        String content = MessageUtil.getMessageByLocale("excel.string.content.length", locale, max);
        if (StringUtils.isNotEmpty((String)annotationStr)) {
            title = "";
            content = annotationStr;
        }
        dataValidation.createPromptBox(title, content);
        dataValidation.createErrorBox(title, content);
        dataValidation.setShowErrorBox(true);
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static void excelRuleDateFormat(String locale, Sheet sheet, String start, String end, String format, int firstRow, int lastRow, int firstCol, int lastCol) {
        ExcelUtil.excelRuleDateFormatWithAnnotation(locale, sheet, start, end, format, firstRow, lastRow, firstCol, lastCol, "");
    }

    public static void excelRuleDateFormatWithAnnotation(String locale, Sheet sheet, String start, String end, String format, int firstRow, int lastRow, int firstCol, int lastCol, String annotationStr) {
        locale = ExcelUtil.handleLocale(locale);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createDateConstraint(6, start, end, format);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        String content = MessageUtil.getMessageByLocale("excel.date.content.enterCorrect", locale, format);
        if (StringUtils.isNotEmpty((String)annotationStr)) {
            content = annotationStr;
        }
        dataValidation.createPromptBox("", content);
        dataValidation.createErrorBox(MessageUtil.getMessageByLocale("excel.date.title.enterCorrect", locale, new Object[0]), content);
        dataValidation.setShowErrorBox(true);
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static void excelRuleSelect(String locale, Sheet sheet, String[] rule, int firstRow, int lastRow, int firstCol, int lastCol) {
        ExcelUtil.excelRuleSelectWithAnnotation(locale, sheet, rule, firstRow, lastRow, firstCol, lastCol, "");
    }

    public static void excelRuleSelectWithAnnotation(String locale, Sheet sheet, String[] rule, int firstRow, int lastRow, int firstCol, int lastCol, String annotationStr) {
        locale = ExcelUtil.handleLocale(locale);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createExplicitListConstraint(rule);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        String itemStr = MessageUtil.getMessageByLocale("excel.select.item.selectCorrect", locale, Arrays.asList(rule).toString());
        String title = MessageUtil.getMessageByLocale("excel.select.title.selectCorrect", locale, new Object[0]);
        String content = MessageUtil.getMessageByLocale("excel.select.content.selectCorrect", locale, Arrays.asList(rule).toString());
        if (StringUtils.isNotEmpty((String)annotationStr)) {
            itemStr = annotationStr;
            content = annotationStr;
        }
        dataValidation.createPromptBox("", itemStr);
        dataValidation.createErrorBox(title, content);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static void excelEnumRuleSelect(String locale, Sheet sheet, String[] rule, int firstRow, int lastRow, int firstCol, int lastCol, String annotationStr) {
        locale = ExcelUtil.handleLocale(locale);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createExplicitListConstraint(rule);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        String itemByLocale = Optional.ofNullable(MessageUtil.getMessageByLocale("excel.select.item.selectCorrect", locale, "")).orElse("");
        String itemStr = MessageUtil.getMessageByLocale("excel.select.item.selectCorrect", locale, ExcelUtil.toStringWithLimit(rule, 255 - itemByLocale.length()));
        String title = MessageUtil.getMessageByLocale("excel.select.title.selectCorrect", locale, new Object[0]);
        String contentByLocale = Optional.ofNullable(MessageUtil.getMessageByLocale("excel.select.content.selectCorrect", locale, "")).orElse("");
        String content = MessageUtil.getMessageByLocale("excel.select.content.selectCorrect", locale, ExcelUtil.toStringWithLimit(rule, 255 - contentByLocale.length()));
        if (StringUtils.isNotEmpty((String)annotationStr)) {
            itemStr = annotationStr;
            content = annotationStr;
        }
        dataValidation.createPromptBox(null, itemStr);
        dataValidation.createErrorBox(title, content);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    private static String toStringWithLimit(String[] array, int limit) {
        limit -= 2;
        String arrayString = Arrays.toString(array);
        arrayString = arrayString.substring(1, arrayString.length() - 1);
        while (arrayString.length() > limit) {
            array = Arrays.copyOf(array, array.length - 1);
            arrayString = Arrays.toString(array);
            arrayString = arrayString.substring(1, arrayString.length() - 1);
        }
        return "[" + arrayString + "]";
    }

    public static void excelRuleIsNumber(String locale, Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        ExcelUtil.excelRuleIsNumberWithAnnotation(locale, sheet, firstRow, lastRow, firstCol, lastCol, "");
    }

    public static void excelRuleIsNumberWithAnnotation(String locale, Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, String annotationStr) {
        locale = ExcelUtil.handleLocale(locale);
        String isNumber = "=ISNUMBER(INDIRECT(ADDRESS(ROW(),COLUMN())))";
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createCustomConstraint(isNumber);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        dataValidation.createPromptBox("", StringUtils.isNotEmpty((String)annotationStr) ? annotationStr : MessageUtil.getMessageByLocale("excel.number.content.isNumber", locale, new Object[0]));
        dataValidation.createErrorBox(MessageUtil.getMessageByLocale("excel.number.title.isNumber", locale, new Object[0]), StringUtils.isNotEmpty((String)annotationStr) ? annotationStr : MessageUtil.getMessageByLocale("excel.number.content.isNumber", locale, new Object[0]));
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        dataValidation.setShowErrorBox(true);
        dataValidation.setShowPromptBox(true);
        dataValidation.setEmptyCellAllowed(true);
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setErrorStyle(0);
        sheet.addValidationData(dataValidation);
    }

    public static void setDefaultExcelType(ExcelParserBean parserBean) {
        String filePath = parserBean.getFilePath();
        String fileExtension = ExcelUtil.getFileExtension(filePath);
        ExcelTypeEnum excelType = parserBean.getExcelType();
        if (excelType == null && fileExtension == null) {
            excelType = ExcelTypeEnum.XLS;
        } else if (excelType == null && fileExtension != null) {
            if (fileExtension.equalsIgnoreCase(ExcelTypeEnum.XLS.name())) {
                excelType = ExcelTypeEnum.XLS;
            } else if (fileExtension.equalsIgnoreCase(ExcelTypeEnum.XLSX.name())) {
                excelType = ExcelTypeEnum.XLSX;
            }
        }
        parserBean.setExcelType(excelType);
    }

    public static Workbook createWorkbook(ExcelParserBean parserBean) {
        Object wb = null;
        ExcelTypeEnum excelType = parserBean.getExcelType();
        try {
            wb = ExcelTypeEnum.XLS.equals((Object)excelType) ? new HSSFWorkbook(parserBean.getInput()) : (ExcelTypeEnum.XLSX.equals((Object)excelType) ? new XSSFWorkbook(parserBean.getInput()) : new HSSFWorkbook(parserBean.getInput()));
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return wb;
    }

    public static List<Map> readDataForImport(Sheet sheet, List<ApiDataFieldLocaleMetadataDTO> apiDataFieldLocaleMetadataDTOS) {
        Map<String, Integer[]> map = ExcelUtil.getMergedRegionMap(sheet);
        Sheet sheetExcepNullRow = ExcelUtil.getAccuracyContextNum(sheet, map);
        if (CollectionUtils.isEmpty(apiDataFieldLocaleMetadataDTOS)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0086.getErrCode(), (String)MessageUtil.getMessage("basedata.apiNoDF", new Object[0]));
        }
        Map<String, String> metaMap = apiDataFieldLocaleMetadataDTOS.stream().collect(Collectors.toMap(ApiDataFieldLocaleMetadataDTO::getData_name, ApiDataFieldLocaleMetadataDTO::getData_type, (item1, item2) -> item1));
        LinkedList<CellTypeHolder> cellTypeHolders = new LinkedList<CellTypeHolder>();
        LinkedList<String> headerKeys = new LinkedList<String>();
        Row headRow2 = sheetExcepNullRow.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow2.getCell(cellStartIdx)) {
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            headerKeys.add(key);
            ++cellStartIdx;
        }
        block5: for (int i = 0; i < headerKeys.size(); ++i) {
            if (null == metaMap.get(headerKeys.get(i))) continue;
            CellTypeHolder cellTypeHolder = new CellTypeHolder();
            cellTypeHolder.setHeaderKey((String)headerKeys.get(i));
            cellTypeHolder.setIndex(i);
            cellTypeHolder.setMetaDataType(MetaDataType.valueOf((String)metaMap.get(headerKeys.get(i)).toUpperCase()));
            switch (MetaDataType.valueOf((String)metaMap.get(headerKeys.get(i)).toUpperCase())) {
                case NUMERIC: 
                case NUMBER: {
                    cellTypeHolder.setCellType(CellType.NUMERIC);
                    cellTypeHolders.add(cellTypeHolder);
                    continue block5;
                }
                case BOOLEAN: {
                    cellTypeHolder.setCellType(CellType.BOOLEAN);
                    cellTypeHolders.add(cellTypeHolder);
                    continue block5;
                }
                default: {
                    cellTypeHolder.setCellType(CellType.STRING);
                    cellTypeHolders.add(cellTypeHolder);
                }
            }
        }
        if (CollectionUtils.isEmpty(cellTypeHolders)) {
            log.error("\u89e3\u6790Excel\u7684\u680f\u4f4d\u4e3a\u7a7a\uff01");
            log.info("messages:{},local:{}", (Object)MessageUtil.getMessageByLocale("upload.template.error", LocaleContextHolder.getLocale().toString(), new Object[0]), (Object)LocaleContextHolder.getLocale().toString());
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0116.getErrCode(), (String)MessageUtil.getMessageByLocale("upload.template.error", LocaleContextHolder.getLocale().toString(), new Object[0]));
        }
        LinkedList<Map> data = new LinkedList<Map>();
        int rowStartIdx = 2;
        while (null != sheetExcepNullRow.getRow(rowStartIdx)) {
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
            Row row = sheetExcepNullRow.getRow(rowStartIdx);
            for (int i = 0; i < cellTypeHolders.size(); ++i) {
                CellTypeHolder cellTypeHolder = (CellTypeHolder)cellTypeHolders.get(i);
                Cell cell = row.getCell(cellTypeHolder.getIndex());
                Object cellObj = null;
                if (cell != null) {
                    cellObj = ExcelUtil.parseCell(cell, cellTypeHolder.getCellType(), cellTypeHolder.getMetaDataType());
                }
                rowData.put(cellTypeHolder.getHeaderKey(), cellObj);
            }
            data.add(rowData);
            ++rowStartIdx;
        }
        return data;
    }

    public static Map<String, Integer[]> getMergedRegionMap(Sheet sheet) {
        HashMap<String, Integer[]> result = new HashMap<String, Integer[]>();
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            Integer[] firstRowNumberAndCellNumber = new Integer[]{firstRow, firstColumn};
            for (int currentRowNumber = firstRow; currentRowNumber <= lastRow; ++currentRowNumber) {
                for (int currentCellNumber = firstColumn; currentCellNumber <= lastColumn; ++currentCellNumber) {
                    result.put(currentRowNumber + "_" + currentCellNumber, firstRowNumberAndCellNumber);
                }
            }
        }
        return result;
    }

    public static Sheet getAccuracyContextNum(Sheet sheetOld, Map<String, Integer[]> mergedRegionMap) {
        Sheet sheet = sheetOld;
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                int lastRowNum = sheet.getLastRowNum();
                if (i >= 0 && i < lastRowNum) {
                    sheet.shiftRows(i + 1, lastRowNum, -1);
                }
                --i;
                continue;
            }
            int cellNum = row.getLastCellNum();
            boolean flag = false;
            for (int j = 0; j < cellNum; ++j) {
                Integer[] firstRowNumberAndCellNumber = mergedRegionMap.get(i + "_" + j);
                if (firstRowNumberAndCellNumber == null) continue;
                flag = true;
            }
            if (!ExcelUtil.isRowEmpty(row) || flag || !ExcelUtil.isRowEmpty(row)) continue;
            int lastRowNum = sheet.getLastRowNum();
            if (i >= 0 && i < lastRowNum) {
                sheet.shiftRows(i + 1, lastRowNum, -1);
            }
            if (i == lastRowNum && row != null) {
                sheet.removeRow(row);
            }
            --i;
        }
        return sheet;
    }

    protected static boolean isRowEmpty(Row row) {
        if (row == null) {
            return true;
        }
        int firstCellNum = row.getFirstCellNum();
        short lastCellNum = row.getLastCellNum();
        int nullCellNum = 0;
        for (int c = firstCellNum; c < lastCellNum; ++c) {
            String cellValue;
            Cell cell = row.getCell(c);
            if (null == cell || cell.getCellType() == CellType.BLANK) {
                ++nullCellNum;
                continue;
            }
            if (!CellType.STRING.equals((Object)cell.getCellTypeEnum()) || !StringUtils.isEmpty((String)(cellValue = cell.getStringCellValue().trim()))) continue;
            ++nullCellNum;
        }
        return nullCellNum == lastCellNum - firstCellNum;
    }

    public static List<String> getBusinessKeyList(List<CellTypeContainer> cellTypeContainerList) {
        if (CollectionUtils.isEmpty(cellTypeContainerList)) {
            return new ArrayList<String>();
        }
        return cellTypeContainerList.stream().filter(cellTypeContainer -> cellTypeContainer.getBusinessKey()).map(CellTypeContainer::getKeyName).collect(Collectors.toList());
    }

    protected static Object parseCell(Cell cell, CellType metaCellType, MetaDataType metaType) {
        Object obj;
        CellType cellType = cell.getCellTypeEnum();
        switch (cellType) {
            case FORMULA: {
                try {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        obj = date.getYear() + 1900 + "-" + (date.getMonth() + 1) + "-" + date.getDate();
                        break;
                    }
                    obj = String.valueOf(cell.getNumericCellValue());
                }
                catch (IllegalStateException e) {
                    obj = String.valueOf(cell.getRichStringCellValue());
                }
                break;
            }
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case NUMERIC: {
                SimpleDateFormat sdf;
                short number58 = 58;
                switch (metaType) {
                    case DATE: {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        break;
                    }
                    case DATETIME: {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        break;
                    }
                    case TIME: {
                        sdf = new SimpleDateFormat("HH:mm:ss");
                        break;
                    }
                    default: {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                }
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    obj = sdf.format(date);
                    break;
                }
                if (cell.getCellStyle().getDataFormat() == number58) {
                    double value = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)value);
                    obj = sdf.format(date);
                    break;
                }
                double dValue = cell.getNumericCellValue();
                Double obj2 = dValue;
                return obj2;
            }
            default: {
                obj = cell.getStringCellValue();
            }
        }
        if (null == metaCellType) {
            return obj;
        }
        switch (metaCellType) {
            case STRING: {
                return null == obj ? "" : obj.toString();
            }
        }
        return obj;
    }

    private static String getFileExtension(String filePath) {
        if (StringUtils.isEmpty((String)filePath)) {
            return null;
        }
        int lastIndexOf = filePath.lastIndexOf(".");
        if (lastIndexOf != -1) {
            String extension = filePath.substring(lastIndexOf + 1);
            return extension;
        }
        return null;
    }

    public static String getSheetNameInParens(String sheetName) {
        String regex = "[\\(\uff08](.*?)[\\)\uff09]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(sheetName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return sheetName;
    }

    public static boolean isValidDate(String dateString, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        formatter.setLenient(false);
        try {
            formatter.parse(dateString);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

