/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.application.dto.request.UploadBatchFileReq;
import com.digiwin.athena.abt.application.dto.request.UploadBatchReq;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonToMd5Converter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonToMd5Converter.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    public static Map<Integer, UploadBatchFileReq> getFileUids(UploadBatchReq uploadBatchReq) {
        HashMap<Integer, UploadBatchFileReq> result = new HashMap<Integer, UploadBatchFileReq>(uploadBatchReq.getFiles().size());
        try {
            List<UploadBatchFileReq> files = uploadBatchReq.getFiles();
            for (int i = 0; i < files.size(); ++i) {
                UploadBatchFileReq currentFile = files.get(i);
                UploadBatchReq modifiedReq = JsonToMd5Converter.buildModifiedRequest(uploadBatchReq);
                String sortedJson = JsonToMd5Converter.convertToSortedJson(modifiedReq);
                String combined = sortedJson + ":" + currentFile.getCheckSum();
                log.info("Filtered JSON: " + combined);
                String fileUid = JsonToMd5Converter.generateMD5(combined);
                log.info("Generated MD5 ID: " + fileUid);
                currentFile.setFileUid(fileUid);
                result.put(i, currentFile);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6md5\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    private static List<UploadBatchFileReq> createModifiedFiles(List<UploadBatchFileReq> originalFiles) {
        ArrayList<UploadBatchFileReq> modifiedFiles = new ArrayList<UploadBatchFileReq>();
        for (UploadBatchFileReq file : originalFiles) {
            UploadBatchFileReq modifiedFile = new UploadBatchFileReq();
            modifiedFile.setFileName(null);
            modifiedFile.setFileUrl(null);
            modifiedFile.setCheckSum(null);
            modifiedFiles.add(modifiedFile);
        }
        return modifiedFiles;
    }

    private static UploadBatchReq buildModifiedRequest(UploadBatchReq original) {
        return UploadBatchReq.builder().actionId(original.getActionId()).activityId(original.getActivityId()).actionInfo(original.getActionInfo()).requiredFields(original.getRequiredFields()).isReImport(original.getIsReImport()).files(null).build();
    }

    private static String convertToSortedJson(UploadBatchReq obj) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)obj);
    }

    private static String generateMD5(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(input.getBytes());
        return JsonToMd5Converter.bytesToHex(digest);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void main(String[] args) throws Exception {
    }
}

