/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.utils;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@PropertySource(value={"classpath:i18n/messages*.properties"})
public class MessageUtil {
    private static final Map<String, ResourceBundle> MESSAGES = new HashMap<String, ResourceBundle>();

    public static String getMessage(String key, Object ... params) {
        String locale1 = null;
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes == null) {
            locale1 = "zh_CN";
        } else {
            HttpServletRequest request = servletRequestAttributes.getRequest();
            String string = locale1 = request == null ? "zh_CN" : request.getHeader("locale");
            if (StringUtils.isEmpty((String)locale1)) {
                locale1 = "zh_CN";
            }
        }
        return MessageUtil.getMessageByLocale(key, locale1, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessageByLocale(String key, String locale1, Object ... params) {
        String[] s = locale1.split("_");
        Locale locale = new Locale(s[0], s[1]);
        ResourceBundle message = MESSAGES.get(locale.toString());
        if (message == null) {
            Map<String, ResourceBundle> map = MESSAGES;
            synchronized (map) {
                message = MESSAGES.get(locale.toString());
                if (message == null) {
                    message = ResourceBundle.getBundle("i18n/messages", locale);
                    MESSAGES.put(locale.toString(), message);
                }
            }
        }
        if (params != null) {
            try {
                if (locale1.equals("zh_CN")) {
                    return String.format(new String(message.getString(key).getBytes("UTF-8"), "UTF-8"), params);
                }
                return String.format(message.getString(key), params);
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
        try {
            if (locale1.equals("zh_CN")) {
                return new String(message.getString(key).getBytes("UTF-8"), "UTF-8");
            }
            return String.format(message.getString(key), params);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(MessageUtil.getMessageByLocale("basedata.nofile", "zh_CN", new Object[0]));
        System.out.println(MessageUtil.getMessageByLocale("basedata.nofile", "zh_TW", new Object[0]));
        String[] s = "zh_CN".split("_");
        Locale locale = new Locale(s[0], s[1]);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n/message", locale);
        System.out.println(resourceBundle.getString("basedata.nofile"));
        System.out.println(new String(resourceBundle.getString("basedata.nofile").getBytes("UTF-8"), "UTF-8"));
        String[] s1 = "zh_TW".split("_");
        Locale locale1 = new Locale(s1[0], s1[1]);
        ResourceBundle resourceBundle1 = ResourceBundle.getBundle("i18n/message", locale1);
        System.out.println(resourceBundle1.getString("basedata.nofile"));
        System.out.println(new String(resourceBundle1.getString("basedata.nofile").getBytes("UTF-8"), "UTF-8"));
    }

    public static void flushMessage() {
        MESSAGES.clear();
    }
}

