/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.springframework.util.StringUtils;

public class NetUtil {
    private static String localMac;

    public static String getLocalMac() {
        byte[] mac;
        if (!StringUtils.isEmpty((Object)localMac)) {
            return localMac;
        }
        InetAddress ia = null;
        try {
            ia = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0069.getErrCode(), (String)MessageUtil.getMessage("delivery.getInetError", new Object[0]));
        }
        try {
            mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        }
        catch (SocketException e) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0070.getErrCode(), (String)MessageUtil.getMessage("delivery.getMacError", new Object[0]));
        }
        StringBuffer sb = new StringBuffer("");
        if (mac == null) {
            return "";
        }
        for (int i = 0; i < mac.length; ++i) {
            int temp;
            String str;
            if (i != 0) {
                sb.append("-");
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0" + str);
                continue;
            }
            sb.append(str);
        }
        localMac = sb.toString().toUpperCase();
        return localMac;
    }
}

