/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageReceiverDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.dto.migration.atmc.usersetting.PersonalizedDto;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.ShareService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.emc.SendEmailService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoticeMessageUtil {
    private static final Logger logger = LoggerFactory.getLogger(NoticeMessageUtil.class);
    private static final String ACTIVITY = "activity";
    private static final String TASK = "task";
    @Autowired
    private UserService userService;
    @Autowired
    private SendEmailService sendEmailService;
    @Autowired
    private ShareService shareService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TaskMapper taskMapper;

    public void sendRemindNotice(AppMessageDTO appMessageDTO) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (null == appMessageDTO.getReceivers() || appMessageDTO.getReceivers().isEmpty()) {
            logger.warn("no member need to send notice to client.");
            return;
        }
        ArrayList<AppMessageReceiverDTO> receiveList = new ArrayList<AppMessageReceiverDTO>();
        for (AppMessageReceiverDTO appMessageReceiverDTO : appMessageDTO.getReceivers()) {
            int n = this.checkSendType(appMessageReceiverDTO.getTenantSid(), appMessageReceiverDTO.getUserId());
            if (0 == n) continue;
            receiveList.add(appMessageReceiverDTO);
        }
        ArrayList receiverLists = new ArrayList();
        for (AppMessageReceiverDTO appMessageReceiverDTO : receiveList) {
            HashMap<String, String> receiverMap = new HashMap<String, String>();
            receiverMap.put("userId", appMessageReceiverDTO.getUserId());
            receiverMap.put("email", this.userService.queryUserEmail(appMessageReceiverDTO.getUserId()));
            receiverMap.put("templateId", this.getUserTemplateId(appMessageReceiverDTO.getUserId(), authoredUser.getToken()));
            receiverLists.add(receiverMap);
        }
        MessageDO messageDO = new MessageDO();
        messageDO.setType(appMessageDTO.getType());
        messageDO.setContent(appMessageDTO.getContent());
        messageDO.setTenantId(this.getTargetTenantId(appMessageDTO.getReceivers()));
        Map<String, Object> map = this.dealNoticeMailMessage(authoredUser, messageDO);
        for (Map map2 : receiverLists) {
            String email = MapUtils.getString((Map)map2, (Object)"email");
            String userId = MapUtils.getString((Map)map2, (Object)"userId");
            String templateId = MapUtils.getString((Map)map2, (Object)"templateId");
            if (StringUtils.isBlank((String)email)) {
                logger.warn("send {} to user:{} with no email", map, (Object)userId);
                continue;
            }
            this.sendEmailService.sendEmailWithTemplate(templateId, email, map, null);
        }
    }

    public int checkSendType(Long tenantSid, String userId) {
        PersonalizedDto userData = this.userService.queryPersonalizedInfo(tenantSid, userId, "MessageSendType", "basic");
        if (null == userData || StringUtils.isEmpty((String)userData.getValue())) {
            return 0;
        }
        switch (userData.getValue()) {
            case "mail": {
                return 1;
            }
            case "imAndMail": {
                return 2;
            }
        }
        return 0;
    }

    private String getUserTemplateId(String userId, String token) {
        String langName = this.userService.getUserLangMetadataAllTenant(userId, token);
        if (StringUtils.isBlank((String)langName)) {
            langName = "zh_CN";
        }
        return "ATHENA_ATMC_MAIL_NOTICE_" + langName;
    }

    private String getTargetTenantId(List<AppMessageReceiverDTO> receivers) {
        if (CollectionUtils.isEmpty(receivers)) {
            return "";
        }
        return receivers.get(0).getTenantId();
    }

    private Map<String, Object> dealNoticeMailMessage(AuthoredUser user, MessageDO message) {
        String content;
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Map map = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)message.getContent()), Map.class);
        map.put("targetTenantId", message.getTenantId());
        String linkUrl = this.generateLinkUrl(user, message.getType(), map);
        if (StringUtils.isNotBlank((String)linkUrl)) {
            retMap.put("linkUrl", linkUrl);
        }
        String title = MapUtils.getString((Map)map, (Object)"title");
        if (StringUtils.isNotBlank((String)MapUtils.getString((Map)map, (Object)"emailMsg"))) {
            String msg;
            content = msg = MapUtils.getString((Map)map, (Object)"emailMsg");
        } else {
            String msg = MapUtils.getString((Map)map, (Object)"msg");
            content = title + msg;
        }
        retMap.put("title", title);
        retMap.put("content", content);
        if (MapUtils.isNotEmpty((Map)MapUtils.getMap((Map)map, (Object)"data"))) {
            retMap.putAll(MapUtils.getMap((Map)map, (Object)"data"));
        }
        return retMap;
    }

    public String generateLinkUrl(AuthoredUser user, String type, Map<String, Object> map) {
        String urlDetail = "";
        if (ACTIVITY.equals(type) || TASK.equals(type)) {
            String defaultType;
            String id = MapUtils.getString(map, (Object)"id");
            String targetTenantId = MapUtils.getString(map, (Object)"targetTenantId");
            if (ACTIVITY.equals(type)) {
                defaultType = TASK;
                urlDetail = "task/detail/" + id + "?targetTenantId=" + targetTenantId + "&shareCode=";
            } else {
                defaultType = "project";
                urlDetail = "project/share/" + id + "/";
            }
            String shareCode = this.shareService.createSharingCode(user, defaultType, MapUtils.getLong(map, (Object)"id"));
            Task task = this.taskMapper.selectPartialById(Long.valueOf(id));
            if (task == null) {
                urlDetail = this.envProperties.getWebUri() + urlDetail + shareCode + "?engineType=TaskEngine";
                if (urlDetail.contains("project")) {
                    urlDetail = urlDetail + "&targetTenantId=" + targetTenantId;
                }
            } else {
                urlDetail = this.envProperties.getWebUri() + urlDetail + shareCode;
                if (urlDetail.contains("project")) {
                    urlDetail = urlDetail + "?targetTenantId=" + targetTenantId;
                }
            }
        }
        return urlDetail;
    }

    public void sendNoticeWithMail(AuthoredUser user, MessageDO message) {
        logger.info("[messeage] : {}", (Object)message);
        String email = this.userService.queryUserEmail(message.getUserId());
        if (StringUtils.isEmpty((String)email)) {
            logger.debug("Notice user with no email info.{}", (Object)(user.getUserId() + user));
            return;
        }
        Map<String, Object> mailData = this.dealNoticeMailMessage(user, message);
        String templateId = this.getUserTemplateId(message.getUserId(), user.getToken());
        this.sendEmailService.sendEmailWithTemplate(templateId, email, mailData, null);
    }
}

