/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.event.job;

import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardJobData;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardTaskContext;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.TenantService;
import com.digiwin.athena.abt.application.utils.AppAuthContextUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class RefreshCardJob
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshCardJob.class);
    @Resource
    private RefreshCardMessageService refreshCardMessageService;
    @Resource
    private TenantService tenantService;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        try {
            JobDetail jobDetail = jobExecutionContext.getJobDetail();
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            Set cardData = (Set)jobDataMap.get((Object)"data");
            log.info("\u4efb\u52a1\u6267\u884c\u6570\u636e:{}", (Object)JsonUtils.objectToString((Object)cardData));
            if (CollectionUtils.isNotEmpty((Collection)cardData)) {
                HashMap idErrorCount = Maps.newHashMapWithExpectedSize((int)2);
                Map<String, Map<String, Map<String, List<CardJobData>>>> groupMap = cardData.stream().collect(Collectors.groupingBy(CardJobData::getTenantId, Collectors.groupingBy(CardJobData::getPagCode, Collectors.groupingBy(CardJobData::getCode))));
                groupMap.forEach((tenantId, v) -> {
                    JSONObject apiResult = this.tenantService.queryApiVirtualToken((String)tenantId);
                    String virtualToken = apiResult.getString("token");
                    AuthoredUser authoredUser = AppAuthContextUtils.setAuthoredUserContext(virtualToken);
                    authoredUser.setTenantId(apiResult.getString("tenantId"));
                    CardTaskContext cardTaskContext = new CardTaskContext(authoredUser, jobDataMap.getInt("partition_size"), jobDataMap.getInt("singleTaskSize"), jobDataMap.getInt("batchTaskSize"), jobDataMap.getInt("max_error_size"));
                    v.forEach((pageCode, v1) -> v1.forEach((code, v2) -> {
                        CardJobData cardJobData = (CardJobData)v2.get(0);
                        this.refreshCardMessageService.refreshTaskCard(cardTaskContext, cardJobData);
                    }));
                    idErrorCount.putAll(cardTaskContext.getIdErrorCount());
                });
                Object errorCount = jobDataMap.get((Object)"id_error_count");
                if (errorCount != null) {
                    Map prevIdErrorCount = (Map)errorCount;
                    idErrorCount.forEach((k, v) -> {
                        Map idErrorMap = (Map)prevIdErrorCount.get(k);
                        if (idErrorMap != null) {
                            for (Map.Entry entry : v.entrySet()) {
                                Long key = (Long)entry.getKey();
                                Integer num = (Integer)idErrorMap.get(key);
                                if (num == null) continue;
                                v.put(key, (Integer)entry.getValue() + num);
                            }
                        }
                    });
                    jobDataMap.put("id_error_count", (Object)idErrorCount);
                }
            }
        }
        catch (Exception e) {
            log.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u62a5\u9519:{}", (Object)e.getMessage());
        }
    }
}

