/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.event.job;

import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardMessageDTO;
import com.digiwin.athena.abt.application.service.abt.migration.quartz.JobManager;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageService;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.Generated;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RefreshCardMessageJob
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshCardMessageJob.class);
    @Autowired
    private JobManager jobManager;
    @Autowired
    private RefreshCardMessageService refreshMessageService;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        RefreshCardMessageDTO refreshCardMessageDTO = this.parseJobData(context.getJobDetail().getJobDataMap());
        JobKey jobKey = context.getTrigger().getJobKey();
        String jobName = jobKey.getName();
        String jobGroupName = jobKey.getGroup();
        if (null == refreshCardMessageDTO) {
            log.warn("refresh card message job:{}.{} lack jobData, will delete..", (Object)jobName, (Object)jobGroupName);
            this.refreshMessageService.deleteRefreshCardMessageJob(jobName);
            return;
        }
        log.info("fire refresh card message job:{}.{}", (Object)jobName, (Object)jobGroupName);
        try {
            this.doRefreshCardMessage(refreshCardMessageDTO);
            this.resetConFailCount(refreshCardMessageDTO);
        }
        catch (Exception ex) {
            log.warn("fire fresh card message job:{}.{} error:{}", new Object[]{jobName, jobGroupName, ex});
            this.handleJobFiredError(jobName, jobGroupName, refreshCardMessageDTO);
        }
    }

    private void handleJobFiredError(String jobName, String jobGroupName, RefreshCardMessageDTO refreshCardMessageDTO) {
        int conFailCount = refreshCardMessageDTO.getConFailCount();
        if (++conFailCount >= 24) {
            log.warn("fire refresh card message job:{}.{} conFailCount({}) ge {}, will delete..", new Object[]{jobName, jobGroupName, conFailCount, 24});
            this.refreshMessageService.deleteRefreshCardMessageJob(jobName);
        } else {
            log.warn("fire refresh card message job:{}.{} conFailCount({}) lt {}, will increase and refresh conFailCount..", new Object[]{jobName, jobGroupName, conFailCount, 24});
            refreshCardMessageDTO.setConFailCount(conFailCount);
            this.refreshMessageService.updateRefreshCardMessageJobData(refreshCardMessageDTO);
        }
    }

    private void doRefreshCardMessage(RefreshCardMessageDTO refreshCardMessageDTO) {
        this.refreshMessageService.refreshCardMessage(refreshCardMessageDTO);
    }

    private void resetConFailCount(RefreshCardMessageDTO refreshCardMessageDTO) {
        if (refreshCardMessageDTO.getConFailCount() <= 0) {
            return;
        }
        boolean jobExist = this.jobManager.exist(String.valueOf(refreshCardMessageDTO.getId()), "REFRESH_TASK_MESSAGE_GROUP");
        if (!jobExist) {
            return;
        }
        refreshCardMessageDTO.setConFailCount(0);
        log.info("reset refresh card message conFailCount, job:{}.{}", (Object)refreshCardMessageDTO.getId(), (Object)"REFRESH_TASK_MESSAGE_GROUP");
        this.refreshMessageService.updateRefreshCardMessageJobData(refreshCardMessageDTO);
    }

    private RefreshCardMessageDTO parseJobData(JobDataMap jobDataMap) {
        if (null == jobDataMap || jobDataMap.isEmpty()) {
            return null;
        }
        try {
            return (RefreshCardMessageDTO)JsonUtils.jsonToObject((String)jobDataMap.getString("data"), RefreshCardMessageDTO.class);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

