package com.digiwin.athena.abt;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.loadbalance.scan.DWPathScan;
import com.jugg.agile.framework.core.dapper.alarm.JaNotify;
import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * 启动类
 */
@Slf4j
@DWPathScan
@EnableScheduling
@SpringBootApplication(exclude = {MongoAutoConfiguration.class}, scanBasePackages = {"com.digiwin.athena.abt", "com.digiwin.athena.atdm"})
public class AbtApplication {
    public static void main(String[] args) throws Throwable {
        JaNotify.notifyRun(() -> SpringApplication.run(AbtApplication.class, args));
    }
}
